/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.util;

import com.google.inject.Singleton;
import com.plotsquared.bukkit.player.BukkitOfflinePlayer;
import com.plotsquared.bukkit.player.BukkitPlayer;
import com.plotsquared.core.player.OfflinePlotPlayer;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.util.EconHandler;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.checkerframework.checker.nullness.qual.NonNull;

@Singleton
public class BukkitEconHandler
extends EconHandler {
    private Economy econ;

    private static OfflinePlayer getBukkitOfflinePlayer(PlotPlayer<?> plotPlayer) {
        return ((BukkitPlayer)plotPlayer).player;
    }

    public boolean init() {
        if (this.econ == null) {
            this.setupEconomy();
        }
        return this.econ != null;
    }

    private void setupEconomy() {
        if (Bukkit.getServer().getPluginManager().getPlugin("Vault") == null) {
            return;
        }
        RegisteredServiceProvider economyProvider = Bukkit.getServer().getServicesManager().getRegistration(Economy.class);
        if (economyProvider != null) {
            this.econ = (Economy)economyProvider.getProvider();
        }
    }

    public double getMoney(PlotPlayer<?> player) {
        double bal = super.getMoney(player);
        if (Double.isNaN(bal)) {
            return this.econ.getBalance(BukkitEconHandler.getBukkitOfflinePlayer(player));
        }
        return bal;
    }

    public void withdrawMoney(PlotPlayer<?> player, double amount) {
        this.econ.withdrawPlayer(BukkitEconHandler.getBukkitOfflinePlayer(player), amount);
    }

    public void depositMoney(PlotPlayer<?> player, double amount) {
        this.econ.depositPlayer(BukkitEconHandler.getBukkitOfflinePlayer(player), amount);
    }

    public void depositMoney(OfflinePlotPlayer player, double amount) {
        this.econ.depositPlayer(((BukkitOfflinePlayer)player).player, amount);
    }

    public boolean isEnabled(PlotArea plotArea) {
        return plotArea.useEconomy();
    }

    public @NonNull String format(double balance) {
        return this.econ.format(balance);
    }

    public boolean isSupported() {
        return true;
    }

    public double getBalance(PlotPlayer<?> player) {
        return this.econ.getBalance(BukkitEconHandler.getBukkitOfflinePlayer(player));
    }
}

