/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.util;

import com.google.inject.Singleton;
import com.plotsquared.bukkit.player.BukkitPlayer;
import com.plotsquared.bukkit.util.BukkitUtil;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.PlotInventory;
import com.plotsquared.core.plot.PlotItemStack;
import com.plotsquared.core.util.InventoryUtil;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.item.ItemType;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.checkerframework.checker.nullness.qual.Nullable;

@Singleton
public class BukkitInventoryUtil
extends InventoryUtil {
    private static @Nullable ItemStack getItem(PlotItemStack item) {
        if (item == null) {
            return null;
        }
        Material material = BukkitAdapter.adapt((ItemType)item.getType());
        if (material == null) {
            return null;
        }
        ItemStack stack = new ItemStack(material, item.getAmount());
        ItemMeta meta = null;
        if (item.getName() != null) {
            meta = stack.getItemMeta();
            Component nameComponent = BukkitUtil.MINI_MESSAGE.parse(item.getName());
            meta.setDisplayName(BukkitUtil.LEGACY_COMPONENT_SERIALIZER.serialize(nameComponent));
        }
        if (item.getLore() != null) {
            if (meta == null) {
                meta = stack.getItemMeta();
            }
            ArrayList<String> lore = new ArrayList<String>();
            for (String entry : item.getLore()) {
                lore.add(BukkitUtil.LEGACY_COMPONENT_SERIALIZER.serialize(BukkitUtil.MINI_MESSAGE.deserialize((Object)entry)));
            }
            meta.setLore(lore);
        }
        if (meta != null) {
            stack.setItemMeta(meta);
        }
        return stack;
    }

    public void open(PlotInventory inv) {
        BukkitPlayer bp = (BukkitPlayer)inv.getPlayer();
        Inventory inventory = Bukkit.createInventory(null, (int)(inv.getLines() * 9), (String)ChatColor.translateAlternateColorCodes((char)'&', (String)inv.getTitle()));
        PlotItemStack[] items = inv.getItems();
        for (int i = 0; i < inv.getLines() * 9; ++i) {
            PlotItemStack item = items[i];
            if (item == null) continue;
            inventory.setItem(i, BukkitInventoryUtil.getItem(item));
        }
        bp.player.openInventory(inventory);
    }

    public void close(PlotInventory inv) {
        if (!inv.isOpen()) {
            return;
        }
        BukkitPlayer bp = (BukkitPlayer)inv.getPlayer();
        bp.player.closeInventory();
    }

    public boolean setItemChecked(PlotInventory inv, int index, PlotItemStack item) {
        BukkitPlayer bp = (BukkitPlayer)inv.getPlayer();
        InventoryView opened = bp.player.getOpenInventory();
        ItemStack stack = BukkitInventoryUtil.getItem(item);
        if (stack == null) {
            return false;
        }
        if (!inv.isOpen()) {
            return true;
        }
        opened.setItem(index, stack);
        bp.player.updateInventory();
        return true;
    }

    public PlotItemStack getItem(ItemStack item) {
        if (item == null) {
            return null;
        }
        Material id = item.getType();
        ItemMeta meta = item.getItemMeta();
        int amount = item.getAmount();
        String name = null;
        String[] lore = null;
        if (item.hasItemMeta()) {
            assert (meta != null);
            if (meta.hasDisplayName()) {
                name = meta.getDisplayName();
            }
            if (meta.hasLore()) {
                List itemLore = meta.getLore();
                assert (itemLore != null);
                lore = itemLore.toArray(new String[0]);
            }
        }
        return new PlotItemStack(id.name(), amount, name, lore);
    }

    public PlotItemStack[] getItems(PlotPlayer<?> player) {
        BukkitPlayer bp = (BukkitPlayer)player;
        PlayerInventory inv = bp.player.getInventory();
        return (PlotItemStack[])IntStream.range(0, 36).mapToObj(i -> this.getItem(inv.getItem(i))).toArray(PlotItemStack[]::new);
    }

    public boolean isOpen(PlotInventory plotInventory) {
        if (!plotInventory.isOpen()) {
            return false;
        }
        BukkitPlayer bp = (BukkitPlayer)plotInventory.getPlayer();
        InventoryView opened = bp.player.getOpenInventory();
        if (plotInventory.isOpen() && opened.getType() == InventoryType.CRAFTING) {
            opened.getTitle();
        }
        return false;
    }
}

