/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.util.task;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.plotsquared.bukkit.BukkitPlatform;
import com.plotsquared.bukkit.util.task.BukkitPlotSquaredTask;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.util.task.PlotSquaredTask;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.core.util.task.TaskTime;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.checkerframework.checker.nullness.qual.NonNull;

@Singleton
public class BukkitTaskManager
extends TaskManager {
    private final BukkitPlatform bukkitMain;
    private final TaskTime.TimeConverter timeConverter;

    @Inject
    public BukkitTaskManager(@NonNull BukkitPlatform bukkitMain, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull TaskTime.TimeConverter timeConverter) {
        this.bukkitMain = bukkitMain;
        this.timeConverter = timeConverter;
    }

    public PlotSquaredTask taskRepeat(@NonNull Runnable runnable, @NonNull TaskTime taskTime) {
        long ticks = this.timeConverter.toTicks(taskTime);
        BukkitPlotSquaredTask bukkitPlotSquaredTask = new BukkitPlotSquaredTask(runnable);
        bukkitPlotSquaredTask.runTaskTimer((Plugin)this.bukkitMain, ticks, ticks);
        return bukkitPlotSquaredTask;
    }

    public PlotSquaredTask taskRepeatAsync(@NonNull Runnable runnable, @NonNull TaskTime taskTime) {
        long ticks = this.timeConverter.toTicks(taskTime);
        BukkitPlotSquaredTask bukkitPlotSquaredTask = new BukkitPlotSquaredTask(runnable);
        bukkitPlotSquaredTask.runTaskTimerAsynchronously((Plugin)this.bukkitMain, ticks, ticks);
        return bukkitPlotSquaredTask;
    }

    public void taskAsync(@NonNull Runnable runnable) {
        if (this.bukkitMain.isEnabled()) {
            new BukkitPlotSquaredTask(runnable).runTaskAsynchronously((Plugin)this.bukkitMain);
        } else {
            runnable.run();
        }
    }

    public <T> T sync(@NonNull Callable<T> function, int timeout) throws Exception {
        if (PlotSquared.get().isMainThread(Thread.currentThread())) {
            return function.call();
        }
        return this.callMethodSync(function).get(timeout, TimeUnit.MILLISECONDS);
    }

    public <T> Future<T> callMethodSync(@NonNull Callable<T> method) {
        return Bukkit.getScheduler().callSyncMethod((Plugin)this.bukkitMain, method);
    }

    public void task(@NonNull Runnable runnable) {
        new BukkitPlotSquaredTask(runnable).runTask((Plugin)this.bukkitMain);
    }

    public void taskLater(@NonNull Runnable runnable, @NonNull TaskTime taskTime) {
        long delay = this.timeConverter.toTicks(taskTime);
        new BukkitPlotSquaredTask(runnable).runTaskLater((Plugin)this.bukkitMain, delay);
    }

    public void taskLaterAsync(@NonNull Runnable runnable, @NonNull TaskTime taskTime) {
        long delay = this.timeConverter.toTicks(taskTime);
        new BukkitPlotSquaredTask(runnable).runTaskLaterAsynchronously((Plugin)this.bukkitMain, delay);
    }
}

