/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.uuid;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.plotsquared.core.uuid.UUIDMapping;
import com.plotsquared.core.uuid.UUIDService;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.checkerframework.checker.nullness.qual.NonNull;

public class PaperUUIDService
implements UUIDService {
    public @NonNull List<UUIDMapping> getNames(@NonNull List<UUID> uuids) {
        ArrayList<UUIDMapping> mappings = new ArrayList<UUIDMapping>(uuids.size());
        for (UUID uuid : uuids) {
            PlayerProfile playerProfile = Bukkit.createProfile((UUID)uuid);
            if (!playerProfile.isComplete() && !playerProfile.completeFromCache() || playerProfile.getId() == null) continue;
            mappings.add(new UUIDMapping(playerProfile.getId(), playerProfile.getName()));
        }
        return mappings;
    }

    public @NonNull List<UUIDMapping> getUUIDs(@NonNull List<String> usernames) {
        ArrayList<UUIDMapping> mappings = new ArrayList<UUIDMapping>(usernames.size());
        for (String username : usernames) {
            PlayerProfile playerProfile = Bukkit.createProfile((String)username);
            if (!playerProfile.isComplete() && !playerProfile.completeFromCache() || playerProfile.getId() == null) continue;
            mappings.add(new UUIDMapping(playerProfile.getId(), playerProfile.getName()));
        }
        return mappings;
    }
}

