/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.google.inject.Inject;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.StaticCaption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.MetaDataAccess;
import com.plotsquared.core.player.PlayerMetaDataKeys;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.plot.schematic.Schematic;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.SchematicHandler;
import com.plotsquared.core.util.TimeUtil;
import com.plotsquared.core.util.task.RunnableVal;
import com.plotsquared.core.util.task.TaskManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import net.kyori.adventure.text.minimessage.Template;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="load", aliases={"restore"}, category=CommandCategory.SCHEMATIC, requiredType=RequiredType.NONE, permission="plots.load", usage="/plot load")
public class Load
extends SubCommand {
    private final PlotAreaManager plotAreaManager;
    private final SchematicHandler schematicHandler;

    @Inject
    public Load(@NonNull PlotAreaManager plotAreaManager, @NonNull SchematicHandler schematicHandler) {
        this.plotAreaManager = plotAreaManager;
        this.schematicHandler = schematicHandler;
    }

    @Override
    public boolean onCommand(final PlotPlayer<?> player, String[] args) {
        String world = player.getLocation().getWorldName();
        if (!this.plotAreaManager.hasPlotArea(world)) {
            player.sendMessage(TranslatableCaption.of("errors.not_in_plot_world"), new Template[0]);
            return false;
        }
        final Plot plot = player.getCurrentPlot();
        if (plot == null) {
            player.sendMessage(TranslatableCaption.of("errors.not_in_plot"), new Template[0]);
            return false;
        }
        if (!plot.hasOwner()) {
            player.sendMessage(TranslatableCaption.of("info.plot_unowned"), new Template[0]);
            return false;
        }
        if (!plot.isOwner(player.getUUID()) && !player.hasPermission(Permission.PERMISSION_ADMIN_COMMAND_LOAD)) {
            player.sendMessage(TranslatableCaption.of("permission.no_plot_perms"), new Template[0]);
            return false;
        }
        if (plot.getRunning() > 0) {
            player.sendMessage(TranslatableCaption.of("errors.wait_for_timer"), new Template[0]);
            return false;
        }
        try (MetaDataAccess<List<String>> metaDataAccess = player.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_SCHEMATICS);){
            if (args.length != 0) {
                if (args.length == 1) {
                    URL url;
                    String schematic;
                    List schematics = metaDataAccess.get().orElse(null);
                    if (schematics == null) {
                        player.sendMessage(TranslatableCaption.of("web.load_null"), Template.of((String)"command", (String)"/plot load"));
                        boolean bl = false;
                        return bl;
                    }
                    try {
                        schematic = (String)schematics.get(Integer.parseInt(args[0]) - 1);
                    }
                    catch (Exception ignored) {
                        player.sendMessage(TranslatableCaption.of("invalid.not_valid_number"), Template.of((String)"value", (String)("(1, " + schematics.size() + ")")));
                        boolean bl = false;
                        if (metaDataAccess != null) {
                            metaDataAccess.close();
                        }
                        return bl;
                    }
                    try {
                        url = new URL(Settings.Web.URL + "saves/" + player.getUUID() + "/" + schematic);
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                        player.sendMessage(TranslatableCaption.of("web.load_failed"), new Template[0]);
                        boolean bl = false;
                        if (metaDataAccess != null) {
                            metaDataAccess.close();
                        }
                        return bl;
                    }
                    plot.addRunning();
                    player.sendMessage(TranslatableCaption.of("working.generating_component"), new Template[0]);
                    TaskManager.runTaskAsync(() -> {
                        Schematic taskSchematic = this.schematicHandler.getSchematic(url);
                        if (taskSchematic == null) {
                            plot.removeRunning();
                            player.sendMessage(TranslatableCaption.of("schematics.schematic_invalid"), Template.of((String)"reason", (String)"non-existent or not in gzip format"));
                            return;
                        }
                        PlotArea area = plot.getArea();
                        this.schematicHandler.paste(taskSchematic, plot, 0, area.getMinBuildHeight(), 0, false, player, new RunnableVal<Boolean>(){

                            @Override
                            public void run(Boolean value) {
                                plot.removeRunning();
                                if (value.booleanValue()) {
                                    player.sendMessage(TranslatableCaption.of("schematics.schematic_paste_success"), new Template[0]);
                                } else {
                                    player.sendMessage(TranslatableCaption.of("schematics.schematic_paste_failed"), new Template[0]);
                                }
                            }
                        });
                    });
                    boolean bl = true;
                    return bl;
                }
                plot.removeRunning();
                player.sendMessage(TranslatableCaption.of("commandconfig.command_syntax"), Template.of((String)"value", (String)"/plot load <index>"));
                boolean schematics = false;
                return schematics;
            }
            List schematics = metaDataAccess.get().orElse(null);
            if (schematics == null) {
                plot.addRunning();
                TaskManager.runTaskAsync(() -> {
                    List<String> schematics1 = this.schematicHandler.getSaves(player.getUUID());
                    plot.removeRunning();
                    if (schematics1 == null || schematics1.isEmpty()) {
                        player.sendMessage(TranslatableCaption.of("web.load_failed"), new Template[0]);
                        return;
                    }
                    metaDataAccess.set(schematics1);
                    this.displaySaves(player);
                });
            } else {
                this.displaySaves(player);
            }
        }
        return true;
    }

    public void displaySaves(PlotPlayer<?> player) {
        try (MetaDataAccess<List<String>> metaDataAccess = player.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_SCHEMATICS);){
            List schematics = metaDataAccess.get().orElse(Collections.emptyList());
            for (int i = 0; i < Math.min(schematics.size(), 32); ++i) {
                try {
                    String schematic = ((String)schematics.get(i)).split("\\.")[0];
                    String[] split = schematic.split("_");
                    if (split.length < 5) continue;
                    String time = TimeUtil.secToTime(System.currentTimeMillis() / 1000L - Long.parseLong(split[0]));
                    String world = split[1];
                    PlotId id = PlotId.fromString(split[2] + ";" + split[3]);
                    String size = split[4];
                    String color = "<dark_aqua>";
                    player.sendMessage(StaticCaption.of("<dark_gray>[</dark_gray><gray>" + (i + 1) + "</gray><dark_aqua>] </dark_aqua>" + color + time + "<dark_gray> | </dark_gray>" + color + world + ";" + id + "<dark_gray> | </dark_gray>" + color + size + "x" + size), new Template[0]);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            player.sendMessage(TranslatableCaption.of("web.load_list"), Template.of((String)"command", (String)"/plot load #"));
        }
    }

    @Deprecated(forRemoval=true, since="6.6.2")
    public String secToTime(long time) {
        StringBuilder toreturn = new StringBuilder();
        if (time >= 33868800L) {
            int years = (int)(time / 33868800L);
            time -= (long)(years * 33868800);
            toreturn.append(years).append("y ");
        }
        if (time >= 604800L) {
            int weeks = (int)(time / 604800L);
            time -= (long)(weeks * 604800);
            toreturn.append(weeks).append("w ");
        }
        if (time >= 86400L) {
            int days = (int)(time / 86400L);
            time -= (long)(days * 86400);
            toreturn.append(days).append("d ");
        }
        if (time >= 3600L) {
            int hours = (int)(time / 3600L);
            time -= (long)(hours * 3600);
            toreturn.append(hours).append("h ");
        }
        if (time >= 60L) {
            int minutes = (int)(time / 60L);
            time -= (long)(minutes * 60);
            toreturn.append(minutes).append("m ");
        }
        if (toreturn.length() == 0 || time > 0L) {
            toreturn.append(time).append("s ");
        }
        return toreturn.toString().trim();
    }
}

