/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.google.inject.Inject;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.CmdConfirm;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SetCommand;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.events.PlotChangeOwnerEvent;
import com.plotsquared.core.events.PlotUnlinkEvent;
import com.plotsquared.core.events.Result;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.MetaDataAccess;
import com.plotsquared.core.player.PlayerMetaDataKeys;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.PlayerManager;
import com.plotsquared.core.util.TabCompletions;
import com.plotsquared.core.util.task.TaskManager;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.kyori.adventure.text.minimessage.Template;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@CommandDeclaration(command="setowner", permission="plots.admin.command.setowner", usage="/plot setowner <player>", aliases={"owner", "so", "seto"}, category=CommandCategory.CLAIMING, requiredType=RequiredType.NONE, confirmation=true)
public class Owner
extends SetCommand {
    private final EventDispatcher eventDispatcher;

    @Inject
    public Owner(@NonNull EventDispatcher eventDispatcher) {
        this.eventDispatcher = eventDispatcher;
    }

    @Override
    public boolean set(PlotPlayer<?> player, Plot plot, String value) {
        if (value == null || value.isEmpty()) {
            player.sendMessage(TranslatableCaption.of("commandconfig.command_syntax"), Template.of((String)"value", (String)"/plot setowner <owner>"));
            return false;
        }
        @Nullable UUID oldOwner = plot.getOwnerAbs();
        Set<Plot> plots = plot.getConnectedPlots();
        Consumer<UUID> uuidConsumer = uuid -> {
            boolean force;
            if (!(uuid != null || value.equalsIgnoreCase("none") || value.equalsIgnoreCase("null") || value.equalsIgnoreCase("-"))) {
                player.sendMessage(TranslatableCaption.of("errors.invalid_player"), Template.of((String)"value", (String)value));
                return;
            }
            PlotChangeOwnerEvent event = this.eventDispatcher.callOwnerChange(player, plot, plot.hasOwner() ? plot.getOwnerAbs() : null, (UUID)uuid, plot.hasOwner());
            if (event.getEventResult() == Result.DENY) {
                player.sendMessage(TranslatableCaption.of("events.event_denied"), Template.of((String)"value", (String)"Owner change"));
                return;
            }
            uuid = event.getNewOwner();
            boolean bl = force = event.getEventResult() == Result.FORCE;
            if (uuid == null) {
                if (!force && !player.hasPermission(Permission.PERMISSION_ADMIN_COMMAND_SET_OWNER, true)) {
                    return;
                }
                PlotUnlinkEvent unlinkEvent = this.eventDispatcher.callUnlink(plot.getArea(), plot, false, false, PlotUnlinkEvent.REASON.NEW_OWNER);
                if (unlinkEvent.getEventResult() == Result.DENY) {
                    player.sendMessage(TranslatableCaption.of("events.event_denied"), Template.of((String)"value", (String)"Unlink on owner change"));
                    return;
                }
                if (plot.getPlotModificationManager().unlinkPlot(unlinkEvent.isCreateRoad(), unlinkEvent.isCreateRoad())) {
                    this.eventDispatcher.callPostUnlink(plot, PlotUnlinkEvent.REASON.NEW_OWNER);
                }
                Set<Plot> connected = plot.getConnectedPlots();
                for (Plot current : connected) {
                    current.unclaim();
                    current.getPlotModificationManager().removeSign();
                }
                this.eventDispatcher.callPostOwnerChange(player, plot, oldOwner);
                player.sendMessage(TranslatableCaption.of("owner.set_owner"), new Template[0]);
                return;
            }
            PlotPlayer<?> other = PlotSquared.platform().playerManager().getPlayerIfExists((UUID)uuid);
            if (plot.isOwner((UUID)uuid)) {
                player.sendMessage(TranslatableCaption.of("member.already_owner"), Template.of((String)"player", (String)PlayerManager.resolveName(uuid, false).getComponent(player)));
                return;
            }
            if (!force && !player.hasPermission(Permission.PERMISSION_ADMIN_COMMAND_SET_OWNER)) {
                if (other == null) {
                    player.sendMessage(TranslatableCaption.of("errors.invalid_player_offline"), Template.of((String)"player", (String)PlayerManager.resolveName(uuid).getComponent(player)));
                    return;
                }
                int size = plots.size();
                int currentPlots = (Settings.Limit.GLOBAL ? other.getPlotCount() : other.getPlotCount(plot.getWorldName())) + size;
                try (MetaDataAccess<Integer> metaDataAccess = player.accessPersistentMetaData(PlayerMetaDataKeys.PERSISTENT_GRANTED_PLOTS);){
                    int grants;
                    if (currentPlots >= other.getAllowedPlots() && metaDataAccess.isPresent() && (grants = metaDataAccess.get().orElse(0).intValue()) <= 0) {
                        metaDataAccess.remove();
                        player.sendMessage(TranslatableCaption.of("permission.cant_transfer_more_plots"), new Template[0]);
                        return;
                    }
                }
            }
            UUID finalUUID = uuid;
            PlotSquared.get().getImpromptuUUIDPipeline().getSingle((UUID)uuid, (finalName, throwable) -> {
                boolean removeDenied = plot.isDenied(finalUUID);
                Runnable run = () -> {
                    if (plot.setOwner(finalUUID, player)) {
                        if (removeDenied) {
                            plot.removeDenied(finalUUID);
                        }
                        plot.getPlotModificationManager().setSign((String)finalName);
                        player.sendMessage(TranslatableCaption.of("owner.set_owner"), new Template[0]);
                        this.eventDispatcher.callPostOwnerChange(player, plot, oldOwner);
                        if (other != null) {
                            other.sendMessage(TranslatableCaption.of("owner.now_owner"), Template.of((String)"plot", (String)(plot.getArea() + ";" + plot.getId())));
                        }
                    } else {
                        player.sendMessage(TranslatableCaption.of("owner.set_owner_cancelled"), new Template[0]);
                    }
                };
                if (this.hasConfirmation(player)) {
                    CmdConfirm.addPending(player, "/plot setowner " + value, run);
                } else {
                    TaskManager.runTask(run);
                }
            });
        };
        if (value.length() == 36) {
            try {
                uuidConsumer.accept(UUID.fromString(value));
            }
            catch (Exception exception) {}
        } else {
            PlotSquared.get().getImpromptuUUIDPipeline().getSingle(value, (uuid, throwable) -> uuidConsumer.accept((UUID)uuid));
        }
        return true;
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> player, String[] args, boolean space) {
        return TabCompletions.completePlayers(player, String.join((CharSequence)",", args).trim(), Collections.emptyList());
    }
}

