/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.google.inject.Inject;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.MainCommand;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.Templates;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.PlayerManager;
import com.plotsquared.core.util.TabCompletions;
import com.plotsquared.core.util.task.RunnableVal2;
import com.plotsquared.core.util.task.RunnableVal3;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import net.kyori.adventure.text.minimessage.Template;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="trust", aliases={"t"}, requiredType=RequiredType.PLAYER, usage="/plot trust <player | *>", category=CommandCategory.SETTINGS)
public class Trust
extends Command {
    private final EventDispatcher eventDispatcher;

    @Inject
    public Trust(@NonNull EventDispatcher eventDispatcher) {
        super(MainCommand.getInstance(), true);
        this.eventDispatcher = eventDispatcher;
    }

    @Override
    public CompletableFuture<Boolean> execute(PlotPlayer<?> player, String[] args, RunnableVal3<Command, Runnable, Runnable> confirm, RunnableVal2<Command, Command.CommandResult> whenDone) throws Command.CommandException {
        Plot currentPlot = player.getCurrentPlot();
        if (currentPlot == null) {
            throw new Command.CommandException(TranslatableCaption.of("errors.not_in_plot"), new Template[0]);
        }
        this.checkTrue(currentPlot.hasOwner(), TranslatableCaption.of("info.plot_unowned"), new Template[0]);
        this.checkTrue(currentPlot.isOwner(player.getUUID()) || player.hasPermission(Permission.PERMISSION_ADMIN_COMMAND_TRUST), TranslatableCaption.of("permission.no_plot_perms"), new Template[0]);
        this.checkTrue(args.length == 1, TranslatableCaption.of("commandconfig.command_syntax"), Templates.of("value", this.getUsage()));
        CompletableFuture future = new CompletableFuture();
        PlayerManager.getUUIDsFromString(args[0], (uuids, throwable) -> {
            if (throwable != null) {
                if (throwable instanceof TimeoutException) {
                    player.sendMessage(TranslatableCaption.of("players.fetching_players_timeout"), new Template[0]);
                } else {
                    player.sendMessage(TranslatableCaption.of("errors.invalid_player"), Template.of((String)"value", (String)args[0]));
                }
                future.completeExceptionally((Throwable)throwable);
                return;
            }
            this.checkTrue(!uuids.isEmpty(), TranslatableCaption.of("errors.invalid_player"), Templates.of("value", args[0]));
            Iterator iterator = uuids.iterator();
            int size = currentPlot.getTrusted().size() + currentPlot.getMembers().size();
            while (iterator.hasNext()) {
                UUID uuid = (UUID)iterator.next();
                if (uuid == DBFunc.EVERYONE && !player.hasPermission(Permission.PERMISSION_TRUST_EVERYONE) && !player.hasPermission(Permission.PERMISSION_ADMIN_COMMAND_TRUST)) {
                    player.sendMessage(TranslatableCaption.of("errors.invalid_player"), Template.of((String)"value", (String)PlayerManager.resolveName(uuid).getComponent(player)));
                    iterator.remove();
                    continue;
                }
                if (currentPlot.isOwner(uuid)) {
                    player.sendMessage(TranslatableCaption.of("member.already_added"), Template.of((String)"value", (String)PlayerManager.resolveName(uuid).getComponent(player)));
                    iterator.remove();
                    continue;
                }
                if (currentPlot.getTrusted().contains(uuid)) {
                    player.sendMessage(TranslatableCaption.of("member.already_added"), Template.of((String)"value", (String)PlayerManager.resolveName(uuid).getComponent(player)));
                    iterator.remove();
                    continue;
                }
                size += currentPlot.getMembers().contains(uuid) ? 0 : 1;
            }
            this.checkTrue(!uuids.isEmpty(), null, new Template[0]);
            int localTrustSize = currentPlot.getTrusted().size();
            int maxTrustSize = player.hasPermissionRange(Permission.PERMISSION_TRUST, Settings.Limit.MAX_PLOTS);
            if (localTrustSize >= maxTrustSize) {
                player.sendMessage(TranslatableCaption.of("members.plot_max_members_trusted"), Template.of((String)"amount", (String)String.valueOf(localTrustSize)));
                return;
            }
            confirm.run(this, () -> {
                for (UUID uuid : uuids) {
                    if (uuid != DBFunc.EVERYONE && !currentPlot.removeMember(uuid) && currentPlot.getDenied().contains(uuid)) {
                        currentPlot.removeDenied(uuid);
                    }
                    currentPlot.addTrusted(uuid);
                    this.eventDispatcher.callTrusted(player, currentPlot, uuid, true);
                    player.sendMessage(TranslatableCaption.of("trusted.trusted_added"), new Template[0]);
                }
            }, null);
            future.complete(true);
        });
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> player, String[] args, boolean space) {
        return TabCompletions.completePlayers(player, String.join((CharSequence)",", args).trim(), Collections.emptyList());
    }
}

