/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.generator;

import com.plotsquared.core.configuration.ConfigurationSection;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.file.YamlConfiguration;
import com.plotsquared.core.generator.GridPlotWorld;
import com.plotsquared.core.generator.IndependentPlotGenerator;
import com.plotsquared.core.inject.annotations.WorldConfig;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.queue.GlobalBlockQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class SquarePlotWorld
extends GridPlotWorld {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + SquarePlotWorld.class.getSimpleName()));
    public int PLOT_WIDTH = 42;
    public int ROAD_WIDTH = 7;
    public int ROAD_OFFSET_X = 0;
    public int ROAD_OFFSET_Z = 0;

    public SquarePlotWorld(String worldName, @Nullable String id, @NonNull IndependentPlotGenerator generator, @Nullable PlotId min, @Nullable PlotId max, @WorldConfig @NonNull YamlConfiguration worldConfiguration, @NonNull GlobalBlockQueue blockQueue) {
        super(worldName, id, generator, min, max, worldConfiguration, blockQueue);
    }

    @Override
    public void loadConfiguration(ConfigurationSection config) {
        if (!config.contains("plot.height") && Settings.DEBUG) {
            LOGGER.info("- Configuration is null? ({})", (Object)config.getCurrentPath());
        }
        this.PLOT_WIDTH = config.getInt("plot.size");
        this.ROAD_WIDTH = config.getInt("road.width");
        this.ROAD_OFFSET_X = config.getInt("road.offset.x");
        this.ROAD_OFFSET_Z = config.getInt("road.offset.z");
        this.SIZE = (short)(this.PLOT_WIDTH + this.ROAD_WIDTH);
    }
}

