/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot;

import com.google.inject.Inject;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.ConfigurationUtil;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.LocaleHolder;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.events.PlotComponentSetEvent;
import com.plotsquared.core.events.PlotMergeEvent;
import com.plotsquared.core.events.PlotUnlinkEvent;
import com.plotsquared.core.events.Result;
import com.plotsquared.core.generator.ClassicPlotWorld;
import com.plotsquared.core.generator.SquarePlotWorld;
import com.plotsquared.core.inject.factory.ProgressSubscriberFactory;
import com.plotsquared.core.location.Direction;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.BlockBucket;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotAreaTerrainType;
import com.plotsquared.core.plot.PlotAreaType;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.plot.PlotManager;
import com.plotsquared.core.plot.PlotSettings;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.queue.QueueCoordinator;
import com.plotsquared.core.util.PlayerManager;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.core.util.task.TaskTime;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import net.kyori.adventure.text.minimessage.Template;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class PlotModificationManager {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + PlotModificationManager.class.getSimpleName()));
    private final Plot plot;
    private final ProgressSubscriberFactory subscriberFactory;

    @Inject
    PlotModificationManager(@NonNull Plot plot) {
        this.plot = plot;
        this.subscriberFactory = (ProgressSubscriberFactory)PlotSquared.platform().injector().getInstance(ProgressSubscriberFactory.class);
    }

    public CompletableFuture<Boolean> copy(final @NonNull Plot destination, final @Nullable PlotPlayer<?> actor) {
        Plot other;
        final CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        PlotId offset = PlotId.of(destination.getId().getX() - this.plot.getId().getX(), destination.getId().getY() - this.plot.getId().getY());
        Location db = destination.getBottomAbs();
        Location ob = this.plot.getBottomAbs();
        final int offsetX = db.getX() - ob.getX();
        final int offsetZ = db.getZ() - ob.getZ();
        if (!this.plot.hasOwner()) {
            TaskManager.runTaskLater(() -> future.complete(false), TaskTime.ticks(1L));
            return future;
        }
        Set<Plot> plots = this.plot.getConnectedPlots();
        for (Plot plot : plots) {
            other = plot.getRelative(destination.getArea(), offset.getX(), offset.getY());
            if (!other.hasOwner()) continue;
            TaskManager.runTaskLater(() -> future.complete(false), TaskTime.ticks(1L));
            return future;
        }
        destination.updateWorldBorder();
        for (Plot plot : plots) {
            other = plot.getRelative(destination.getArea(), offset.getX(), offset.getY());
            other.getPlotModificationManager().create(plot.getOwner(), false);
            if (!plot.getFlagContainer().getFlagMap().isEmpty()) {
                Set<PlotFlag<?, ?>> existingFlags = other.getFlags();
                other.getFlagContainer().clearLocal();
                other.getFlagContainer().addAll(plot.getFlagContainer().getFlagMap().values());
                for (PlotFlag plotFlag : existingFlags) {
                    Object newFlag = other.getFlagContainer().queryLocal(plotFlag.getClass());
                    if (other.getFlagContainer().queryLocal(plotFlag.getClass()) == null) {
                        DBFunc.removeFlag(other, plotFlag);
                        continue;
                    }
                    DBFunc.setFlag(other, newFlag);
                }
            }
            if (plot.isMerged()) {
                other.setMerged(plot.getMerged());
            }
            if (plot.members != null && !plot.members.isEmpty()) {
                other.members = plot.members;
                for (UUID member : plot.members) {
                    DBFunc.setMember(other, member);
                }
            }
            if (plot.trusted != null && !plot.trusted.isEmpty()) {
                other.trusted = plot.trusted;
                for (UUID trusted : plot.trusted) {
                    DBFunc.setTrusted(other, trusted);
                }
            }
            if (plot.denied == null || plot.denied.isEmpty()) continue;
            other.denied = plot.denied;
            for (UUID denied : plot.denied) {
                DBFunc.setDenied(other, denied);
            }
        }
        final ArrayDeque<CuboidRegion> regions = new ArrayDeque<CuboidRegion>(this.plot.getRegions());
        Runnable run = new Runnable(){

            @Override
            public void run() {
                if (regions.isEmpty()) {
                    QueueCoordinator queue = PlotModificationManager.this.plot.getArea().getQueue();
                    for (Plot current : PlotModificationManager.this.plot.getConnectedPlots()) {
                        destination.getManager().claimPlot(current, queue);
                    }
                    if (queue.size() > 0) {
                        queue.enqueue();
                    }
                    destination.getPlotModificationManager().setSign();
                    future.complete(true);
                    return;
                }
                CuboidRegion region = (CuboidRegion)regions.poll();
                Location[] corners = Plot.getCorners(PlotModificationManager.this.plot.getWorldName(), region);
                Location pos1 = corners[0];
                Location pos2 = corners[1];
                Location newPos = pos1.add(offsetX, 0, offsetZ).withWorld(destination.getWorldName());
                PlotSquared.platform().regionManager().copyRegion(pos1, pos2, newPos, actor, this);
            }
        };
        run.run();
        return future;
    }

    public void clear(@Nullable Runnable whenDone) {
        this.clear(false, false, null, whenDone);
    }

    public boolean clear(boolean checkRunning, final boolean isDelete, final @Nullable PlotPlayer<?> actor, final @Nullable Runnable whenDone) {
        if (checkRunning && this.plot.getRunning() != 0) {
            return false;
        }
        final Set<CuboidRegion> regions = this.plot.getRegions();
        final Set<Plot> plots = this.plot.getConnectedPlots();
        final ArrayDeque<Plot> queue = new ArrayDeque<Plot>(plots);
        if (isDelete) {
            this.removeSign();
        }
        final PlotManager manager = this.plot.getArea().getPlotManager();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                if (queue.isEmpty()) {
                    Runnable run = () -> {
                        for (CuboidRegion region : regions) {
                            Location[] corners = Plot.getCorners(PlotModificationManager.this.plot.getWorldName(), region);
                            PlotSquared.platform().regionManager().clearAllEntities(corners[0], corners[1]);
                        }
                        TaskManager.runTask(whenDone);
                    };
                    QueueCoordinator queue2 = PlotModificationManager.this.plot.getArea().getQueue();
                    for (Plot current : plots) {
                        if (isDelete || !current.hasOwner()) {
                            manager.unClaimPlot(current, null, queue2);
                            continue;
                        }
                        manager.claimPlot(current, queue2);
                        PlotArea plotArea = PlotModificationManager.this.plot.getArea();
                        if (!(plotArea instanceof ClassicPlotWorld)) continue;
                        ClassicPlotWorld cpw = (ClassicPlotWorld)plotArea;
                        manager.setComponent(current.getId(), "wall", cpw.WALL_FILLING.toPattern(), actor, queue2);
                    }
                    if (queue2.size() > 0) {
                        queue2.setCompleteTask(run);
                        queue2.enqueue();
                        return;
                    }
                    run.run();
                    return;
                }
                Plot current = (Plot)queue.poll();
                current.clearCache();
                if (PlotModificationManager.this.plot.getArea().getTerrain() != PlotAreaTerrainType.NONE) {
                    try {
                        PlotSquared.platform().regionManager().regenerateRegion(current.getBottomAbs(), current.getTopAbs(), false, this);
                    }
                    catch (UnsupportedOperationException exception) {
                        exception.printStackTrace();
                        return;
                    }
                    return;
                }
                manager.clearPlot(current, this, actor, null);
            }
        };
        PlotUnlinkEvent event = PlotSquared.get().getEventDispatcher().callUnlink(this.plot.getArea(), this.plot, true, !isDelete, isDelete ? PlotUnlinkEvent.REASON.DELETE : PlotUnlinkEvent.REASON.CLEAR);
        if (event.getEventResult() != Result.DENY) {
            if (this.unlinkPlot(event.isCreateRoad(), event.isCreateSign(), run)) {
                PlotSquared.get().getEventDispatcher().callPostUnlink(this.plot, event.getReason());
            }
        } else {
            run.run();
        }
        return true;
    }

    public void setBiome(final @Nullable BiomeType biome, final @NonNull Runnable whenDone) {
        final ArrayDeque<CuboidRegion> regions = new ArrayDeque<CuboidRegion>(this.plot.getRegions());
        final int extendBiome = this.plot.getArea() instanceof SquarePlotWorld ? (((SquarePlotWorld)this.plot.getArea()).ROAD_WIDTH > 0 ? 1 : 0) : 0;
        Runnable run = new Runnable(){

            @Override
            public void run() {
                if (regions.isEmpty()) {
                    TaskManager.runTask(whenDone);
                    return;
                }
                CuboidRegion region = (CuboidRegion)regions.poll();
                PlotSquared.platform().regionManager().setBiome(region, extendBiome, biome, PlotModificationManager.this.plot.getArea(), (Runnable)this);
            }
        };
        run.run();
    }

    public boolean unlinkPlot(boolean createRoad, boolean createSign) {
        return this.unlinkPlot(createRoad, createSign, null);
    }

    public boolean unlinkPlot(boolean createRoad, boolean createSign, Runnable whenDone) {
        if (!this.plot.isMerged()) {
            if (whenDone != null) {
                whenDone.run();
            }
            return false;
        }
        Set<Plot> plots = this.plot.getConnectedPlots();
        ArrayList<PlotId> ids = new ArrayList<PlotId>(plots.size());
        for (Plot current : plots) {
            current.setHome(null);
            current.clearCache();
            ids.add(current.getId());
        }
        this.plot.clearRatings();
        QueueCoordinator queue = this.plot.getArea().getQueue();
        if (createSign) {
            this.removeSign();
        }
        PlotManager manager = this.plot.getArea().getPlotManager();
        if (createRoad) {
            manager.startPlotUnlink(ids, queue);
        }
        if (this.plot.getArea().getTerrain() != PlotAreaTerrainType.ALL && createRoad) {
            for (Plot current : plots) {
                if (current.isMerged(Direction.EAST)) {
                    manager.createRoadEast(current, queue);
                    if (current.isMerged(Direction.SOUTH)) {
                        manager.createRoadSouth(current, queue);
                        if (current.isMerged(Direction.SOUTHEAST)) {
                            manager.createRoadSouthEast(current, queue);
                        }
                    }
                }
                if (!current.isMerged(Direction.SOUTH)) continue;
                manager.createRoadSouth(current, queue);
            }
        }
        for (Plot current : plots) {
            boolean[] merged = new boolean[]{false, false, false, false};
            current.setMerged(merged);
        }
        if (createSign) {
            queue.setCompleteTask(() -> TaskManager.runTaskAsync(() -> {
                for (Plot current : plots) {
                    current.getPlotModificationManager().setSign(PlayerManager.resolveName(current.getOwnerAbs()).getComponent(LocaleHolder.console()));
                }
                if (whenDone != null) {
                    TaskManager.runTask(whenDone);
                }
            }));
        } else if (whenDone != null) {
            queue.setCompleteTask(whenDone);
        }
        if (createRoad) {
            manager.finishPlotUnlink(ids, queue);
        }
        queue.enqueue();
        return true;
    }

    public void setSign(@NonNull String name) {
        if (!this.plot.isLoaded()) {
            return;
        }
        PlotManager manager = this.plot.getArea().getPlotManager();
        if (this.plot.getArea().allowSigns()) {
            Location location = manager.getSignLoc(this.plot);
            String id = this.plot.getId().toString();
            Caption[] lines = new Caption[]{TranslatableCaption.of("signs.owner_sign_line_1"), TranslatableCaption.of("signs.owner_sign_line_2"), TranslatableCaption.of("signs.owner_sign_line_3"), TranslatableCaption.of("signs.owner_sign_line_4")};
            PlotSquared.platform().worldUtil().setSign(location, lines, Template.of((String)"id", (String)id), Template.of((String)"owner", (String)name));
        }
    }

    public void refreshChunks() {
        HashSet<BlockVector2> chunks = new HashSet<BlockVector2>();
        for (CuboidRegion region : this.plot.getRegions()) {
            for (int x = region.getMinimumPoint().getX() >> 4; x <= region.getMaximumPoint().getX() >> 4; ++x) {
                for (int z = region.getMinimumPoint().getZ() >> 4; z <= region.getMaximumPoint().getZ() >> 4; ++z) {
                    if (!chunks.add(BlockVector2.at((int)x, (int)z))) continue;
                    PlotSquared.platform().worldUtil().refreshChunk(x, z, this.plot.getWorldName());
                }
            }
        }
    }

    public void removeSign() {
        PlotManager manager = this.plot.getArea().getPlotManager();
        if (!this.plot.getArea().allowSigns()) {
            return;
        }
        Location location = manager.getSignLoc(this.plot);
        QueueCoordinator queue = PlotSquared.platform().globalBlockQueue().getNewQueue(PlotSquared.platform().worldUtil().getWeWorld(this.plot.getWorldName()));
        queue.setBlock(location.getX(), location.getY(), location.getZ(), BlockTypes.AIR.getDefaultState());
        queue.enqueue();
    }

    public void setSign() {
        if (!this.plot.hasOwner()) {
            this.setSign("unknown");
            return;
        }
        PlotSquared.get().getImpromptuUUIDPipeline().getSingle(this.plot.getOwnerAbs(), (username, sign) -> this.setSign((String)username));
    }

    public boolean create() {
        return this.create(this.plot.getOwnerAbs(), true);
    }

    public boolean create(@NonNull UUID uuid, boolean notify) {
        Integer meta;
        this.plot.setOwnerAbs(uuid);
        Plot existing = this.plot.getArea().getOwnedPlotAbs(this.plot.getId());
        if (existing != null) {
            throw new IllegalStateException("Plot already exists!");
        }
        if (notify && (meta = (Integer)this.plot.getArea().getMeta("worldBorder")) != null) {
            this.plot.updateWorldBorder();
        }
        this.plot.clearCache();
        this.plot.getTrusted().clear();
        this.plot.getMembers().clear();
        this.plot.getDenied().clear();
        this.plot.settings = new PlotSettings();
        if (this.plot.getArea().addPlot(this.plot)) {
            DBFunc.createPlotAndSettings(this.plot, () -> {
                PlotArea plotworld = this.plot.getArea();
                if (notify && plotworld.isAutoMerge()) {
                    PlotPlayer<?> player = PlotSquared.platform().playerManager().getPlayerIfExists(uuid);
                    PlotMergeEvent event = PlotSquared.get().getEventDispatcher().callMerge(this.plot, Direction.ALL, Integer.MAX_VALUE, player);
                    if (event.getEventResult() == Result.DENY) {
                        if (player != null) {
                            player.sendMessage(TranslatableCaption.of("events.event_denied"), Template.of((String)"value", (String)"Auto merge on claim"));
                        }
                        return;
                    }
                    if (this.plot.getPlotModificationManager().autoMerge(event.getDir(), event.getMax(), uuid, player, true)) {
                        PlotSquared.get().getEventDispatcher().callPostMerge(player, this.plot);
                    }
                }
            });
            return true;
        }
        LOGGER.info("Failed to add plot {} to plot area {}", (Object)this.plot.getId().toCommaSeparatedString(), (Object)this.plot.getArea().toString());
        return false;
    }

    public boolean autoMerge(@NonNull Direction dir, int max, @NonNull UUID uuid, @Nullable PlotPlayer<?> actor, boolean removeRoads) {
        Plot current;
        if (!this.plot.hasOwner()) {
            return false;
        }
        Set<Plot> connected = this.plot.getConnectedPlots();
        HashSet merged = connected.stream().map(Plot::getId).collect(Collectors.toCollection(HashSet::new));
        ArrayDeque<Plot> frontier = new ArrayDeque<Plot>(connected);
        boolean toReturn = false;
        HashSet<Plot> visited = new HashSet<Plot>();
        QueueCoordinator queue = this.plot.getArea().getQueue();
        while ((current = frontier.poll()) != null && max >= 0) {
            ArrayList<PlotId> ids;
            Set<Plot> plots;
            Plot other;
            if (visited.contains(current)) continue;
            visited.add(current);
            if ((dir == Direction.ALL || dir == Direction.NORTH) && !current.isMerged(Direction.NORTH) && (other = current.getRelative(Direction.NORTH)) != null && other.isOwner(uuid) && (other.getBasePlot(false).equals(current.getBasePlot(false)) || (plots = other.getConnectedPlots()).size() <= max && frontier.addAll(plots) && (max -= plots.size()) != -1)) {
                current.mergePlot(other, removeRoads, queue);
                merged.add(current.getId());
                merged.add(other.getId());
                toReturn = true;
                if (removeRoads) {
                    ids = new ArrayList<PlotId>();
                    ids.add(current.getId());
                    ids.add(other.getId());
                    this.plot.getManager().finishPlotMerge(ids, queue);
                }
            }
            if (max >= 0 && (dir == Direction.ALL || dir == Direction.EAST) && !current.isMerged(Direction.EAST) && (other = current.getRelative(Direction.EAST)) != null && other.isOwner(uuid) && (other.getBasePlot(false).equals(current.getBasePlot(false)) || (plots = other.getConnectedPlots()).size() <= max && frontier.addAll(plots) && (max -= plots.size()) != -1)) {
                current.mergePlot(other, removeRoads, queue);
                merged.add(current.getId());
                merged.add(other.getId());
                toReturn = true;
                if (removeRoads) {
                    ids = new ArrayList();
                    ids.add(current.getId());
                    ids.add(other.getId());
                    this.plot.getManager().finishPlotMerge(ids, queue);
                }
            }
            if (max >= 0 && (dir == Direction.ALL || dir == Direction.SOUTH) && !current.isMerged(Direction.SOUTH) && (other = current.getRelative(Direction.SOUTH)) != null && other.isOwner(uuid) && (other.getBasePlot(false).equals(current.getBasePlot(false)) || (plots = other.getConnectedPlots()).size() <= max && frontier.addAll(plots) && (max -= plots.size()) != -1)) {
                current.mergePlot(other, removeRoads, queue);
                merged.add(current.getId());
                merged.add(other.getId());
                toReturn = true;
                if (removeRoads) {
                    ids = new ArrayList();
                    ids.add(current.getId());
                    ids.add(other.getId());
                    this.plot.getManager().finishPlotMerge(ids, queue);
                }
            }
            if (max < 0 || dir != Direction.ALL && dir != Direction.WEST || current.isMerged(Direction.WEST) || (other = current.getRelative(Direction.WEST)) == null || !other.isOwner(uuid) || !other.getBasePlot(false).equals(current.getBasePlot(false)) && ((plots = other.getConnectedPlots()).size() > max || !frontier.addAll(plots) || (max -= plots.size()) == -1)) continue;
            current.mergePlot(other, removeRoads, queue);
            merged.add(current.getId());
            merged.add(other.getId());
            toReturn = true;
            if (!removeRoads) continue;
            ids = new ArrayList();
            ids.add(current.getId());
            ids.add(other.getId());
            this.plot.getManager().finishPlotMerge(ids, queue);
        }
        if (actor != null && Settings.QUEUE.NOTIFY_PROGRESS) {
            queue.addProgressSubscriber(this.subscriberFactory.createWithActor(actor));
        }
        if (queue.size() > 0) {
            queue.enqueue();
        }
        visited.forEach(Plot::clearCache);
        return toReturn;
    }

    public @NonNull CompletableFuture<Boolean> move(final @NonNull Plot destination, final @Nullable PlotPlayer<?> actor, final @NonNull Runnable whenDone, boolean allowSwap) {
        final PlotId offset = PlotId.of(destination.getId().getX() - this.plot.getId().getX(), destination.getId().getY() - this.plot.getId().getY());
        Location db = destination.getBottomAbs();
        Location ob = this.plot.getBottomAbs();
        final int offsetX = db.getX() - ob.getX();
        final int offsetZ = db.getZ() - ob.getZ();
        if (!this.plot.hasOwner()) {
            TaskManager.runTaskLater(whenDone, TaskTime.ticks(1L));
            return CompletableFuture.completedFuture(false);
        }
        AtomicBoolean occupied = new AtomicBoolean(false);
        Set<Plot> plots = this.plot.getConnectedPlots();
        for (Plot plot : plots) {
            Plot other = plot.getRelative(destination.getArea(), offset.getX(), offset.getY());
            if (other.hasOwner()) {
                if (!allowSwap) {
                    TaskManager.runTaskLater(whenDone, TaskTime.ticks(1L));
                    return CompletableFuture.completedFuture(false);
                }
                occupied.set(true);
                continue;
            }
            plot.getPlotModificationManager().removeSign();
        }
        destination.updateWorldBorder();
        final ArrayDeque<CuboidRegion> regions = new ArrayDeque<CuboidRegion>(this.plot.getRegions());
        final PlotArea originArea = this.plot.getArea();
        Iterator<Plot> plotIterator = plots.iterator();
        CompletionStage<Boolean> future = null;
        if (plotIterator.hasNext()) {
            while (plotIterator.hasNext()) {
                Plot plot = plotIterator.next();
                Plot other = plot.getRelative(destination.getArea(), offset.getX(), offset.getY());
                CompletableFuture<Boolean> swapResult = plot.swapData(other);
                if (future == null) {
                    future = swapResult;
                    continue;
                }
                future = future.thenCombine(swapResult, (fn, th) -> fn);
            }
        } else {
            future = CompletableFuture.completedFuture(true);
        }
        return future.thenApply(result -> {
            if (!result.booleanValue()) {
                return false;
            }
            if (occupied.get()) {
                new Runnable(){

                    @Override
                    public void run() {
                        if (regions.isEmpty()) {
                            destination.getPlotModificationManager().setSign();
                            PlotModificationManager.this.setSign();
                            TaskManager.runTask(whenDone);
                        } else {
                            CuboidRegion region = (CuboidRegion)regions.poll();
                            Location[] corners = Plot.getCorners(PlotModificationManager.this.plot.getWorldName(), region);
                            Location pos1 = corners[0];
                            Location pos2 = corners[1];
                            Location pos3 = pos1.add(offsetX, 0, offsetZ).withWorld(destination.getWorldName());
                            PlotSquared.platform().regionManager().swap(pos1, pos2, pos3, actor, this);
                        }
                    }
                }.run();
            } else {
                new Runnable(){

                    @Override
                    public void run() {
                        if (regions.isEmpty()) {
                            Plot plot = destination.getRelative(0, 0);
                            Plot originPlot = originArea.getPlotAbs(PlotId.of(plot.getId().getX() - offset.getX(), plot.getId().getY() - offset.getY()));
                            Runnable clearDone = () -> {
                                QueueCoordinator queue = PlotModificationManager.this.plot.getArea().getQueue();
                                for (Plot current : plot.getConnectedPlots()) {
                                    PlotModificationManager.this.plot.getManager().claimPlot(current, queue);
                                }
                                if (queue.size() > 0) {
                                    queue.enqueue();
                                }
                                plot.getPlotModificationManager().setSign();
                                TaskManager.runTask(whenDone);
                            };
                            if (originPlot != null) {
                                originPlot.getPlotModificationManager().clear(false, true, actor, clearDone);
                            } else {
                                clearDone.run();
                            }
                            return;
                        }
                        5 task = this;
                        CuboidRegion region = (CuboidRegion)regions.poll();
                        Location[] corners = Plot.getCorners(PlotModificationManager.this.plot.getWorldName(), region);
                        Location pos1 = corners[0];
                        Location pos2 = corners[1];
                        Location newPos = pos1.add(offsetX, 0, offsetZ).withWorld(destination.getWorldName());
                        PlotSquared.platform().regionManager().copyRegion(pos1, pos2, newPos, actor, task);
                    }
                }.run();
            }
            return true;
        });
    }

    public boolean unlink() {
        return this.unlinkPlot(true, true);
    }

    public @NonNull CompletableFuture<Boolean> swap(@NonNull Plot destination, @Nullable PlotPlayer<?> actor, @NonNull Runnable whenDone) {
        return this.move(destination, actor, whenDone, true);
    }

    public @NonNull CompletableFuture<Boolean> move(@NonNull Plot destination, @Nullable PlotPlayer<?> actor, @NonNull Runnable whenDone) {
        return this.move(destination, actor, whenDone, false);
    }

    public boolean setComponent(@NonNull String component, @NonNull Pattern blocks, @Nullable PlotPlayer<?> actor, @Nullable QueueCoordinator queue) {
        PlotComponentSetEvent event = PlotSquared.get().getEventDispatcher().callComponentSet(this.plot, component, blocks);
        return this.plot.getManager().setComponent(this.plot.getId(), event.getComponent(), event.getPattern(), actor, queue);
    }

    public boolean deletePlot(@Nullable PlotPlayer<?> actor, Runnable whenDone) {
        if (!this.plot.hasOwner()) {
            return false;
        }
        Set<Plot> plots = this.plot.getConnectedPlots();
        this.clear(false, true, actor, () -> {
            for (Plot current : plots) {
                current.unclaim();
            }
            TaskManager.runTask(whenDone);
        });
        return true;
    }

    @Deprecated
    public boolean setComponent(String component, String blocks, @Nullable PlotPlayer<?> actor, @Nullable QueueCoordinator queue) {
        BlockBucket parsed = ConfigurationUtil.BLOCK_BUCKET.parseString(blocks);
        if (parsed != null && parsed.isEmpty()) {
            return false;
        }
        return this.setComponent(component, parsed.toPattern(), actor, queue);
    }

    public void removeRoadSouth(@Nullable QueueCoordinator queue) {
        if (this.plot.getArea().getType() != PlotAreaType.NORMAL && this.plot.getArea().getTerrain() == PlotAreaTerrainType.ROAD) {
            Plot other = this.plot.getRelative(Direction.SOUTH);
            Location bot = other.getBottomAbs();
            Location top = this.plot.getTopAbs();
            Location pos1 = Location.at(this.plot.getWorldName(), bot.getX(), this.plot.getArea().getMinGenHeight(), top.getZ());
            Location pos2 = Location.at(this.plot.getWorldName(), top.getX(), this.plot.getArea().getMaxGenHeight(), bot.getZ());
            PlotSquared.platform().regionManager().regenerateRegion(pos1, pos2, true, null);
        } else if (this.plot.getArea().getTerrain() != PlotAreaTerrainType.ALL) {
            this.plot.getManager().removeRoadSouth(this.plot, queue);
        }
    }

    public void removeRoadEast(@Nullable QueueCoordinator queue) {
        if (this.plot.getArea().getType() != PlotAreaType.NORMAL && this.plot.getArea().getTerrain() == PlotAreaTerrainType.ROAD) {
            Plot other = this.plot.getRelative(Direction.EAST);
            Location bot = other.getBottomAbs();
            Location top = this.plot.getTopAbs();
            Location pos1 = Location.at(this.plot.getWorldName(), top.getX(), this.plot.getArea().getMinGenHeight(), bot.getZ());
            Location pos2 = Location.at(this.plot.getWorldName(), bot.getX(), this.plot.getArea().getMaxGenHeight(), top.getZ());
            PlotSquared.platform().regionManager().regenerateRegion(pos1, pos2, true, null);
        } else if (this.plot.getArea().getTerrain() != PlotAreaTerrainType.ALL) {
            this.plot.getArea().getPlotManager().removeRoadEast(this.plot, queue);
        }
    }

    public void removeRoadSouthEast(@Nullable QueueCoordinator queue) {
        if (this.plot.getArea().getType() != PlotAreaType.NORMAL && this.plot.getArea().getTerrain() == PlotAreaTerrainType.ROAD) {
            Plot other = this.plot.getRelative(1, 1);
            Location pos1 = this.plot.getTopAbs().add(1, 0, 1);
            Location pos2 = other.getBottomAbs().subtract(1, 0, 1);
            PlotSquared.platform().regionManager().regenerateRegion(pos1, pos2, true, null);
        } else if (this.plot.getArea().getTerrain() != PlotAreaTerrainType.ALL) {
            this.plot.getArea().getPlotManager().removeRoadSouthEast(this.plot, queue);
        }
    }
}

