/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.flag.implementations;

import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.plot.flag.FlagParseException;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.core.util.TimeUtil;
import net.kyori.adventure.text.minimessage.Template;
import org.checkerframework.checker.nullness.qual.NonNull;

public class KeepFlag
extends PlotFlag<Object, KeepFlag> {
    public static final KeepFlag KEEP_FLAG_FALSE = new KeepFlag(false);

    protected KeepFlag(@NonNull Object value) {
        super(value, TranslatableCaption.of("flags.flag_category_mixed"), TranslatableCaption.of("flags.flag_description_keep"));
    }

    @Override
    public KeepFlag parse(@NonNull String input) throws FlagParseException {
        if (MathMan.isInteger(input)) {
            long value = Long.parseLong(input);
            if (value < 0L) {
                throw new FlagParseException(this, input, TranslatableCaption.of("flags.flag_error_keep"), new Template[0]);
            }
            return this.flagOf((Object)value);
        }
        return switch (input.toLowerCase()) {
            case "true" -> this.flagOf((Object)true);
            case "false" -> this.flagOf((Object)false);
            default -> this.flagOf((Object)(TimeUtil.timeToSec(input) * 1000L + System.currentTimeMillis()));
        };
    }

    @Override
    public KeepFlag merge(@NonNull Object newValue) {
        if (newValue.equals(true)) {
            return this.flagOf((Object)true);
        }
        if (newValue.equals(false)) {
            if (this.getValue().equals(true) || this.getValue().equals(false)) {
                return this;
            }
            return this.flagOf(newValue);
        }
        if (this.getValue().equals(true)) {
            return this;
        }
        if (this.getValue().equals(false)) {
            return this.flagOf(newValue);
        }
        long currentValue = (Long)this.getValue();
        return this.flagOf((Object)((Long)newValue + currentValue));
    }

    @Override
    public String toString() {
        return this.getValue().toString();
    }

    @Override
    public String getExample() {
        return "3w 4d 2h";
    }

    @Override
    protected KeepFlag flagOf(@NonNull Object value) {
        return new KeepFlag(value);
    }
}

