/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.queue;

import com.plotsquared.core.queue.DelegateQueueCoordinator;
import com.plotsquared.core.queue.QueueCoordinator;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class LocationOffsetDelegateQueueCoordinator
extends DelegateQueueCoordinator {
    private final boolean[][] canPlace;
    private final int blockX;
    private final int blockZ;

    public LocationOffsetDelegateQueueCoordinator(boolean[][] canPlace, int blockX, int blockZ, @Nullable QueueCoordinator parent) {
        super(parent);
        this.canPlace = canPlace;
        this.blockX = blockX;
        this.blockZ = blockZ;
    }

    @Override
    public boolean setBlock(int x, int y, int z, @NonNull BlockState id) {
        if (this.canPlace[x - this.blockX][z - this.blockZ]) {
            return super.setBlock(x, y, z, id);
        }
        return false;
    }

    @Override
    public boolean setBlock(int x, int y, int z, @NonNull BaseBlock id) {
        if (this.canPlace[x - this.blockX][z - this.blockZ]) {
            return super.setBlock(x, y, z, id);
        }
        return false;
    }

    @Override
    public boolean setBlock(int x, int y, int z, @NonNull Pattern pattern) {
        BlockVector3 blockVector3 = BlockVector3.at((int)(x + this.blockX), (int)y, (int)(z + this.blockZ));
        return this.setBlock(x, y, z, pattern.applyBlock(blockVector3));
    }

    @Override
    public boolean setBiome(int x, int z, @NonNull BiomeType biome) {
        if (this.canPlace[x - this.blockX][z - this.blockZ]) {
            return super.setBiome(x, z, biome);
        }
        return false;
    }

    @Override
    public boolean setBiome(int x, int y, int z, @NonNull BiomeType biome) {
        if (this.canPlace[x - this.blockX][z - this.blockZ]) {
            return super.setBiome(x, y, z, biome);
        }
        return false;
    }

    @Override
    public boolean setTile(int x, int y, int z, @NonNull CompoundTag tag) {
        if (this.canPlace[x - this.blockX][z - this.blockZ]) {
            return super.setTile(x, y, z, tag);
        }
        return false;
    }
}

