/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.queue;

import com.google.inject.Inject;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.queue.GlobalBlockQueue;
import com.plotsquared.core.queue.LightingMode;
import com.plotsquared.core.queue.ScopedQueueCoordinator;
import com.plotsquared.core.queue.subscriber.ProgressSubscriber;
import com.plotsquared.core.util.PatternUtil;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.util.SideEffectSet;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class QueueCoordinator {
    private boolean forceSync = false;
    private @Nullable Object chunkObject;
    private final AtomicBoolean enqueued = new AtomicBoolean();
    @Inject
    private GlobalBlockQueue blockQueue;

    public QueueCoordinator(@Nullable World world) {
        PlotSquared.platform().injector().injectMembers((Object)this);
    }

    @Deprecated(forRemoval=true, since="6.6.0")
    public ScopedQueueCoordinator getForChunk(int x, int z) {
        if (this.getWorld() == null) {
            return this.getForChunk(x, z, PlotSquared.platform().versionMinHeight(), PlotSquared.platform().versionMaxHeight());
        }
        return this.getForChunk(x, z, this.getWorld().getMinY(), this.getWorld().getMaxY());
    }

    @Deprecated(forRemoval=true, since="6.9.0")
    public ScopedQueueCoordinator getForChunk(int x, int z, int minY, int maxY) {
        int bx = x << 4;
        int bz = z << 4;
        return new ScopedQueueCoordinator(this, Location.at(this.getWorld().getName(), bx, minY, bz), Location.at(this.getWorld().getName(), bx + 15, maxY, bz + 15));
    }

    public abstract int size();

    public abstract void setModified(long var1);

    public boolean isForceSync() {
        return this.forceSync;
    }

    public void setForceSync(boolean forceSync) {
        this.forceSync = forceSync;
    }

    public @Nullable Object getChunkObject() {
        return this.chunkObject;
    }

    public void setChunkObject(@NonNull Object chunkObject) {
        this.chunkObject = chunkObject;
    }

    public abstract boolean setBlock(int var1, int var2, int var3, @NonNull BlockState var4);

    public abstract boolean setBlock(int var1, int var2, int var3, @NonNull BaseBlock var4);

    public boolean setBlock(int x, int y, int z, @NonNull Pattern pattern) {
        return this.setBlock(x, y, z, PatternUtil.apply(pattern, x, y, z));
    }

    public abstract boolean setTile(int var1, int var2, int var3, @NonNull CompoundTag var4);

    public abstract boolean isSettingTiles();

    public abstract @Nullable BlockState getBlock(int var1, int var2, int var3);

    @Deprecated(forRemoval=true, since="6.0.0")
    public abstract boolean setBiome(int var1, int var2, @NonNull BiomeType var3);

    public abstract boolean setBiome(int var1, int var2, int var3, @NonNull BiomeType var4);

    public abstract boolean isSettingBiomes();

    public abstract void setBiomesEnabled(boolean var1);

    public void addEntities(@NonNull List<? extends Entity> entities) {
        for (Entity entity : entities) {
            this.setEntity(entity);
        }
    }

    public abstract boolean setEntity(@NonNull Entity var1);

    public abstract @NonNull List<BlockVector2> getReadChunks();

    public abstract void addReadChunks(@NonNull Set<BlockVector2> var1);

    public abstract void addReadChunk(@NonNull BlockVector2 var1);

    public abstract boolean isUnloadAfter();

    public abstract void setUnloadAfter(boolean var1);

    public abstract @Nullable CuboidRegion getRegenRegion();

    public abstract void setRegenRegion(@NonNull CuboidRegion var1);

    public abstract void regenChunk(int var1, int var2);

    public abstract @Nullable World getWorld();

    public final void setModified() {
        this.setModified(System.currentTimeMillis());
    }

    public boolean enqueue() {
        boolean success = false;
        if (this.enqueued.compareAndSet(false, true)) {
            success = true;
            this.start();
        }
        return success;
    }

    public abstract void start();

    public abstract void cancel();

    public abstract Runnable getCompleteTask();

    public abstract void setCompleteTask(@Nullable Runnable var1);

    public abstract @Nullable Consumer<BlockVector2> getChunkConsumer();

    public abstract void setChunkConsumer(@NonNull Consumer<BlockVector2> var1);

    public abstract void addProgressSubscriber(@NonNull ProgressSubscriber var1);

    public abstract @NonNull LightingMode getLightingMode();

    public abstract void setLightingMode(@Nullable LightingMode var1);

    public abstract @Nullable SideEffectSet getSideEffectSet();

    public abstract void setSideEffectSet(@Nullable SideEffectSet var1);

    public void setCuboid(@NonNull Location pos1, @NonNull Location pos2, @NonNull BlockState block) {
        int yMin = Math.min(pos1.getY(), pos2.getY());
        int yMax = Math.max(pos1.getY(), pos2.getY());
        int xMin = Math.min(pos1.getX(), pos2.getX());
        int xMax = Math.max(pos1.getX(), pos2.getX());
        int zMin = Math.min(pos1.getZ(), pos2.getZ());
        int zMax = Math.max(pos1.getZ(), pos2.getZ());
        for (int y = yMin; y <= yMax; ++y) {
            for (int x = xMin; x <= xMax; ++x) {
                for (int z = zMin; z <= zMax; ++z) {
                    this.setBlock(x, y, z, block);
                }
            }
        }
    }

    public void setCuboid(@NonNull Location pos1, @NonNull Location pos2, @NonNull Pattern blocks) {
        int yMin = Math.min(pos1.getY(), pos2.getY());
        int yMax = Math.max(pos1.getY(), pos2.getY());
        int xMin = Math.min(pos1.getX(), pos2.getX());
        int xMax = Math.max(pos1.getX(), pos2.getX());
        int zMin = Math.min(pos1.getZ(), pos2.getZ());
        int zMax = Math.max(pos1.getZ(), pos2.getZ());
        for (int y = yMin; y <= yMax; ++y) {
            for (int x = xMin; x <= xMax; ++x) {
                for (int z = zMin; z <= zMax; ++z) {
                    this.setBlock(x, y, z, blocks);
                }
            }
        }
    }

    public void setBiomeCuboid(@NonNull Location pos1, @NonNull Location pos2, @NonNull BiomeType biome) {
        int yMin = Math.min(pos1.getY(), pos2.getY());
        int yMax = Math.max(pos1.getY(), pos2.getY());
        int xMin = Math.min(pos1.getX(), pos2.getX());
        int xMax = Math.max(pos1.getX(), pos2.getX());
        int zMin = Math.min(pos1.getZ(), pos2.getZ());
        int zMax = Math.max(pos1.getZ(), pos2.getZ());
        for (int y = yMin; y <= yMax; ++y) {
            for (int x = xMin; x <= xMax; ++x) {
                for (int z = zMin; z <= zMax; ++z) {
                    this.setBiome(x, y, z, biome);
                }
            }
        }
    }

    protected int getMinY() {
        return this.getWorld() != null ? this.getWorld().getMinY() : PlotSquared.platform().versionMinHeight();
    }

    protected int getMaxY() {
        return this.getWorld() != null ? this.getWorld().getMinY() : PlotSquared.platform().versionMaxHeight();
    }

    protected int getMinLayer() {
        return (this.getWorld() != null ? this.getWorld().getMinY() : PlotSquared.platform().versionMinHeight()) >> 4;
    }

    protected int getMaxLayer() {
        return (this.getWorld() != null ? this.getWorld().getMaxY() : PlotSquared.platform().versionMaxHeight()) >> 4;
    }
}

