/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ReflectionUtils {
    private static String preClassB = "org.bukkit.craftbukkit";
    private static String preClassM = "net.minecraft.server";

    public ReflectionUtils(String version) {
        if (version != null) {
            preClassB = preClassB + "." + version;
            preClassM = preClassM + "." + version;
        }
    }

    public static Class<?> getClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException ignored) {
            return null;
        }
    }

    public static <T> Class<? extends T> getClass(String name, Class<T> superClass) {
        try {
            return Class.forName(name).asSubclass(superClass);
        }
        catch (ClassCastException | ClassNotFoundException ignored) {
            return null;
        }
    }

    public static RefClass getRefClass(String className) throws ClassNotFoundException {
        className = className.replace("{cb}", preClassB).replace("{nms}", preClassM).replace("{nm}", "net.minecraft");
        return ReflectionUtils.getRefClass(Class.forName(className));
    }

    public static RefClass getRefClass(Class<?> clazz) {
        return new RefClass(clazz);
    }

    public static class RefClass {
        private final Class<?> clazz;

        private RefClass(Class<?> clazz) {
            this.clazz = clazz;
        }

        public Class<?> getRealClass() {
            return this.clazz;
        }

        public RefMethod getMethod(String name, Object ... types) throws NoSuchMethodException {
            Class[] classes = new Class[types.length];
            int i = 0;
            for (Object e : types) {
                classes[i++] = e instanceof Class ? (Class)e : (e instanceof RefClass ? ((RefClass)e).getRealClass() : e.getClass());
            }
            try {
                return new RefMethod(this.clazz.getMethod(name, classes));
            }
            catch (NoSuchMethodException ignored) {
                return new RefMethod(this.clazz.getDeclaredMethod(name, classes));
            }
        }

        public RefField getField(String name) throws NoSuchFieldException {
            try {
                return new RefField(this.clazz.getField(name));
            }
            catch (NoSuchFieldException ignored) {
                return new RefField(this.clazz.getDeclaredField(name));
            }
        }
    }

    public static class RefField {
        private final Field field;

        private RefField(Field field) {
            this.field = field;
            field.setAccessible(true);
        }

        public Field getRealField() {
            return this.field;
        }

        public RefExecutor of(Object e) {
            return new RefExecutor(e);
        }

        public class RefExecutor {
            final Object e;

            public RefExecutor(Object e) {
                this.e = e;
            }

            public void set(Object param) {
                try {
                    RefField.this.field.set(this.e, param);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public Object get() {
                try {
                    return RefField.this.field.get(this.e);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static class RefConstructor {
        private final Constructor<?> constructor;

        private RefConstructor(Constructor<?> constructor) {
            this.constructor = constructor;
            constructor.setAccessible(true);
        }

        public Object create(Object ... params) throws ReflectiveOperationException, IllegalArgumentException {
            return this.constructor.newInstance(params);
        }
    }

    public static class RefMethod {
        private final Method method;

        private RefMethod(Method method) {
            this.method = method;
            method.setAccessible(true);
        }

        public Method getRealMethod() {
            return this.method;
        }

        public RefExecutor of(Object e) {
            return new RefExecutor(e);
        }

        public class RefExecutor {
            final Object e;

            public RefExecutor(Object e) {
                this.e = e;
            }

            public Object call(Object ... params) {
                try {
                    return RefMethod.this.method.invoke(this.e, params);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

