/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.core.util.Permissions;
import com.plotsquared.core.util.query.PlotQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeoutException;
import net.kyori.adventure.text.minimessage.Template;

@CommandDeclaration(command="alias", permission="plots.alias", usage="/plot alias <set | remove> <alias>", aliases={"setalias", "sa", "name", "rename", "setname", "seta", "nameplot"}, category=CommandCategory.SETTINGS, requiredType=RequiredType.PLAYER)
public class Alias
extends SubCommand {
    private static final Command SET_COMMAND = new Command(null, false, "set", null, RequiredType.NONE, null){};
    private static final Command REMOVE_COMMAND = new Command(null, false, "remove", null, RequiredType.NONE, null){};

    @Override
    public boolean onCommand(PlotPlayer<?> player, String[] args) {
        if (args.length == 0) {
            this.sendUsage(player);
            return false;
        }
        Location location = player.getLocation();
        Plot plot = location.getPlotAbs();
        if (plot == null) {
            player.sendMessage(TranslatableCaption.of("errors.not_in_plot"), new Template[0]);
            return false;
        }
        if (!plot.hasOwner()) {
            player.sendMessage(TranslatableCaption.of("working.plot_not_claimed"), new Template[0]);
            return false;
        }
        boolean result = false;
        boolean owner = plot.isOwner(player.getUUID());
        switch (args[0].toLowerCase()) {
            case "set": {
                if (args.length != 2) {
                    this.sendUsage(player);
                    return false;
                }
                boolean permission = this.isPermitted(player, Permission.PERMISSION_ALIAS_SET);
                boolean admin = this.isPermitted(player, Permission.PERMISSION_ADMIN_ALIAS_SET);
                if (!admin && !owner) {
                    player.sendMessage(TranslatableCaption.of("permission.no_plot_perms"), new Template[0]);
                    return false;
                }
                if (permission) {
                    this.setAlias(player, plot, args[1]);
                    return true;
                }
                player.sendMessage(TranslatableCaption.of("permission.no_permission"), Template.of((String)"node", (String)String.valueOf((Object)Permission.PERMISSION_ALIAS_SET)));
                break;
            }
            case "remove": {
                boolean permission = this.isPermitted(player, Permission.PERMISSION_ALIAS_REMOVE);
                boolean admin = this.isPermitted(player, Permission.PERMISSION_ADMIN_ALIAS_REMOVE);
                if (!admin && !owner) {
                    player.sendMessage(TranslatableCaption.of("permission.no_plot_perms"), new Template[0]);
                    return false;
                }
                if (permission) {
                    result = this.removeAlias(player, plot);
                    break;
                }
                player.sendMessage(TranslatableCaption.of("permission.no_permission"), Template.of((String)"node", (String)String.valueOf((Object)Permission.PERMISSION_ALIAS_REMOVE)));
                break;
            }
            default: {
                this.sendUsage(player);
                result = false;
            }
        }
        return result;
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> player, String[] args, boolean space) {
        ArrayList<Command> commands = new ArrayList<Command>(2);
        if (args.length == 1) {
            if ("set".startsWith(args[0])) {
                commands.add(SET_COMMAND);
            }
            if ("remove".startsWith(args[0])) {
                commands.add(REMOVE_COMMAND);
            }
            return commands;
        }
        return Collections.emptySet();
    }

    private void setAlias(PlotPlayer<?> player, Plot plot, String alias) {
        if (alias.isEmpty()) {
            this.sendUsage(player);
        } else if (alias.length() >= 50) {
            player.sendMessage(TranslatableCaption.of("alias.alias_too_long"), new Template[0]);
        } else if (MathMan.isInteger(alias)) {
            player.sendMessage(TranslatableCaption.of("flag.not_valid_value"), new Template[0]);
        } else {
            if (PlotQuery.newQuery().inArea(plot.getArea()).withAlias(alias).anyMatch()) {
                player.sendMessage(TranslatableCaption.of("alias.alias_is_taken"), Template.of((String)"alias", (String)alias));
                return;
            }
            if (Settings.UUID.OFFLINE) {
                plot.setAlias(alias);
                player.sendMessage(TranslatableCaption.of("alias.alias_set_to"), Template.of((String)"alias", (String)alias));
                return;
            }
            PlotSquared.get().getImpromptuUUIDPipeline().getSingle(alias, (uuid, throwable) -> {
                if (throwable instanceof TimeoutException) {
                    player.sendMessage(TranslatableCaption.of("players.fetching_players_timeout"), new Template[0]);
                } else if (uuid != null) {
                    player.sendMessage(TranslatableCaption.of("alias.alias_is_taken"), Template.of((String)"alias", (String)alias));
                } else {
                    plot.setAlias(alias);
                    player.sendMessage(TranslatableCaption.of("alias.alias_set_to"), Template.of((String)"alias", (String)alias));
                }
            });
        }
    }

    private boolean removeAlias(PlotPlayer<?> player, Plot plot) {
        String alias = plot.getAlias();
        if (!plot.getAlias().isEmpty()) {
            player.sendMessage(TranslatableCaption.of("alias.alias_removed"), Template.of((String)"alias", (String)alias));
        } else {
            player.sendMessage(TranslatableCaption.of("alias.no_alias_set"), new Template[0]);
        }
        plot.setAlias(null);
        return true;
    }

    private boolean isPermitted(PlotPlayer<?> player, Permission permission) {
        return Permissions.hasPermission(player, permission);
    }
}

