/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.events.TeleportCause;
import com.plotsquared.core.location.BlockLoc;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotCluster;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.util.Permissions;
import com.plotsquared.core.util.TabCompletions;
import com.plotsquared.core.util.query.PlotQuery;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import net.kyori.adventure.text.minimessage.Template;

@CommandDeclaration(command="cluster", aliases={"clusters"}, category=CommandCategory.ADMINISTRATION, requiredType=RequiredType.NONE, permission="plots.cluster")
public class Cluster
extends SubCommand {
    @Override
    public boolean onCommand(PlotPlayer<?> player, String[] args) {
        String sub;
        if (args.length == 0) {
            player.sendMessage(TranslatableCaption.of("cluster.cluster_available_args"), Template.of((String)"list", (String)"<dark_aqua>list</dark_aqua><gray>, </gray><dark_aqua>create</dark_aqua><gray>, </gray><dark_aqua>delete</dark_aqua><gray>, </gray><dark_aqua>resize</dark_aqua><gray>, </gray><dark_aqua>invite</dark_aqua><gray>, </gray><dark_aqua>kick</dark_aqua><gray>, </gray><dark_aqua>leave</dark_aqua><gray>, </gray><dark_aqua>members</dark_aqua><gray>, </gray><dark_aqua>info</dark_aqua><gray>, </gray><dark_aqua>tp</dark_aqua><gray>, </gray><dark_aqua>sethome</dark_aqua>"));
            return false;
        }
        switch (sub = args[0].toLowerCase()) {
            case "l": 
            case "list": {
                if (!Permissions.hasPermission(player, Permission.PERMISSION_CLUSTER_LIST)) {
                    player.sendMessage(TranslatableCaption.of("permission.no_permission"), Template.of((String)"node", (String)String.valueOf((Object)Permission.PERMISSION_CLUSTER_LIST)));
                    return false;
                }
                if (args.length != 1) {
                    player.sendMessage(TranslatableCaption.of("commandconfig.command_syntax"), Template.of((String)"value", (String)"/plot cluster list"));
                    return false;
                }
                PlotArea area = player.getApplicablePlotArea();
                if (area == null) {
                    player.sendMessage(TranslatableCaption.of("errors.not_in_plot_world"), new Template[0]);
                    return false;
                }
                Set<PlotCluster> clusters = area.getClusters();
                player.sendMessage(TranslatableCaption.of("cluster.cluster_list_heading"), Template.of((String)"amount", (String)("" + clusters.size())));
                for (PlotCluster cluster : clusters) {
                    String name = "'" + cluster.getName() + "' : " + cluster;
                    if (player.getUUID().equals(cluster.owner)) {
                        player.sendMessage(TranslatableCaption.of("cluster.cluster_list_element_owner"), Template.of((String)"cluster", (String)name));
                        continue;
                    }
                    if (cluster.helpers.contains(player.getUUID())) {
                        player.sendMessage(TranslatableCaption.of("cluster.cluster_list_element_helpers"), Template.of((String)"cluster", (String)name));
                        continue;
                    }
                    if (cluster.invited.contains(player.getUUID())) {
                        player.sendMessage(TranslatableCaption.of("cluster.cluster_list_element_invited"), Template.of((String)"cluster", (String)name));
                        continue;
                    }
                    player.sendMessage(TranslatableCaption.of("cluster.cluster_list_element"), Template.of((String)"cluster", (String)cluster.toString()));
                }
                return true;
            }
            case "c": 
            case "create": {
                PlotCluster cluster;
                PlotId pos2;
                PlotId pos1;
                int currentClusters;
                if (!Permissions.hasPermission(player, Permission.PERMISSION_CLUSTER_CREATE)) {
                    player.sendMessage(TranslatableCaption.of("permission.no_permission"), Template.of((String)"node", (String)String.valueOf((Object)Permission.PERMISSION_CLUSTER_CREATE)));
                    return false;
                }
                PlotArea area = player.getApplicablePlotArea();
                if (area == null) {
                    player.sendMessage(TranslatableCaption.of("errors.not_in_plot_world"), new Template[0]);
                    return false;
                }
                if (args.length != 4) {
                    player.sendMessage(TranslatableCaption.of("commandconfig.command_syntax"), Template.of((String)"value", (String)"/plot cluster create <name> <id-bot> <id-top>"));
                    return false;
                }
                int n = currentClusters = Settings.Limit.GLOBAL ? player.getClusterCount() : player.getPlotCount(player.getLocation().getWorldName());
                if (currentClusters >= player.getAllowedPlots()) {
                    player.sendMessage(TranslatableCaption.of("permission.cant_claim_more_clusters"), Template.of((String)"amount", (String)String.valueOf(player.getAllowedPlots())));
                }
                try {
                    pos1 = PlotId.fromString(args[2]);
                    pos2 = PlotId.fromString(args[3]);
                }
                catch (IllegalArgumentException ignored) {
                    player.sendMessage(TranslatableCaption.of("invalid.not_valid_plot_id"), new Template[0]);
                    return false;
                }
                String name = args[1];
                if (area.getCluster(name) != null) {
                    player.sendMessage(TranslatableCaption.of("alias.alias_is_taken"), Template.of((String)"alias", (String)name));
                    return false;
                }
                if (pos2.getX() < pos1.getX() || pos2.getY() < pos1.getY()) {
                    PlotId tmp = PlotId.of(Math.min(pos1.getX(), pos2.getX()), Math.min(pos1.getY(), pos2.getY()));
                    pos2 = PlotId.of(Math.max(pos1.getX(), pos2.getX()), Math.max(pos1.getY(), pos2.getY()));
                    pos1 = tmp;
                }
                if ((cluster = area.getFirstIntersectingCluster(pos1, pos2)) != null) {
                    player.sendMessage(TranslatableCaption.of("cluster.cluster_intersection"), Template.of((String)"cluster", (String)cluster.getName()));
                    return false;
                }
                if (!area.contains(pos1) || !area.contains(pos2)) {
                    player.sendMessage(TranslatableCaption.of("cluster.cluster_outside"), Template.of((String)"area", (String)String.valueOf(area)));
                    return false;
                }
                Set<Plot> plots = area.getPlotSelectionOwned(pos1, pos2);
                if (!plots.isEmpty() && !Permissions.hasPermission(player, Permission.PERMISSION_CLUSTER_CREATE_OTHER)) {
                    UUID uuid2 = player.getUUID();
                    for (Plot plot : plots) {
                        if (plot.isOwner(uuid2)) continue;
                        player.sendMessage(TranslatableCaption.of("permission.no_permission"), Template.of((String)"node", (String)String.valueOf((Object)Permission.PERMISSION_CLUSTER_CREATE_OTHER)));
                        return false;
                    }
                }
                cluster = new PlotCluster(area, pos1, pos2, player.getUUID());
                int current = Settings.Limit.GLOBAL ? player.getPlayerClusterCount() : player.getPlayerClusterCount(player.getLocation().getWorldName());
                int allowed = Permissions.hasPermissionRange(player, Permission.PERMISSION_CLUSTER_SIZE, Settings.Limit.MAX_PLOTS);
                if (current + cluster.getArea() > allowed) {
                    player.sendMessage(TranslatableCaption.of("permission.no_permission"), Template.of((String)"node", (String)(Permission.PERMISSION_CLUSTER_SIZE + "." + (current + cluster.getArea()))));
                    return false;
                }
                cluster.settings.setAlias(name);
                area.addCluster(cluster);
                DBFunc.createCluster(cluster);
                for (Plot plot : plots) {
                    if (!plot.hasOwner() || cluster.isAdded(plot.getOwner())) continue;
                    cluster.invited.add(plot.getOwner());
                    DBFunc.setInvited(cluster, plot.getOwner());
                }
                player.sendMessage(TranslatableCaption.of("cluster.cluster_created"), Template.of((String)"name", (String)name));
                return true;
            }
            case "disband": 
            case "del": 
            case "delete": {
                PlotCluster cluster;
                if (!Permissions.hasPermission(player, Permission.PERMISSION_CLUSTER_DELETE)) {
                    player.sendMessage(TranslatableCaption.of("permission.no_permission"), Template.of((String)"node", (String)String.valueOf((Object)Permission.PERMISSION_CLUSTER_DELETE)));
                    return false;
                }
                if (args.length != 1 && args.length != 2) {
                    player.sendMessage(TranslatableCaption.of("commandconfig.command_syntax"), Template.of((String)"value", (String)"/plot cluster delete [name]"));
                    return false;
                }
                PlotArea area = player.getApplicablePlotArea();
                if (area == null) {
                    player.sendMessage(TranslatableCaption.of("errors.not_in_plot_world"), new Template[0]);
                    return false;
                }
                if (args.length == 2) {
                    cluster = area.getCluster(args[1]);
                    if (cluster == null) {
                        player.sendMessage(TranslatableCaption.of("cluster.invalid_cluster_name"), Template.of((String)"cluster", (String)args[1]));
                        return false;
                    }
                } else {
                    cluster = area.getCluster(player.getLocation());
                    if (cluster == null) {
                        player.sendMessage(TranslatableCaption.of("errors.not_in_cluster"), new Template[0]);
                        return false;
                    }
                }
                if (!cluster.owner.equals(player.getUUID()) && !Permissions.hasPermission(player, Permission.PERMISSION_CLUSTER_DELETE_OTHER)) {
                    player.sendMessage(TranslatableCaption.of("permission.no_permission"), Template.of((String)"node", (String)String.valueOf((Object)Permission.PERMISSION_CLUSTER_DELETE_OTHER)));
                    return false;
                }
                DBFunc.delete(cluster);
                player.sendMessage(TranslatableCaption.of("cluster.cluster_deleted"), Template.of((String)"cluster", (String)String.valueOf(cluster)));
                return true;
            }
            case "res": 
            case "resize": {
                PlotArea area;
                PlotId pos2;
                PlotId pos1;
                if (!Permissions.hasPermission(player, Permission.PERMISSION_CLUSTER_RESIZE)) {
                    player.sendMessage(TranslatableCaption.of("permission.no_permission"), Template.of((String)"node", (String)String.valueOf((Object)Permission.PERMISSION_CLUSTER_RESIZE)));
                    return false;
                }
                if (args.length != 3) {
                    player.sendMessage(TranslatableCaption.of("commandconfig.command_syntax"), Template.of((String)"value", (String)"/plot cluster resize [name]"));
                    return false;
                }
                try {
                    pos1 = PlotId.fromString(args[2]);
                    pos2 = PlotId.fromString(args[3]);
                }
                catch (IllegalArgumentException ignored) {
                    player.sendMessage(TranslatableCaption.of("invalid.not_valid_plot_id"), new Template[0]);
                    return false;
                }
                if (pos2.getX() < pos1.getX() || pos2.getY() < pos1.getY()) {
                    pos1 = PlotId.of(Math.min(pos1.getX(), pos2.getX()), Math.min(pos1.getY(), pos2.getY()));
                    pos2 = PlotId.of(Math.max(pos1.getX(), pos2.getX()), Math.max(pos1.getY(), pos2.getY()));
                }
                if ((area = player.getApplicablePlotArea()) == null) {
                    player.sendMessage(TranslatableCaption.of("errors.not_in_plot_world"), new Template[0]);
                    return false;
                }
                PlotCluster cluster = area.getCluster(player.getLocation());
                if (cluster == null) {
                    player.sendMessage(TranslatableCaption.of("errors.not_in_cluster"), new Template[0]);
                    return false;
                }
                if (!cluster.hasHelperRights(player.getUUID()) && !Permissions.hasPermission(player, Permission.PERMISSION_CLUSTER_RESIZE_OTHER)) {
                    player.sendMessage(TranslatableCaption.of("permission.no_permission"), Template.of((String)"node", (String)String.valueOf((Object)Permission.PERMISSION_CLUSTER_RESIZE_OTHER)));
                    return false;
                }
                PlotCluster intersect = area.getFirstIntersectingCluster(pos1, pos2);
                if (intersect != null) {
                    player.sendMessage(TranslatableCaption.of("cluster.cluster_intersection"), Template.of((String)"cluster", (String)intersect.getName()));
                    return false;
                }
                Set<Plot> existing = area.getPlotSelectionOwned(cluster.getP1(), cluster.getP2());
                Set<Plot> newPlots = area.getPlotSelectionOwned(pos1, pos2);
                HashSet<Plot> removed = new HashSet<Plot>(existing);
                removed.removeAll(newPlots);
                if (!removed.isEmpty() && !Permissions.hasPermission(player, Permission.PERMISSION_CLUSTER_RESIZE_SHRINK)) {
                    player.sendMessage(TranslatableCaption.of("permission.no_permission"), Template.of((String)"node", (String)String.valueOf((Object)Permission.PERMISSION_CLUSTER_RESIZE_SHRINK)));
                    return false;
                }
                newPlots.removeAll(existing);
                if (!newPlots.isEmpty() && !Permissions.hasPermission(player, Permission.PERMISSION_CLUSTER_RESIZE_EXPAND)) {
                    player.sendMessage(TranslatableCaption.of("permission.no_permission"), Template.of((String)"node", (String)String.valueOf((Object)Permission.PERMISSION_CLUSTER_RESIZE_EXPAND)));
                    return false;
                }
                int current = Settings.Limit.GLOBAL ? player.getPlayerClusterCount() : player.getPlayerClusterCount(player.getLocation().getWorldName());
                int n = Permissions.hasPermissionRange(player, Permission.PERMISSION_CLUSTER, Settings.Limit.MAX_PLOTS);
                if ((current -= cluster.getArea() + (1 + pos2.getX() - pos1.getX()) * (1 + pos2.getY() - pos1.getY())) + cluster.getArea() > n) {
                    player.sendMessage(TranslatableCaption.of("permission.no_permission"), Template.of((String)"node", (String)(Permission.PERMISSION_CLUSTER + "." + (current + cluster.getArea()))));
                    return false;
                }
                DBFunc.resizeCluster(cluster, pos1, pos2);
                player.sendMessage(TranslatableCaption.of("cluster.cluster_resized"), new Template[0]);
                return true;
            }
            case "add": 
            case "inv": 
            case "invite": {
                PlotCluster cluster;
                if (!Permissions.hasPermission(player, Permission.PERMISSION_CLUSTER_INVITE)) {
                    player.sendMessage(TranslatableCaption.of("permission.no_permission"), Template.of((String)"node", (String)String.valueOf((Object)Permission.PERMISSION_CLUSTER_INVITE)));
                    return false;
                }
                if (args.length != 2) {
                    player.sendMessage(TranslatableCaption.of("commandconfig.command_syntax"), Template.of((String)"value", (String)"/plot cluster invite <player>"));
                    return false;
                }
                PlotArea area = player.getApplicablePlotArea();
                if (area == null) {
                    player.sendMessage(TranslatableCaption.of("errors.not_in_plot_world"), new Template[0]);
                }
                if ((cluster = area.getCluster(player.getLocation())) == null) {
                    player.sendMessage(TranslatableCaption.of("errors.not_in_cluster"), new Template[0]);
                    return false;
                }
                if (!cluster.hasHelperRights(player.getUUID()) && !Permissions.hasPermission(player, Permission.PERMISSION_CLUSTER_INVITE_OTHER)) {
                    player.sendMessage(TranslatableCaption.of("permission.no_permission"), Template.of((String)"node", (String)Permission.PERMISSION_CLUSTER_INVITE_OTHER.toString()));
                    return false;
                }
                PlotSquared.get().getImpromptuUUIDPipeline().getSingle(args[1], (uuid, throwable) -> {
                    if (throwable instanceof TimeoutException) {
                        player.sendMessage(TranslatableCaption.of("players.fetching_players_timeout"), new Template[0]);
                    } else if (throwable != null) {
                        player.sendMessage(TranslatableCaption.of("errors.invalid_player"), Template.of((String)"value", (String)args[1]));
                    } else {
                        if (!cluster.isAdded((UUID)uuid)) {
                            cluster.invited.add((UUID)uuid);
                            DBFunc.setInvited(cluster, uuid);
                            PlotPlayer<?> otherPlayer = PlotSquared.platform().playerManager().getPlayerIfExists((UUID)uuid);
                            if (otherPlayer != null) {
                                player.sendMessage(TranslatableCaption.of("cluster.cluster_invited"), Template.of((String)"cluster", (String)cluster.getName()));
                            }
                        }
                        player.sendMessage(TranslatableCaption.of("cluster.cluster_added_user"), new Template[0]);
                    }
                });
                return true;
            }
            case "k": 
            case "remove": 
            case "kick": {
                PlotCluster cluster;
                if (!Permissions.hasPermission(player, Permission.PERMISSION_CLUSTER_KICK)) {
                    player.sendMessage(TranslatableCaption.of("permission.no_permission"), Template.of((String)"node", (String)Permission.PERMISSION_CLUSTER_KICK.toString()));
                    return false;
                }
                if (args.length != 2) {
                    player.sendMessage(TranslatableCaption.of("commandconfig.command_syntax"), Template.of((String)"value", (String)"/plot cluster kick <player>"));
                    return false;
                }
                PlotArea area = player.getApplicablePlotArea();
                if (area == null) {
                    player.sendMessage(TranslatableCaption.of("errors.not_in_plot_world"), new Template[0]);
                }
                if ((cluster = area.getCluster(player.getLocation())) == null) {
                    player.sendMessage(TranslatableCaption.of("errors.not_in_cluster"), new Template[0]);
                    return false;
                }
                if (!cluster.hasHelperRights(player.getUUID()) && !Permissions.hasPermission(player, Permission.PERMISSION_CLUSTER_KICK_OTHER)) {
                    player.sendMessage(TranslatableCaption.of("permission.no_permission"), Template.of((String)"node", (String)Permission.PERMISSION_CLUSTER_KICK_OTHER.toString()));
                    return false;
                }
                PlotSquared.get().getImpromptuUUIDPipeline().getSingle(args[1], (uuid, throwable) -> {
                    if (throwable instanceof TimeoutException) {
                        player.sendMessage(TranslatableCaption.of("players.fetching_players_timeout"), new Template[0]);
                    } else if (throwable != null) {
                        player.sendMessage(TranslatableCaption.of("errors.invalid_player"), Template.of((String)"value", (String)args[1]));
                    } else if (uuid.equals(player.getUUID()) || uuid.equals(cluster.owner) || !cluster.isAdded((UUID)uuid)) {
                        player.sendMessage(TranslatableCaption.of("cluster.cannot_kick_player"), Template.of((String)"value", (String)cluster.getName()));
                    } else {
                        if (cluster.helpers.contains(uuid)) {
                            cluster.helpers.remove(uuid);
                            DBFunc.removeHelper(cluster, uuid);
                        }
                        cluster.invited.remove(uuid);
                        DBFunc.removeInvited(cluster, uuid);
                        PlotPlayer<?> player2 = PlotSquared.platform().playerManager().getPlayerIfExists((UUID)uuid);
                        if (player2 != null) {
                            player.sendMessage(TranslatableCaption.of("cluster.cluster_removed"), Template.of((String)"cluster", (String)cluster.getName()));
                        }
                        this.removePlayerPlots(cluster, (UUID)uuid, player2.getLocation().getWorldName());
                        player.sendMessage(TranslatableCaption.of("cluster.cluster_kicked_user"), new Template[0]);
                    }
                });
                return true;
            }
            case "quit": 
            case "leave": {
                UUID uuid3;
                PlotCluster cluster;
                if (!Permissions.hasPermission(player, Permission.PERMISSION_CLUSTER_LEAVE)) {
                    player.sendMessage(TranslatableCaption.of("permission.no_permission"), Template.of((String)"node", (String)Permission.PERMISSION_CLUSTER_LEAVE.toString()));
                    return false;
                }
                if (args.length != 1 && args.length != 2) {
                    player.sendMessage(TranslatableCaption.of("commandconfig.command_syntax"), Template.of((String)"value", (String)"/plot cluster leave [name]"));
                    return false;
                }
                PlotArea area = player.getApplicablePlotArea();
                if (area == null) {
                    player.sendMessage(TranslatableCaption.of("errors.not_in_plot_world"), new Template[0]);
                }
                if (args.length == 2) {
                    cluster = area.getCluster(args[1]);
                    if (cluster == null) {
                        player.sendMessage(TranslatableCaption.of("cluster.invalid_cluster_name"), Template.of((String)"cluster", (String)args[1]));
                        return false;
                    }
                } else {
                    cluster = area.getCluster(player.getLocation());
                    if (cluster == null) {
                        player.sendMessage(TranslatableCaption.of("errors.not_in_cluster"), new Template[0]);
                        return false;
                    }
                }
                if (!cluster.isAdded(uuid3 = player.getUUID())) {
                    player.sendMessage(TranslatableCaption.of("cluster.cluster_not_added"), new Template[0]);
                    return false;
                }
                if (uuid3.equals(cluster.owner)) {
                    player.sendMessage(TranslatableCaption.of("cluster.cluster_cannot_leave"), new Template[0]);
                    return false;
                }
                if (cluster.helpers.contains(uuid3)) {
                    cluster.helpers.remove(uuid3);
                    DBFunc.removeHelper(cluster, uuid3);
                }
                cluster.invited.remove(uuid3);
                DBFunc.removeInvited(cluster, uuid3);
                player.sendMessage(TranslatableCaption.of("cluster.cluster_removed"), Template.of((String)"cluster", (String)cluster.getName()));
                this.removePlayerPlots(cluster, uuid3, player.getLocation().getWorldName());
                return true;
            }
            case "members": {
                PlotCluster cluster;
                if (!Permissions.hasPermission(player, Permission.PERMISSION_CLUSTER_HELPERS)) {
                    player.sendMessage(TranslatableCaption.of("permission.no_permission"), Template.of((String)"node", (String)Permission.PERMISSION_CLUSTER_HELPERS.toString()));
                    return false;
                }
                if (args.length != 3) {
                    player.sendMessage(TranslatableCaption.of("commandconfig.command_syntax"), Template.of((String)"value", (String)"/plot cluster members <add | remove> <player>"));
                    return false;
                }
                PlotArea area = player.getApplicablePlotArea();
                if (area == null) {
                    player.sendMessage(TranslatableCaption.of("errors.not_in_plot_world"), new Template[0]);
                }
                if ((cluster = area.getCluster(player.getLocation())) == null) {
                    player.sendMessage(TranslatableCaption.of("errors.not_in_cluster"), new Template[0]);
                    return false;
                }
                PlotSquared.get().getImpromptuUUIDPipeline().getSingle(args[2], (uuid, throwable) -> {
                    if (throwable instanceof TimeoutException) {
                        player.sendMessage(TranslatableCaption.of("players.fetching_players_timeout"), new Template[0]);
                    } else if (throwable != null) {
                        player.sendMessage(TranslatableCaption.of("errors.invalid_player"), Template.of((String)"value", (String)args[2]));
                    } else if (args[1].equalsIgnoreCase("add")) {
                        cluster.helpers.add((UUID)uuid);
                        DBFunc.setHelper(cluster, uuid);
                        player.sendMessage(TranslatableCaption.of("cluster.cluster_added_helper"), new Template[0]);
                    } else if (args[1].equalsIgnoreCase("remove")) {
                        cluster.helpers.remove(uuid);
                        DBFunc.removeHelper(cluster, uuid);
                        player.sendMessage(TranslatableCaption.of("cluster.cluster_removed_helper"), new Template[0]);
                    } else {
                        player.sendMessage(TranslatableCaption.of("commandconfig.command_syntax"), Template.of((String)"value", (String)"/plot cluster members <add | remove> <player>"));
                    }
                });
                return true;
            }
            case "spawn": 
            case "home": 
            case "tp": {
                if (!Permissions.hasPermission(player, Permission.PERMISSION_CLUSTER_TP)) {
                    player.sendMessage(TranslatableCaption.of("permission.no_permission"), Template.of((String)"node", (String)Permission.PERMISSION_CLUSTER_TP.toString()));
                    return false;
                }
                if (args.length != 2) {
                    player.sendMessage(TranslatableCaption.of("commandconfig.command_syntax"), Template.of((String)"value", (String)"/plot cluster tp <name>"));
                    return false;
                }
                PlotArea area = player.getApplicablePlotArea();
                if (area == null) {
                    player.sendMessage(TranslatableCaption.of("errors.not_in_plot_world"), new Template[0]);
                    return false;
                }
                PlotCluster cluster = area.getCluster(args[1]);
                if (cluster == null) {
                    player.sendMessage(TranslatableCaption.of("cluster.invalid_cluster_name"), Template.of((String)"cluster", (String)args[1]));
                    return false;
                }
                UUID uuid4 = player.getUUID();
                if (!cluster.isAdded(uuid4) && !Permissions.hasPermission(player, Permission.PERMISSION_CLUSTER_TP_OTHER)) {
                    player.sendMessage(TranslatableCaption.of("permission.no_permission"), Template.of((String)"node", (String)Permission.PERMISSION_CLUSTER_TP_OTHER.toString()));
                    return false;
                }
                cluster.getHome(home -> player.teleport((Location)home, TeleportCause.COMMAND_CLUSTER_TELEPORT));
                player.sendMessage(TranslatableCaption.of("cluster.cluster_teleporting"), new Template[0]);
                return true;
            }
            case "i": 
            case "info": 
            case "show": 
            case "information": {
                PlotCluster cluster;
                PlotArea area;
                if (!Permissions.hasPermission(player, Permission.PERMISSION_CLUSTER_INFO)) {
                    player.sendMessage(TranslatableCaption.of("permission.no_permission"), Template.of((String)"node", (String)Permission.PERMISSION_CLUSTER_TP.toString()));
                    return false;
                }
                if (args.length != 1 && args.length != 2) {
                    player.sendMessage(TranslatableCaption.of("commandconfig.command_syntax"), Template.of((String)"value", (String)"/plot cluster info [name]"));
                }
                if ((area = player.getApplicablePlotArea()) == null) {
                    player.sendMessage(TranslatableCaption.of("errors.not_in_plot_world"), new Template[0]);
                    return false;
                }
                if (args.length == 2) {
                    cluster = area.getCluster(args[1]);
                    if (cluster == null) {
                        player.sendMessage(TranslatableCaption.of("cluster.invalid_cluster_name"), Template.of((String)"cluster", (String)args[1]));
                        return false;
                    }
                } else {
                    cluster = area.getCluster(player.getLocation());
                    if (cluster == null) {
                        player.sendMessage(TranslatableCaption.of("errors.not_in_cluster"), new Template[0]);
                        return false;
                    }
                }
                String id = cluster.toString();
                PlotSquared.get().getImpromptuUUIDPipeline().getSingle(cluster.owner, (username, throwable) -> {
                    if (throwable instanceof TimeoutException) {
                        player.sendMessage(TranslatableCaption.of("players.fetching_players_timeout"), new Template[0]);
                    } else {
                        String owner = username == null ? "unknown" : username;
                        String name = cluster.getName();
                        String size = cluster.getP2().getX() - cluster.getP1().getX() + 1 + "x" + (cluster.getP2().getY() - cluster.getP1().getY() + 1);
                        String rights = "" + cluster.isAdded(player.getUUID());
                        TranslatableCaption message = TranslatableCaption.of("cluster.cluster_info");
                        Template idTemplate = Template.of((String)"id", (String)id);
                        Template ownerTemplate = Template.of((String)"owner", (String)owner);
                        Template nameTemplate = Template.of((String)"name", (String)name);
                        Template sizeTemplate = Template.of((String)"size", (String)size);
                        Template rightsTemplate = Template.of((String)"rights", (String)rights);
                        player.sendMessage(message, idTemplate, ownerTemplate, nameTemplate, sizeTemplate, rightsTemplate);
                    }
                });
                return true;
            }
            case "sh": 
            case "setspawn": 
            case "sethome": {
                PlotCluster cluster;
                if (!Permissions.hasPermission(player, Permission.PERMISSION_CLUSTER_SETHOME)) {
                    player.sendMessage(TranslatableCaption.of("permission.no_permission"), Template.of((String)"node", (String)Permission.PERMISSION_CLUSTER_SETHOME.toString()));
                    return false;
                }
                if (args.length != 1 && args.length != 2) {
                    player.sendMessage(TranslatableCaption.of("commandconfig.command_syntax"), Template.of((String)"value", (String)"/plot cluster sethome"));
                    return false;
                }
                PlotArea area = player.getApplicablePlotArea();
                if (area == null) {
                    player.sendMessage(TranslatableCaption.of("errors.not_in_plot_world"), new Template[0]);
                }
                if ((cluster = area.getCluster(player.getLocation())) == null) {
                    player.sendMessage(TranslatableCaption.of("errors.not_in_cluster"), new Template[0]);
                    return false;
                }
                if (!cluster.hasHelperRights(player.getUUID()) && !Permissions.hasPermission(player, Permission.PERMISSION_CLUSTER_SETHOME_OTHER)) {
                    player.sendMessage(TranslatableCaption.of("permission.no_permission"), Template.of((String)"node", (String)Permission.PERMISSION_CLUSTER_SETHOME_OTHER.toString()));
                    return false;
                }
                Location base = cluster.getClusterBottom();
                Location relative = player.getLocation().subtract(base.getX(), 0, base.getZ());
                BlockLoc blockloc = new BlockLoc(relative.getX(), relative.getY(), relative.getZ());
                cluster.settings.setPosition(blockloc);
                DBFunc.setPosition(cluster, relative.getX() + "," + relative.getY() + "," + relative.getZ());
                player.sendMessage(TranslatableCaption.of("position.position_set"), new Template[0]);
                return true;
            }
        }
        player.sendMessage(TranslatableCaption.of("cluster.cluster_available_args"), Template.of((String)"list", (String)"<dark_aqua>list</dark_aqua><gray>, </gray><dark_aqua>create</dark_aqua><gray>, </gray><dark_aqua>delete</dark_aqua><gray>, </gray><dark_aqua>resize</dark_aqua><gray>, </gray><dark_aqua>invite</dark_aqua><gray>, </gray><dark_aqua>kick</dark_aqua><gray>, </gray><dark_aqua>leave</dark_aqua><gray>, </gray><dark_aqua>members</dark_aqua><gray>, </gray><dark_aqua>info</dark_aqua><gray>, </gray><dark_aqua>tp</dark_aqua><gray>, </gray><dark_aqua>sethome</dark_aqua>"));
        return false;
    }

    private void removePlayerPlots(PlotCluster cluster, UUID uuid, String world) {
        block0: for (Plot plot : PlotQuery.newQuery().inWorld(world).ownedBy(uuid)) {
            PlotCluster current = plot.getCluster();
            if (current == null || !current.equals(cluster)) continue;
            if (plot.getOwners().size() == 1) {
                plot.unclaim();
                continue;
            }
            for (UUID newOwner : plot.getOwners()) {
                if (newOwner.equals(uuid)) continue;
                plot.setOwner(newOwner);
                continue block0;
            }
        }
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> player, String[] args, boolean space) {
        if (args.length == 1) {
            LinkedList<String> completions = new LinkedList<String>();
            if (Permissions.hasPermission(player, Permission.PERMISSION_CLUSTER_LIST)) {
                completions.add("list");
            }
            if (Permissions.hasPermission(player, Permission.PERMISSION_CLUSTER_CREATE)) {
                completions.add("create");
            }
            if (Permissions.hasPermission(player, Permission.PERMISSION_CLUSTER_DELETE)) {
                completions.add("delete");
            }
            if (Permissions.hasPermission(player, Permission.PERMISSION_CLUSTER_RESIZE)) {
                completions.add("resize");
            }
            if (Permissions.hasPermission(player, Permission.PERMISSION_CLUSTER_INVITE)) {
                completions.add("invite");
            }
            if (Permissions.hasPermission(player, Permission.PERMISSION_CLUSTER_KICK)) {
                completions.add("kick");
            }
            if (Permissions.hasPermission(player, Permission.PERMISSION_CLUSTER_KICK)) {
                completions.add("leave");
            }
            if (Permissions.hasPermission(player, Permission.PERMISSION_CLUSTER_HELPERS)) {
                completions.add("members");
            }
            if (Permissions.hasPermission(player, Permission.PERMISSION_CLUSTER_INFO)) {
                completions.add("info");
            }
            if (Permissions.hasPermission(player, Permission.PERMISSION_CLUSTER_TP)) {
                completions.add("tp");
            }
            if (Permissions.hasPermission(player, Permission.PERMISSION_CLUSTER_SETHOME)) {
                completions.add("sethome");
            }
            List commands = completions.stream().filter(completion -> completion.toLowerCase().startsWith(args[0].toLowerCase())).map(completion -> new Command(null, true, (String)completion, "", RequiredType.NONE, CommandCategory.ADMINISTRATION){}).collect(Collectors.toCollection(LinkedList::new));
            if (Permissions.hasPermission(player, Permission.PERMISSION_CLUSTER) && args[0].length() > 0) {
                commands.addAll(TabCompletions.completePlayers(player, args[0], Collections.emptyList()));
            }
            return commands;
        }
        return TabCompletions.completePlayers(player, String.join((CharSequence)",", args).trim(), Collections.emptyList());
    }
}

