/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.google.inject.Inject;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.generator.HybridPlotManager;
import com.plotsquared.core.generator.HybridUtils;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotManager;
import com.plotsquared.core.queue.QueueCoordinator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.kyori.adventure.text.minimessage.Template;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="debugroadregen", usage="/plot debugroadregen <plot | region [height]>", requiredType=RequiredType.NONE, category=CommandCategory.DEBUG, permission="plots.debugroadregen")
public class DebugRoadRegen
extends SubCommand {
    public static final String USAGE = "/plot debugroadregen <plot | region [height]>";
    private final HybridUtils hybridUtils;

    @Inject
    public DebugRoadRegen(@NonNull HybridUtils hybridUtils) {
        this.hybridUtils = hybridUtils;
    }

    @Override
    public boolean onCommand(PlotPlayer<?> player, String[] args) {
        String kind;
        Location location = player.getLocation();
        Plot plot = location.getPlotAbs();
        if (args.length < 1) {
            player.sendMessage(TranslatableCaption.of("commandconfig.command_syntax"), Template.of((String)"value", (String)USAGE));
            return false;
        }
        PlotArea area = player.getPlotAreaAbs();
        this.check(area, TranslatableCaption.of("errors.not_in_plot_world"), new Template[0]);
        if (plot.getVolume() > 2.147483647E9) {
            player.sendMessage(TranslatableCaption.of("schematics.schematic_too_large"), new Template[0]);
            return false;
        }
        switch (kind = args[0].toLowerCase()) {
            case "plot": {
                return this.regenPlot(player);
            }
            case "region": {
                return this.regenRegion(player, Arrays.copyOfRange(args, 1, args.length));
            }
        }
        player.sendMessage(TranslatableCaption.of("commandconfig.command_syntax"), Template.of((String)"value", (String)USAGE));
        return false;
    }

    public boolean regenPlot(PlotPlayer<?> player) {
        Plot plot;
        Location location = player.getLocation();
        PlotArea area = location.getPlotArea();
        if (area == null) {
            player.sendMessage(TranslatableCaption.of("errors.not_in_plot_world"), new Template[0]);
        }
        if ((plot = player.getCurrentPlot()) == null) {
            player.sendMessage(TranslatableCaption.of("errors.not_in_plot"), new Template[0]);
        } else if (plot.isMerged()) {
            player.sendMessage(TranslatableCaption.of("debug.requires_unmerged"), new Template[0]);
        } else {
            PlotManager manager = area.getPlotManager();
            QueueCoordinator queue = area.getQueue();
            queue.setCompleteTask(() -> {
                player.sendMessage(TranslatableCaption.of("debugroadregen.regen_done"), Template.of((String)"value", (String)plot.getId().toString()));
                player.sendMessage(TranslatableCaption.of("debugroadregen.regen_all"), Template.of((String)"value", (String)"/plot regenallroads"));
            });
            manager.createRoadEast(plot, queue);
            manager.createRoadSouth(plot, queue);
            manager.createRoadSouthEast(plot, queue);
            queue.enqueue();
        }
        return true;
    }

    public boolean regenRegion(PlotPlayer<?> player, String[] args) {
        int height = 0;
        if (args.length == 1) {
            try {
                height = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException ignored) {
                player.sendMessage(TranslatableCaption.of("invalid.not_valid_number"), Template.of((String)"value", (String)"0, 256"));
                player.sendMessage(TranslatableCaption.of("commandconfig.command_syntax"), Template.of((String)"value", (String)USAGE));
                return false;
            }
        } else if (args.length != 0) {
            player.sendMessage(TranslatableCaption.of("commandconfig.command_syntax"), Template.of((String)"value", (String)USAGE));
            return false;
        }
        Location location = player.getLocation();
        PlotArea area = location.getPlotArea();
        if (area == null) {
            player.sendMessage(TranslatableCaption.of("errors.not_in_plot_world"), new Template[0]);
        }
        Plot plot = player.getCurrentPlot();
        PlotManager manager = area.getPlotManager();
        if (!(manager instanceof HybridPlotManager)) {
            player.sendMessage(TranslatableCaption.of("errors.invalid_plot_world"), new Template[0]);
            return true;
        }
        player.sendMessage(TranslatableCaption.of("debugroadregen.schematic"), Template.of((String)"command", (String)"/plot createroadschematic"));
        player.sendMessage(TranslatableCaption.of("debugroadregen.regenallroads"), Template.of((String)"command", (String)"/plot regenallroads"));
        boolean result = this.hybridUtils.scheduleSingleRegionRoadUpdate(plot, height);
        if (!result) {
            player.sendMessage(TranslatableCaption.of("debugexec.mass_schematic_update_in_progress"), new Template[0]);
            return false;
        }
        return true;
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> player, String[] args, boolean space) {
        return Stream.of("plot", "region").filter(value -> value.startsWith(args[0].toLowerCase(Locale.ENGLISH))).map(value -> new Command(null, false, (String)value, "plots.debugroadregen", RequiredType.NONE, null){}).collect(Collectors.toList());
    }
}

