/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.google.inject.Inject;
import com.plotsquared.core.command.CmdConfirm;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.events.Result;
import com.plotsquared.core.events.TeleportCause;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.util.EconHandler;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.Permissions;
import com.plotsquared.core.util.PlotExpression;
import com.plotsquared.core.util.task.TaskManager;
import java.util.Set;
import net.kyori.adventure.text.minimessage.Template;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="delete", permission="plots.delete", usage="/plot delete", aliases={"dispose", "del"}, category=CommandCategory.CLAIMING, requiredType=RequiredType.NONE, confirmation=true)
public class Delete
extends SubCommand {
    private final EventDispatcher eventDispatcher;
    private final EconHandler econHandler;

    @Inject
    public Delete(@NonNull EventDispatcher eventDispatcher, @NonNull EconHandler econHandler) {
        this.eventDispatcher = eventDispatcher;
        this.econHandler = econHandler;
    }

    @Override
    public boolean onCommand(PlotPlayer<?> player, String[] args) {
        boolean force;
        Location location = player.getLocation();
        Plot plot = location.getPlotAbs();
        if (plot == null) {
            player.sendMessage(TranslatableCaption.of("errors.not_in_plot"), new Template[0]);
            return false;
        }
        if (!plot.hasOwner()) {
            player.sendMessage(TranslatableCaption.of("info.plot_unowned"), new Template[0]);
            return false;
        }
        if (plot.getVolume() > 2.147483647E9) {
            player.sendMessage(TranslatableCaption.of("schematics.schematic_too_large"), new Template[0]);
            return false;
        }
        Result eventResult = this.eventDispatcher.callDelete(plot).getEventResult();
        if (eventResult == Result.DENY) {
            player.sendMessage(TranslatableCaption.of("events.event_denied"), Template.of((String)"value", (String)"Delete"));
            return true;
        }
        boolean bl = force = eventResult == Result.FORCE;
        if (!(force || plot.isOwner(player.getUUID()) || Permissions.hasPermission(player, Permission.PERMISSION_ADMIN_COMMAND_DELETE))) {
            player.sendMessage(TranslatableCaption.of("permission.no_plot_perms"), new Template[0]);
            return false;
        }
        PlotArea plotArea = plot.getArea();
        Set<Plot> plots = plot.getConnectedPlots();
        int currentPlots = Settings.Limit.GLOBAL ? player.getPlotCount() : player.getPlotCount(location.getWorldName());
        Runnable run = () -> {
            boolean result;
            if (plot.getRunning() > 0) {
                player.sendMessage(TranslatableCaption.of("errors.wait_for_timer"), new Template[0]);
                return;
            }
            long start = System.currentTimeMillis();
            if (Settings.Teleport.ON_DELETE) {
                plot.getPlayersInPlot().forEach(playerInPlot -> plot.teleportPlayer((PlotPlayer<?>)playerInPlot, TeleportCause.COMMAND_DELETE, result -> {}));
            }
            if (result = plot.getPlotModificationManager().deletePlot(player, () -> {
                plot.removeRunning();
                if (this.econHandler.isEnabled(plotArea)) {
                    PlotExpression valueExr = plotArea.getPrices().get("sell");
                    double[] dArray = new double[]{currentPlots};
                    double value = (double)plots.size() * valueExr.evaluate(dArray);
                    if (value > 0.0) {
                        this.econHandler.depositMoney(player, value);
                        player.sendMessage(TranslatableCaption.of("economy.added_balance"), Template.of((String)"money", (String)this.econHandler.format(value)));
                    }
                }
                player.sendMessage(TranslatableCaption.of("working.deleting_done"), Template.of((String)"amount", (String)String.valueOf(System.currentTimeMillis() - start)), Template.of((String)"plot", (String)plot.getId().toString()));
                this.eventDispatcher.callPostDelete(plot);
            })) {
                plot.addRunning();
            } else {
                player.sendMessage(TranslatableCaption.of("errors.wait_for_timer"), new Template[0]);
            }
        };
        if (this.hasConfirmation(player)) {
            CmdConfirm.addPending(player, this.getCommandString() + " " + plot.getId(), run);
        } else {
            TaskManager.runTask(run);
        }
        return true;
    }
}

