/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.generator;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.generator.GeneratorWrapper;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.queue.ScopedQueueCoordinator;
import com.plotsquared.core.setup.PlotAreaBuilder;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class IndependentPlotGenerator {
    public abstract String getName();

    public abstract void generateChunk(ScopedQueueCoordinator var1, PlotArea var2);

    public boolean populateChunk(ScopedQueueCoordinator result, PlotArea setting) {
        return false;
    }

    public abstract PlotArea getNewPlotArea(String var1, String var2, PlotId var3, PlotId var4);

    public void processAreaSetup(PlotAreaBuilder builder) {
    }

    public abstract void initialize(PlotArea var1);

    public <T> GeneratorWrapper<T> specify(@NonNull String world) {
        return PlotSquared.platform().wrapPlotGenerator(world, this);
    }

    public String toString() {
        return this.getName();
    }
}

