/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.player;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.inject.TypeLiteral;
import com.plotsquared.core.synchronization.LockKey;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class MetaDataKey<T> {
    private static final Map<String, MetaDataKey<?>> keyMap = new HashMap();
    private static final Object keyMetaData = new Object();
    private final String key;
    private final TypeLiteral<T> type;
    private final LockKey lockKey;

    private MetaDataKey(@NonNull String key, @NonNull TypeLiteral<T> type) {
        this.key = (String)Preconditions.checkNotNull((Object)key, (Object)"Key may not be null");
        this.type = (TypeLiteral)Preconditions.checkNotNull(type, (Object)"Type may not be null");
        this.lockKey = LockKey.of(this.key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> @NonNull MetaDataKey<T> of(@NonNull String key, @NonNull TypeLiteral<T> type) {
        Object object = keyMetaData;
        synchronized (object) {
            return keyMap.computeIfAbsent(key, missingKey -> new MetaDataKey((String)missingKey, type));
        }
    }

    public String toString() {
        return this.key;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetaDataKey lockKey = (MetaDataKey)o;
        return Objects.equal((Object)this.key, (Object)lockKey.key);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.key});
    }

    public @NonNull LockKey getLockKey() {
        return this.lockKey;
    }

    public @NonNull TypeLiteral<T> getType() {
        return this.type;
    }
}

