/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.player;

import com.plotsquared.core.player.MetaDataAccess;
import com.plotsquared.core.player.MetaDataKey;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.synchronization.LockRepository;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class TemporaryMetaDataAccess<T>
extends MetaDataAccess<T> {
    TemporaryMetaDataAccess(@NonNull PlotPlayer<?> player, @NonNull MetaDataKey<T> metaDataKey, @NonNull LockRepository.LockAccess lockAccess) {
        super(player, metaDataKey, lockAccess);
    }

    @Override
    public boolean isPresent() {
        this.checkClosed();
        return this.getPlayer().getMeta(this.getMetaDataKey().toString()) != null;
    }

    @Override
    public @Nullable T remove() {
        this.checkClosed();
        Object old = this.getPlayer().deleteMeta(this.getMetaDataKey().toString());
        if (old == null) {
            return null;
        }
        return (T)old;
    }

    @Override
    public void set(@NonNull T value) {
        this.checkClosed();
        this.getPlayer().setMeta(this.getMetaDataKey().toString(), value);
    }

    @Override
    public @NonNull Optional<T> get() {
        this.checkClosed();
        return Optional.ofNullable(this.getPlayer().getMeta(this.getMetaDataKey().toString()));
    }
}

