/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.flag.types;

import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.plot.flag.FlagParseException;
import com.plotsquared.core.plot.flag.PlotFlag;
import net.kyori.adventure.text.minimessage.Template;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class TimedFlag<T, F extends PlotFlag<Timed<T>, F>>
extends PlotFlag<Timed<T>, F> {
    private final T defaultValue;

    protected TimedFlag(@NonNull Timed<T> value, T defaultValue, @NonNull Caption flagDescription) {
        super(value, TranslatableCaption.of("flags.flag_category_intervals"), flagDescription);
        this.defaultValue = defaultValue;
    }

    @Override
    public F parse(@NonNull String input) throws FlagParseException {
        int interval;
        String[] split = input.split(" ", 2);
        try {
            interval = Integer.parseInt(split[0]);
        }
        catch (Throwable throwable) {
            throw new FlagParseException(this, input, TranslatableCaption.of("flags.flag_error_integer"), new Template[0]);
        }
        if (interval < 1) {
            throw new FlagParseException(this, input, TranslatableCaption.of("flags.flag_error_integer"), new Template[0]);
        }
        if (split.length == 1) {
            return this.flagOf(new Timed<T>(interval, this.defaultValue));
        }
        T parsedValue = this.parseValue(split[1]);
        return this.flagOf(new Timed<T>(interval, parsedValue));
    }

    @Override
    public F merge(@NonNull Timed<T> newValue) {
        return this.flagOf(new Timed(((Timed)this.getValue()).interval + newValue.interval, this.mergeValue(newValue.value)));
    }

    protected abstract T parseValue(String var1) throws FlagParseException;

    protected abstract T mergeValue(T var1);

    @Override
    public String toString() {
        return ((Timed)this.getValue()).toString();
    }

    public static final class Timed<T> {
        private final int interval;
        private final T value;

        public Timed(int interval, T value) {
            this.interval = interval;
            this.value = value;
        }

        public int getInterval() {
            return this.interval;
        }

        public T getValue() {
            return this.value;
        }

        public String toString() {
            return String.format("%d %s", this.interval, this.value);
        }
    }
}

