/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util;

import com.google.common.eventbus.EventBus;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.events.PlayerAutoPlotEvent;
import com.plotsquared.core.events.PlayerAutoPlotsChosenEvent;
import com.plotsquared.core.events.PlayerClaimPlotEvent;
import com.plotsquared.core.events.PlayerEnterPlotEvent;
import com.plotsquared.core.events.PlayerLeavePlotEvent;
import com.plotsquared.core.events.PlayerPlotDeniedEvent;
import com.plotsquared.core.events.PlayerPlotHelperEvent;
import com.plotsquared.core.events.PlayerPlotTrustedEvent;
import com.plotsquared.core.events.PlayerTeleportToPlotEvent;
import com.plotsquared.core.events.PlotAutoMergeEvent;
import com.plotsquared.core.events.PlotChangeOwnerEvent;
import com.plotsquared.core.events.PlotClaimedNotifyEvent;
import com.plotsquared.core.events.PlotClearEvent;
import com.plotsquared.core.events.PlotComponentSetEvent;
import com.plotsquared.core.events.PlotDeleteEvent;
import com.plotsquared.core.events.PlotDoneEvent;
import com.plotsquared.core.events.PlotEvent;
import com.plotsquared.core.events.PlotFlagAddEvent;
import com.plotsquared.core.events.PlotFlagRemoveEvent;
import com.plotsquared.core.events.PlotMergeEvent;
import com.plotsquared.core.events.PlotRateEvent;
import com.plotsquared.core.events.PlotUnlinkEvent;
import com.plotsquared.core.events.TeleportCause;
import com.plotsquared.core.events.post.PostPlayerAutoPlotEvent;
import com.plotsquared.core.events.post.PostPlotChangeOwnerEvent;
import com.plotsquared.core.events.post.PostPlotDeleteEvent;
import com.plotsquared.core.events.post.PostPlotMergeEvent;
import com.plotsquared.core.events.post.PostPlotUnlinkEvent;
import com.plotsquared.core.listener.PlayerBlockEventType;
import com.plotsquared.core.location.Direction;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.plot.Rating;
import com.plotsquared.core.plot.expiration.ExpireManager;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.plot.flag.implementations.DeviceInteractFlag;
import com.plotsquared.core.plot.flag.implementations.MiscPlaceFlag;
import com.plotsquared.core.plot.flag.implementations.MobPlaceFlag;
import com.plotsquared.core.plot.flag.implementations.PlaceFlag;
import com.plotsquared.core.plot.flag.implementations.UseFlag;
import com.plotsquared.core.plot.flag.implementations.VehiclePlaceFlag;
import com.plotsquared.core.plot.flag.types.BlockTypeWrapper;
import com.plotsquared.core.plot.world.SinglePlotArea;
import com.plotsquared.core.util.AnnotationHelper;
import com.plotsquared.core.util.Permissions;
import com.plotsquared.core.util.task.TaskManager;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.minimessage.Template;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@AnnotationHelper.ApiDescription(info="This is an internal class used by PlotSquared to dispatch events.This is in no form part of the API and is subject to change at any time.")
public class EventDispatcher {
    private final EventBus eventBus = new EventBus("PlotSquaredEvents");
    private final List<Object> listeners = new ArrayList<Object>();
    private final WorldEdit worldEdit;

    public EventDispatcher(@Nullable WorldEdit worldEdit) {
        this.worldEdit = worldEdit;
    }

    public void registerListener(Object listener) {
        this.eventBus.register(listener);
        this.listeners.add(listener);
    }

    public void unregisterListener(Object listener) {
        this.eventBus.unregister(listener);
        this.listeners.remove(listener);
    }

    public void unregisterAll() {
        for (Object listener : this.listeners) {
            this.eventBus.unregister(listener);
        }
    }

    public void callGenericEvent(@NonNull Object event) {
        this.eventBus.post(event);
    }

    public void callEvent(@NonNull PlotEvent event) {
        this.eventBus.post((Object)event);
    }

    public PlayerClaimPlotEvent callClaim(PlotPlayer<?> player, Plot plot, String schematic) {
        PlayerClaimPlotEvent event = new PlayerClaimPlotEvent(player, plot, schematic);
        this.callEvent(event);
        return event;
    }

    public PlayerAutoPlotEvent callAuto(PlotPlayer<?> player, PlotArea area, String schematic, int size_x, int size_z) {
        PlayerAutoPlotEvent event = new PlayerAutoPlotEvent(player, area, schematic, size_x, size_z);
        this.callEvent(event);
        return event;
    }

    public PostPlayerAutoPlotEvent callPostAuto(PlotPlayer<?> player, Plot plot) {
        PostPlayerAutoPlotEvent event = new PostPlayerAutoPlotEvent(player, plot);
        this.callEvent(event);
        return event;
    }

    public PlayerAutoPlotsChosenEvent callAutoPlotsChosen(PlotPlayer<?> player, List<Plot> plots) {
        PlayerAutoPlotsChosenEvent event = new PlayerAutoPlotsChosenEvent(player, plots);
        this.callEvent(event);
        return event;
    }

    public PlotClaimedNotifyEvent callPlotClaimedNotify(Plot plot, boolean auto) {
        PlotClaimedNotifyEvent event = new PlotClaimedNotifyEvent(plot, auto);
        this.callEvent(event);
        return event;
    }

    public PlayerTeleportToPlotEvent callTeleport(PlotPlayer<?> player, Location from, Plot plot, TeleportCause cause) {
        PlayerTeleportToPlotEvent event = new PlayerTeleportToPlotEvent(player, from, plot, cause);
        this.callEvent(event);
        return event;
    }

    public PlotComponentSetEvent callComponentSet(Plot plot, String component, Pattern pattern) {
        PlotComponentSetEvent event = new PlotComponentSetEvent(plot, component, pattern);
        this.callEvent(event);
        return event;
    }

    public PlotClearEvent callClear(Plot plot) {
        PlotClearEvent event = new PlotClearEvent(plot);
        this.callEvent(event);
        return event;
    }

    public PlotDeleteEvent callDelete(Plot plot) {
        PlotDeleteEvent event = new PlotDeleteEvent(plot);
        this.callEvent(event);
        return event;
    }

    public PostPlotDeleteEvent callPostDelete(Plot plot) {
        PostPlotDeleteEvent event = new PostPlotDeleteEvent(plot);
        this.callEvent(event);
        return event;
    }

    public PlotFlagAddEvent callFlagAdd(PlotFlag<?, ?> flag, Plot plot) {
        PlotFlagAddEvent event = new PlotFlagAddEvent(flag, plot);
        this.callEvent(event);
        return event;
    }

    public PlotFlagRemoveEvent callFlagRemove(PlotFlag<?, ?> flag, Plot plot) {
        PlotFlagRemoveEvent event = new PlotFlagRemoveEvent(flag, plot);
        this.callEvent(event);
        return event;
    }

    public PlotMergeEvent callMerge(Plot plot, Direction dir, int max, PlotPlayer<?> player) {
        PlotMergeEvent event = new PlotMergeEvent(plot.getWorldName(), plot, dir, max, player);
        this.callEvent(event);
        return event;
    }

    public PostPlotMergeEvent callPostMerge(PlotPlayer<?> player, Plot plot) {
        PostPlotMergeEvent event = new PostPlotMergeEvent(player, plot);
        this.callEvent(event);
        return event;
    }

    public PlotAutoMergeEvent callAutoMerge(Plot plot, List<PlotId> plots) {
        PlotAutoMergeEvent event = new PlotAutoMergeEvent(plot.getWorldName(), plot, plots);
        this.callEvent(event);
        return event;
    }

    public PlotUnlinkEvent callUnlink(PlotArea area, Plot plot, boolean createRoad, boolean createSign, PlotUnlinkEvent.REASON reason) {
        PlotUnlinkEvent event = new PlotUnlinkEvent(area, plot, createRoad, createSign, reason);
        this.callEvent(event);
        return event;
    }

    public PostPlotUnlinkEvent callPostUnlink(Plot plot, PlotUnlinkEvent.REASON reason) {
        PostPlotUnlinkEvent event = new PostPlotUnlinkEvent(plot, reason);
        this.callEvent(event);
        return event;
    }

    public PlayerEnterPlotEvent callEntry(PlotPlayer<?> player, Plot plot) {
        PlayerEnterPlotEvent event = new PlayerEnterPlotEvent(player, plot);
        this.callEvent(event);
        return event;
    }

    public PlayerLeavePlotEvent callLeave(PlotPlayer<?> player, Plot plot) {
        PlayerLeavePlotEvent event = new PlayerLeavePlotEvent(player, plot);
        this.callEvent(event);
        return event;
    }

    public PlayerPlotDeniedEvent callDenied(PlotPlayer<?> initiator, Plot plot, UUID player, boolean added) {
        PlayerPlotDeniedEvent event = new PlayerPlotDeniedEvent(initiator, plot, player, added);
        this.callEvent(event);
        return event;
    }

    public PlayerPlotTrustedEvent callTrusted(PlotPlayer<?> initiator, Plot plot, UUID player, boolean added) {
        PlayerPlotTrustedEvent event = new PlayerPlotTrustedEvent(initiator, plot, player, added);
        this.callEvent(event);
        return event;
    }

    public PlayerPlotHelperEvent callMember(PlotPlayer<?> initiator, Plot plot, UUID player, boolean added) {
        PlayerPlotHelperEvent event = new PlayerPlotHelperEvent(initiator, plot, player, added);
        this.callEvent(event);
        return event;
    }

    public PlotChangeOwnerEvent callOwnerChange(PlotPlayer<?> initiator, Plot plot, UUID oldOwner, UUID newOwner, boolean hasOldOwner) {
        PlotChangeOwnerEvent event = new PlotChangeOwnerEvent(initiator, plot, oldOwner, newOwner, hasOldOwner);
        this.callEvent(event);
        return event;
    }

    public PostPlotChangeOwnerEvent callPostOwnerChange(PlotPlayer<?> player, Plot plot, @Nullable UUID oldOwner) {
        PostPlotChangeOwnerEvent event = new PostPlotChangeOwnerEvent(player, plot, oldOwner);
        this.callEvent(event);
        return event;
    }

    public PlotRateEvent callRating(PlotPlayer<?> player, Plot plot, Rating rating) {
        PlotRateEvent event = new PlotRateEvent(player, rating, plot);
        this.eventBus.post((Object)event);
        return event;
    }

    public PlotDoneEvent callDone(Plot plot) {
        PlotDoneEvent event = new PlotDoneEvent(plot);
        this.callEvent(event);
        return event;
    }

    public void doJoinTask(PlotPlayer<?> player) {
        if (player == null) {
            return;
        }
        if (ExpireManager.IMP != null) {
            ExpireManager.IMP.handleJoin(player);
        }
        if (this.worldEdit != null && player.getAttribute("worldedit")) {
            player.sendMessage(TranslatableCaption.of("worldedit.worldedit_bypassed"), new Template[0]);
        }
        Plot plot = player.getCurrentPlot();
        if (Settings.Teleport.ON_LOGIN && plot != null && !(plot.getArea() instanceof SinglePlotArea)) {
            TaskManager.runTask(() -> plot.teleportPlayer(player, TeleportCause.LOGIN, result -> {}));
            player.sendMessage(TranslatableCaption.of("teleport.teleported_to_road"), new Template[0]);
        }
    }

    public void doRespawnTask(PlotPlayer<?> player) {
        Plot plot = player.getCurrentPlot();
        if (Settings.Teleport.ON_DEATH && plot != null) {
            TaskManager.runTask(() -> plot.teleportPlayer(player, TeleportCause.DEATH, result -> {}));
            player.sendMessage(TranslatableCaption.of("teleport.teleported_to_road"), new Template[0]);
        }
    }

    public boolean checkPlayerBlockEvent(PlotPlayer<?> player, @NonNull PlayerBlockEventType type, Location location, BlockType blockType, boolean notifyPerms) {
        PlotArea area = location.getPlotArea();
        assert (area != null);
        Plot plot = area.getPlot(location);
        if (plot != null && plot.isAdded(player.getUUID())) {
            return true;
        }
        switch (type) {
            case TELEPORT_OBJECT: {
                return false;
            }
            case READ: {
                return true;
            }
            case INTERACT_BLOCK: {
                if (plot == null) {
                    List use = (List)area.getRoadFlag(UseFlag.class);
                    for (BlockTypeWrapper blockTypeWrapper : use) {
                        if (!blockTypeWrapper.accepts(BlockTypes.AIR) && !blockTypeWrapper.accepts(blockType)) continue;
                        return true;
                    }
                    return Permissions.hasPermission(player, Permission.PERMISSION_ADMIN_INTERACT_ROAD.toString(), notifyPerms);
                }
                if (!plot.hasOwner()) {
                    return Permissions.hasPermission(player, Permission.PERMISSION_ADMIN_INTERACT_UNOWNED.toString(), notifyPerms);
                }
                List use = (List)plot.getFlag(UseFlag.class);
                for (BlockTypeWrapper blockTypeWrapper : use) {
                    if (!blockTypeWrapper.accepts(BlockTypes.AIR) && !blockTypeWrapper.accepts(blockType)) continue;
                    return true;
                }
                if (Permissions.hasPermission(player, Permission.PERMISSION_ADMIN_INTERACT_OTHER.toString(), false)) {
                    return true;
                }
                if (notifyPerms) {
                    player.sendMessage(TranslatableCaption.of("commandconfig.flag_tutorial_usage"), Template.of((String)"flag", (String)PlaceFlag.getFlagName(UseFlag.class)));
                }
                return false;
            }
            case TRIGGER_PHYSICAL: {
                if (plot == null) {
                    List use = (List)area.getRoadFlag(UseFlag.class);
                    for (BlockTypeWrapper blockTypeWrapper : use) {
                        if (!blockTypeWrapper.accepts(BlockTypes.AIR) && !blockTypeWrapper.accepts(blockType)) continue;
                        return true;
                    }
                    return Permissions.hasPermission(player, Permission.PERMISSION_ADMIN_INTERACT_ROAD.toString(), false);
                }
                if (!plot.hasOwner()) {
                    return Permissions.hasPermission(player, Permission.PERMISSION_ADMIN_INTERACT_UNOWNED.toString(), false);
                }
                if (((Boolean)plot.getFlag(DeviceInteractFlag.class)).booleanValue()) {
                    return true;
                }
                List use = (List)plot.getFlag(UseFlag.class);
                for (BlockTypeWrapper blockTypeWrapper : use) {
                    if (!blockTypeWrapper.accepts(BlockTypes.AIR) && !blockTypeWrapper.accepts(blockType)) continue;
                    return true;
                }
                return Permissions.hasPermission(player, Permission.PERMISSION_ADMIN_INTERACT_OTHER.toString(), false);
            }
            case SPAWN_MOB: {
                if (plot == null) {
                    return Permissions.hasPermission(player, Permission.PERMISSION_ADMIN_INTERACT_ROAD.toString(), notifyPerms);
                }
                if (!plot.hasOwner()) {
                    return Permissions.hasPermission(player, Permission.PERMISSION_ADMIN_INTERACT_UNOWNED.toString(), notifyPerms);
                }
                if (((Boolean)plot.getFlag(MobPlaceFlag.class)).booleanValue()) {
                    return true;
                }
                List place = (List)plot.getFlag(PlaceFlag.class);
                for (BlockTypeWrapper blockTypeWrapper : place) {
                    if (!blockTypeWrapper.accepts(BlockTypes.AIR) && !blockTypeWrapper.accepts(blockType)) continue;
                    return true;
                }
                if (Permissions.hasPermission(player, Permission.PERMISSION_ADMIN_INTERACT_OTHER.toString(), false)) {
                    return true;
                }
                if (notifyPerms) {
                    player.sendMessage(TranslatableCaption.of("commandconfig.flag_tutorial_usage"), Template.of((String)"flag", (String)(PlotFlag.getFlagName(MobPlaceFlag.class) + "/" + PlotFlag.getFlagName(PlaceFlag.class))));
                }
                return false;
            }
            case PLACE_MISC: {
                if (plot == null) {
                    return Permissions.hasPermission(player, Permission.PERMISSION_ADMIN_INTERACT_ROAD.toString(), notifyPerms);
                }
                if (!plot.hasOwner()) {
                    return Permissions.hasPermission(player, Permission.PERMISSION_ADMIN_INTERACT_UNOWNED.toString(), notifyPerms);
                }
                if (((Boolean)plot.getFlag(MiscPlaceFlag.class)).booleanValue()) {
                    return true;
                }
                List place = (List)plot.getFlag(PlaceFlag.class);
                for (BlockTypeWrapper blockTypeWrapper : place) {
                    if (!blockTypeWrapper.accepts(BlockTypes.AIR) && !blockTypeWrapper.accepts(blockType)) continue;
                    return true;
                }
                if (Permissions.hasPermission(player, Permission.PERMISSION_ADMIN_INTERACT_OTHER.toString(), false)) {
                    return true;
                }
                if (notifyPerms) {
                    player.sendMessage(TranslatableCaption.of("commandconfig.flag_tutorial_usage"), Template.of((String)"flag", (String)(PlotFlag.getFlagName(MiscPlaceFlag.class) + "/" + PlotFlag.getFlagName(PlaceFlag.class))));
                }
                return false;
            }
            case PLACE_VEHICLE: {
                if (plot == null) {
                    return Permissions.hasPermission(player, Permission.PERMISSION_ADMIN_INTERACT_ROAD.toString(), notifyPerms);
                }
                if (!plot.hasOwner()) {
                    return Permissions.hasPermission(player, Permission.PERMISSION_ADMIN_INTERACT_UNOWNED.toString(), notifyPerms);
                }
                return (Boolean)plot.getFlag(VehiclePlaceFlag.class);
            }
        }
        return true;
    }
}

