/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util;

import java.io.File;
import java.nio.file.Paths;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class FileUtils {
    private FileUtils() {
    }

    public static void deleteDirectory(@NonNull File directory) {
        File[] files;
        if (directory.exists() && null != (files = directory.listFiles())) {
            for (File file : files) {
                if (!file.isDirectory()) continue;
                FileUtils.deleteDirectory(file);
            }
        }
        if (!directory.delete()) {
            throw new RuntimeException(String.format("Failed to delete directory %s", directory.getName()));
        }
    }

    public static @NonNull File getFile(@NonNull File base, @NonNull String path) {
        if (Paths.get(path, new String[0]).isAbsolute()) {
            return new File(path);
        }
        return new File(base, path);
    }
}

