/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util;

public class MathMan {
    private static final int ATAN2_BITS = 7;
    private static final int ATAN2_BITS2 = 14;
    private static final int ATAN2_MASK = 16383;
    private static final int ATAN2_COUNT = 16384;
    private static final int ATAN2_DIM = (int)Math.sqrt(16384.0);
    private static final float INV_ATAN2_DIM_MINUS_1 = 1.0f / (float)(ATAN2_DIM - 1);
    private static final float[] atan2 = new float[16384];
    private static final int[] table = new int[]{0, 16, 22, 27, 32, 35, 39, 42, 45, 48, 50, 53, 55, 57, 59, 61, 64, 65, 67, 69, 71, 73, 75, 76, 78, 80, 81, 83, 84, 86, 87, 89, 90, 91, 93, 94, 96, 97, 98, 99, 101, 102, 103, 104, 106, 107, 108, 109, 110, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 128, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 144, 145, 146, 147, 148, 149, 150, 150, 151, 152, 153, 154, 155, 155, 156, 157, 158, 159, 160, 160, 161, 162, 163, 163, 164, 165, 166, 167, 167, 168, 169, 170, 170, 171, 172, 173, 173, 174, 175, 176, 176, 177, 178, 178, 179, 180, 181, 181, 182, 183, 183, 184, 185, 185, 186, 187, 187, 188, 189, 189, 190, 191, 192, 192, 193, 193, 194, 195, 195, 196, 197, 197, 198, 199, 199, 200, 201, 201, 202, 203, 203, 204, 204, 205, 206, 206, 207, 208, 208, 209, 209, 210, 211, 211, 212, 212, 213, 214, 214, 215, 215, 216, 217, 217, 218, 218, 219, 219, 220, 221, 221, 222, 222, 223, 224, 224, 225, 225, 226, 226, 227, 227, 228, 229, 229, 230, 230, 231, 231, 232, 232, 233, 234, 234, 235, 235, 236, 236, 237, 237, 238, 238, 239, 240, 240, 241, 241, 242, 242, 243, 243, 244, 244, 245, 245, 246, 246, 247, 247, 248, 248, 249, 249, 250, 250, 251, 251, 252, 252, 253, 253, 254, 254, 255};

    public static final int gcd(int a, int b) {
        if (b == 0) {
            return a;
        }
        return MathMan.gcd(b, a % b);
    }

    public static final int gcd(int[] a) {
        int result = a[0];
        for (int i = 1; i < a.length; ++i) {
            result = MathMan.gcd(result, a[i]);
        }
        return result;
    }

    public static long pairInt(int x, int y) {
        return (long)x << 32 | (long)y & 0xFFFFFFFFL;
    }

    public static int unpairIntX(long pair) {
        return (int)(pair >> 32);
    }

    public static int unpairIntY(long pair) {
        return (int)pair;
    }

    public static byte pair16(byte x, byte y) {
        return (byte)(x + (y << 4));
    }

    public static byte unpair16x(byte value) {
        return (byte)(value & 0xF);
    }

    public static byte unpair16y(byte value) {
        return (byte)(value >> 4 & 0xF);
    }

    public static long inverseRound(double val) {
        long round = Math.round(val);
        return (long)((double)round + Math.signum(val - (double)round));
    }

    public static int sqrt(int x) {
        if (x >= 65536) {
            if (x >= 0x1000000) {
                int xn = x >= 0x10000000 ? (x >= 0x40000000 ? table[x >> 24] << 8 : table[x >> 22] << 7) : (x >= 0x4000000 ? table[x >> 20] << 6 : table[x >> 18] << 5);
                xn = xn + 1 + x / xn >> 1;
                xn = xn + 1 + x / xn >> 1;
                return xn * xn > x ? --xn : xn;
            }
            int xn = x >= 0x100000 ? (x >= 0x400000 ? table[x >> 16] << 4 : table[x >> 14] << 3) : (x >= 262144 ? table[x >> 12] << 2 : table[x >> 10] << 1);
            xn = xn + 1 + x / xn >> 1;
            return xn * xn > x ? --xn : xn;
        }
        if (x >= 256) {
            int xn = x >= 4096 ? (x >= 16384 ? table[x >> 8] + 1 : (table[x >> 6] >> 1) + 1) : (x >= 1024 ? (table[x >> 4] >> 2) + 1 : (table[x >> 2] >> 3) + 1);
            return xn * xn > x ? --xn : xn;
        }
        if (x >= 0) {
            return table[x] >> 4;
        }
        throw new IllegalArgumentException("Invalid number:" + x);
    }

    public static double getMean(int[] array) {
        double count = 0.0;
        for (int i : array) {
            count += (double)i;
        }
        return count / (double)array.length;
    }

    public static double getMean(double[] array) {
        double count = 0.0;
        for (double i : array) {
            count += i;
        }
        return count / (double)array.length;
    }

    public static int pair(short x, short y) {
        return x << 16 | y & 0xFFFF;
    }

    public static final int average(int a, int b) {
        return (a & b) + (a ^ b) / 2;
    }

    public static short unpairX(int hash) {
        return (short)(hash >> 16);
    }

    public static short unpairY(int hash) {
        return (short)(hash & 0xFFFF);
    }

    public static float[] getDirection(float yaw, float pitch) {
        double pitch_sin = Math.sin(pitch);
        return new float[]{(float)(pitch_sin * Math.cos(yaw)), (float)(pitch_sin * Math.sin(yaw)), (float)Math.cos(pitch)};
    }

    public static int floorMod(int x, int y) {
        int i = x % y;
        if (i < 0) {
            i += y;
        }
        return i;
    }

    public static int roundInt(double value) {
        return (int)(value < 0.0 ? (value == (double)((int)value) ? value : value - 1.0) : value);
    }

    public static float[] getPitchAndYaw(float x, float y, float z) {
        float distance = MathMan.sqrtApprox(z * z + x * x);
        return new float[]{MathMan.atan2(y, distance), MathMan.atan2(x, z)};
    }

    public static final float atan2(float y, float x) {
        float add;
        float mul;
        if (x < 0.0f) {
            if (y < 0.0f) {
                x = -x;
                y = -y;
                mul = 1.0f;
            } else {
                x = -x;
                mul = -1.0f;
            }
            add = (float)(-Math.PI);
        } else {
            if (y < 0.0f) {
                y = -y;
                mul = -1.0f;
            } else {
                mul = 1.0f;
            }
            add = 0.0f;
        }
        float invDiv = 1.0f / ((x < y ? y : x) * INV_ATAN2_DIM_MINUS_1);
        int xi = (int)(x * invDiv);
        int yi = (int)(y * invDiv);
        return (atan2[yi * ATAN2_DIM + xi] + add) * mul;
    }

    public static float sqrtApprox(float f) {
        return f * Float.intBitsToFloat(1597463174 - (Float.floatToIntBits(f) >> 1));
    }

    public static double sqrtApprox(double d) {
        return Double.longBitsToDouble((Double.doubleToLongBits(d) - 0x10000000000000L >> 1) + 0x2000000000000000L);
    }

    public static float invSqrt(float x) {
        float xhalf = 0.5f * x;
        int i = Float.floatToIntBits(x);
        i = 1597463007 - (i >> 1);
        x = Float.intBitsToFloat(i);
        x *= 1.5f - xhalf * x * x;
        return x;
    }

    public static int getPositiveId(int i) {
        if (i < 0) {
            return -i * 2 - 1;
        }
        return i * 2;
    }

    public static boolean isInteger(String str) {
        if (str == null) {
            return false;
        }
        int length = str.length();
        if (length == 0) {
            return false;
        }
        int i = 0;
        if (str.charAt(0) == '-') {
            if (length == 1) {
                return false;
            }
            i = 1;
        }
        while (i < length) {
            char c = str.charAt(i);
            if (c <= '/' || c >= ':') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static double getSD(double[] array, double av) {
        double sd = 0.0;
        for (double element : array) {
            sd += Math.pow(Math.abs(element - av), 2.0);
        }
        return Math.sqrt(sd / (double)array.length);
    }

    public static double getSD(int[] array, double av) {
        double sd = 0.0;
        for (int element : array) {
            sd += Math.pow(Math.abs((double)element - av), 2.0);
        }
        return Math.sqrt(sd / (double)array.length);
    }

    public static int mod(int x, int y) {
        if (MathMan.isPowerOfTwo(y)) {
            return x & y - 1;
        }
        return x % y;
    }

    public static int unsignedmod(int x, int y) {
        if (MathMan.isPowerOfTwo(y)) {
            return x & y - 1;
        }
        return x % y;
    }

    public static boolean isPowerOfTwo(int number) {
        return (number & number - 1) == 0;
    }

    static {
        for (int i = 0; i < ATAN2_DIM; ++i) {
            for (int j = 0; j < ATAN2_DIM; ++j) {
                float x0 = (float)i / (float)ATAN2_DIM;
                float y0 = (float)j / (float)ATAN2_DIM;
                MathMan.atan2[j * MathMan.ATAN2_DIM + i] = (float)Math.atan2(y0, x0);
            }
        }
    }
}

