/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util.helpmenu;

import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.configuration.caption.StaticCaption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.util.StringMan;
import com.plotsquared.core.util.helpmenu.HelpObject;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.Template;

public class HelpPage {
    private static final MiniMessage MINI_MESSAGE = MiniMessage.builder().build();
    private final List<HelpObject> helpObjects = new ArrayList<HelpObject>();
    private final Template catTemplate;
    private final Template curTemplate;
    private final Template maxTemplate;

    public HelpPage(CommandCategory category, int currentPage, int maxPages) {
        this.catTemplate = Template.of((String)"category", (String)(category == null ? "ALL" : category.name()));
        this.curTemplate = Template.of((String)"current", (String)String.valueOf(currentPage + 1));
        this.maxTemplate = Template.of((String)"max", (String)String.valueOf(maxPages + 1));
    }

    public void render(PlotPlayer<?> player) {
        if (this.helpObjects.size() < 1) {
            player.sendMessage(TranslatableCaption.of("help.no_permission"), new Template[0]);
        } else {
            Template header = Template.of((String)"header", (String)TranslatableCaption.of("help.help_header").getComponent(player));
            Template page_header = Template.of((String)"page_header", (Component)MINI_MESSAGE.parse(TranslatableCaption.of("help.help_page_header").getComponent(player), new Template[]{this.catTemplate, this.curTemplate, this.maxTemplate}));
            Template help_objects = Template.of((String)"help_objects", (String)StringMan.join(this.helpObjects, "\n"));
            Template footer = Template.of((String)"footer", (String)TranslatableCaption.of("help.help_footer").getComponent(player));
            player.sendMessage(StaticCaption.of("<header>\n<page_header>\n<help_objects>\n<footer>"), header, page_header, help_objects, footer);
        }
    }

    public void addHelpItem(HelpObject object) {
        this.helpObjects.add(object);
    }
}

