/*
 * Decompiled with CFR 0.152.
 */
package com.pnuema.java.barcode;

import com.pnuema.java.barcode.Barcode;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

class Labels {
    Labels() {
    }

    public static Image Label_ITF14(Barcode Barcode2, BufferedImage img) {
        try {
            Font font = Barcode2.getLabelFont();
            Graphics2D g = img.createGraphics();
            g.drawImage((Image)img, 0, 0, null);
            RenderingHints rh = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.setRenderingHints(rh);
            g.setColor(Barcode2.getBackColor());
            Rectangle rect = new Rectangle(0, img.getHeight() - (font.getSize() - 2), img.getWidth(), font.getSize());
            g.drawRect((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
            g.setColor(Barcode2.getForeColor());
            String text = Barcode2.getAlternateLabel() == null ? Barcode2.getRawData() : Barcode2.getAlternateLabel();
            Labels.drawCenteredString(g, text, rect, font);
            float lineThickness = (float)img.getHeight() / 16.0f;
            g.drawRect(0, img.getHeight() - font.getSize() - 2 - (int)lineThickness / 2, img.getWidth(), img.getHeight() - font.getSize() - 2 + (int)lineThickness / 2);
            g.dispose();
            return img;
        }
        catch (Exception ex) {
            throw new RuntimeException("ELABEL_ITF14-1: " + ex.getMessage());
        }
    }

    static Image labelGeneric(Barcode Barcode2, BufferedImage img) {
        try {
            Font font = Barcode2.getLabelFont();
            Graphics2D g = img.createGraphics();
            g.drawImage((Image)img, 0, 0, null);
            RenderingHints rh = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.setRenderingHints(rh);
            int LabelY = 0;
            switch (Barcode2.getLabelPosition()) {
                case BOTTOM: {
                    LabelY = img.getHeight() - font.getSize();
                }
            }
            g.setColor(Barcode2.getBackColor());
            g.drawRect(0, LabelY, img.getWidth(), font.getSize());
            g.setColor(Barcode2.getForeColor());
            Rectangle rect = new Rectangle(0, LabelY, img.getWidth(), font.getSize());
            Labels.drawCenteredString(g, Barcode2.getAlternateLabel() == null ? Barcode2.getRawData() : Barcode2.getAlternateLabel(), rect, font);
            g.dispose();
            return img;
        }
        catch (Exception ex) {
            throw new RuntimeException("ELABEL_GENERIC-1: " + ex.getMessage());
        }
    }

    static Image Label_EAN13(Barcode Barcode2, BufferedImage img) {
        try {
            int iBarWidth = Barcode2.getWidth() / Barcode2.getEncodedValue().length();
            String defTxt = Barcode2.getRawData();
            int fontSize = Labels.getFontsize(Barcode2.getWidth() - Barcode2.getWidth() % Barcode2.getEncodedValue().length(), img.getHeight(), defTxt);
            Font labFont = new Font("Serif", 0, fontSize);
            Font smallFont = new Font(labFont.getFamily(), labFont.getStyle(), (int)((float)fontSize * 0.5f));
            int shiftAdjustment = Labels.getShiftAdjustment(Barcode2);
            Graphics2D g = img.createGraphics();
            g.drawImage((Image)img, 0, 0, null);
            RenderingHints rh = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.setRenderingHints(rh);
            int LabelY = img.getHeight() - labFont.getSize();
            float w1 = iBarWidth * 4;
            float w2 = iBarWidth * 42;
            float w3 = iBarWidth * 42;
            float s1 = shiftAdjustment - iBarWidth;
            float s2 = s1 + (float)(iBarWidth * 4);
            float s3 = s2 + w2 + (float)(iBarWidth * 5);
            g.setColor(Barcode2.getBackColor());
            g.drawRect((int)s2, LabelY, (int)w2, labFont.getSize());
            g.drawRect((int)s3, LabelY, (int)w3, labFont.getSize());
            g.setColor(Barcode2.getForeColor());
            g.drawString(defTxt.substring(0, 1), s1, (float)img.getHeight() - (float)((double)smallFont.getSize() * 0.9));
            g.drawString(defTxt.substring(1, 6), s2, (float)LabelY);
            g.drawString(defTxt.substring(7), s3 - (float)iBarWidth, (float)LabelY);
            g.dispose();
            return img;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("ELABEL_EAN13-1: " + ex.getMessage());
        }
    }

    public static Image Label_UPCA(Barcode Barcode2, BufferedImage img) {
        try {
            int iBarWidth = Barcode2.getWidth() / Barcode2.getEncodedValue().length();
            int halfBarWidth = (int)((double)iBarWidth * 0.5);
            String defTxt = Barcode2.getRawData();
            int fontSize = Labels.getFontsize((int)((float)(Barcode2.getWidth() - Barcode2.getWidth() % Barcode2.getEncodedValue().length()) * 0.9f), img.getHeight(), defTxt);
            Font labFont = new Font("Serif", 0, fontSize);
            Font smallFont = new Font(labFont.getFamily(), labFont.getStyle(), (int)((float)fontSize * 0.5f));
            int shiftAdjustment = Labels.getShiftAdjustment(Barcode2);
            Graphics2D g = img.createGraphics();
            g.drawImage((Image)img, 0, 0, null);
            RenderingHints rh = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.setRenderingHints(rh);
            int LabelY = img.getHeight() - labFont.getSize();
            float w1 = iBarWidth * 4;
            float w2 = iBarWidth * 34;
            float w3 = iBarWidth * 34;
            float s1 = shiftAdjustment - iBarWidth;
            float s2 = s1 + (float)(iBarWidth * 12);
            float s3 = s2 + w2 + (float)(iBarWidth * 5);
            float s4 = s3 + w3 + (float)(iBarWidth * 8) - (float)halfBarWidth;
            g.setColor(Barcode2.getBackColor());
            g.drawRect((int)s2, LabelY, (int)w2, labFont.getSize());
            g.drawRect((int)s3, LabelY, (int)w3, labFont.getSize());
            g.setColor(Barcode2.getForeColor());
            g.drawString(defTxt.substring(0, 1), s1, (float)img.getHeight() - (float)smallFont.getSize());
            g.drawString(defTxt.substring(1, 5), s2 - (float)iBarWidth, (float)LabelY);
            g.drawString(defTxt.substring(6, 11), s3 - (float)iBarWidth, (float)LabelY);
            g.drawString(defTxt.substring(11), s4, (float)(img.getHeight() - smallFont.getSize()));
            g.dispose();
            return img;
        }
        catch (Exception ex) {
            throw new RuntimeException("ELABEL_UPCA-1: " + ex.getMessage());
        }
    }

    public static int getFontsize(int wid, int hgt, String lbl) {
        int fontSize = 10;
        if (lbl.length() > 0) {
            BufferedImage fakeImage = new BufferedImage(1, 1, 2);
            Graphics2D g = fakeImage.createGraphics();
            for (int i = 1; i <= 100; ++i) {
                int text_size = g.getFontMetrics().stringWidth(lbl);
                if (text_size <= wid && text_size <= hgt) continue;
                fontSize = i - 1;
                break;
            }
            g.dispose();
        }
        return fontSize;
    }

    public static void drawCenteredString(Graphics g, String text, Rectangle rect, Font font) {
        FontMetrics metrics = g.getFontMetrics(font);
        int x = rect.x + (rect.width - metrics.stringWidth(text)) / 2;
        int y = rect.y + (rect.height - metrics.getHeight()) / 2 + metrics.getAscent();
        g.setFont(font);
        g.drawString(text, x, y);
    }

    private static int getShiftAdjustment(Barcode barcode) {
        switch (barcode.getAlignmentPosition()) {
            case LEFT: {
                return 0;
            }
            case RIGHT: {
                return barcode.getWidth() % barcode.getEncodedValue().length();
            }
        }
        return barcode.getWidth() % barcode.getEncodedValue().length() / 2;
    }

    public static enum LabelPositions {
        TOP,
        BOTTOM;

    }
}

