/*
 * Decompiled with CFR 0.152.
 */
package com.pnuema.java.barcode.symbologies;

import com.pnuema.java.barcode.BarcodeCommon;
import com.pnuema.java.barcode.IBarcode;

public class Code11
extends BarcodeCommon
implements IBarcode {
    private final String[] C11_Code = new String[]{"101011", "1101011", "1001011", "1100101", "1011011", "1101101", "1001101", "1010011", "1101001", "110101", "101101", "1011001"};

    public Code11(String input) {
        this.setRawData(input);
    }

    private String encodeCode11() {
        if (!Code11.checkNumericOnly(this.getRawData().replace("-", ""))) {
            this.error("EC11-1: Numeric data and '-' Only");
        }
        int weight = 1;
        int CTotal = 0;
        String dataToEncodeWithChecksums = this.getRawData();
        for (int i = this.getRawData().length() - 1; i >= 0; --i) {
            if (weight == 10) {
                weight = 1;
            }
            if (this.getRawData().charAt(i) != '-') {
                CTotal += Integer.parseInt(String.valueOf(this.getRawData().charAt(i))) * weight++;
                continue;
            }
            CTotal += 10 * weight++;
        }
        int checksumC = CTotal % 11;
        dataToEncodeWithChecksums = dataToEncodeWithChecksums + String.valueOf(checksumC);
        if (this.getRawData().length() >= 10) {
            weight = 1;
            int KTotal = 0;
            for (int i = dataToEncodeWithChecksums.length() - 1; i >= 0; --i) {
                if (weight == 9) {
                    weight = 1;
                }
                if (dataToEncodeWithChecksums.charAt(i) != '-') {
                    KTotal += Integer.parseInt(String.valueOf(dataToEncodeWithChecksums.charAt(i))) * weight++;
                    continue;
                }
                KTotal += 10 * weight++;
            }
            int checksumK = KTotal % 9;
            dataToEncodeWithChecksums = dataToEncodeWithChecksums + checksumK;
        }
        String space = "0";
        StringBuilder builder = new StringBuilder();
        builder.append(this.C11_Code[11]);
        builder.append(space);
        for (char c : dataToEncodeWithChecksums.toCharArray()) {
            int index = c == '-' ? 10 : Integer.parseInt(String.valueOf(c));
            builder.append(this.C11_Code[index]);
            builder.append(space);
        }
        builder.append(this.C11_Code[11]);
        return builder.toString();
    }

    @Override
    public String getEncodedValue() {
        return this.encodeCode11();
    }
}

