/*
 * Decompiled with CFR 0.152.
 */
package com.pnuema.java.barcode.symbologies;

import com.pnuema.java.barcode.BarcodeCommon;
import com.pnuema.java.barcode.IBarcode;

public class ITF14
extends BarcodeCommon
implements IBarcode {
    private final String[] ITF14_Code = new String[]{"NNWWN", "WNNNW", "NWNNW", "WWNNN", "NNWNW", "WNWNN", "NWWNN", "NNNWW", "WNNWN", "NWNWN"};

    public ITF14(String input) {
        this.setRawData(input);
        this.checkDigit();
    }

    private String encodeITF14() {
        if (this.getRawData().length() > 14 || this.getRawData().length() < 13) {
            this.error("EITF14-1: Data length invalid. (Length must be 13 or 14)");
        }
        if (!ITF14.checkNumericOnly(this.getRawData())) {
            this.error("EITF14-2: Numeric Data Only");
        }
        StringBuilder result = new StringBuilder("1010");
        for (int i = 0; i < this.getRawData().length(); i += 2) {
            boolean bars = true;
            String patternbars = this.ITF14_Code[Integer.parseInt(String.valueOf(this.getRawData().toCharArray()[i]))];
            String patternspaces = this.ITF14_Code[Integer.parseInt(String.valueOf(this.getRawData().toCharArray()[i + 1]))];
            StringBuilder patternmixed = new StringBuilder();
            while (patternbars.length() > 0) {
                patternmixed.append(String.valueOf(patternbars.toCharArray()[0])).append(String.valueOf(patternspaces.toCharArray()[0]));
                patternbars = patternbars.substring(1);
                patternspaces = patternspaces.substring(1);
            }
            for (char c1 : patternmixed.toString().toCharArray()) {
                if (bars) {
                    if (c1 == 'N') {
                        result.append("1");
                    } else {
                        result.append("11");
                    }
                } else if (c1 == 'N') {
                    result.append("0");
                } else {
                    result.append("00");
                }
                bars = !bars;
            }
        }
        result.append("1101");
        return result.toString();
    }

    private void checkDigit() {
        if (this.getRawData().length() == 13) {
            int total = 0;
            for (int i = 0; i <= this.getRawData().length() - 1; ++i) {
                int temp = Integer.parseInt(this.getRawData().substring(i, i + 1));
                total += temp * (i == 0 || i % 2 == 0 ? 3 : 1);
            }
            int cs = total % 10;
            if ((cs = 10 - cs) == 10) {
                cs = 0;
            }
            this.setRawData(this.getRawData() + cs);
        }
    }

    @Override
    public String getEncodedValue() {
        return this.encodeITF14();
    }
}

