/*
 * Decompiled with CFR 0.152.
 */
package com.pnuema.java.barcode.symbologies;

import com.pnuema.java.barcode.Barcode;
import com.pnuema.java.barcode.BarcodeCommon;
import com.pnuema.java.barcode.IBarcode;

public class MSI
extends BarcodeCommon
implements IBarcode {
    private final String[] MSI_Code = new String[]{"100100100100", "100100100110", "100100110100", "100100110110", "100110100100", "100110100110", "100110110100", "100110110110", "110100100100", "110100100110"};
    private final Barcode.TYPE encodedType;

    public MSI(String input, Barcode.TYPE EncodedType) {
        this.encodedType = EncodedType;
        this.setRawData(input);
    }

    private String encodeMSI() {
        Character c;
        int n;
        int n2;
        int oddsum;
        int evensum;
        int i;
        String evens;
        if (!MSI.checkNumericOnly(this.getRawData())) {
            this.error("EMSI-1: Numeric Data Only");
        }
        String PreEncoded = this.getRawData();
        if (this.encodedType == Barcode.TYPE.MSI_Mod10 || this.encodedType == Barcode.TYPE.MSI_2Mod10) {
            String odds = "";
            evens = "";
            for (i = PreEncoded.length() - 1; i >= 0; i -= 2) {
                odds = String.valueOf(PreEncoded.toCharArray()[i]) + odds;
                if (i - 1 < 0) continue;
                evens = String.valueOf(PreEncoded.toCharArray()[i - 1]) + evens;
            }
            odds = String.valueOf(Integer.parseInt(odds) * 2);
            evensum = 0;
            oddsum = 0;
            char[] cArray = evens.toCharArray();
            n2 = cArray.length;
            for (n = 0; n < n2; ++n) {
                c = Character.valueOf(cArray[n]);
                evensum += Integer.parseInt(c.toString());
            }
            cArray = odds.toCharArray();
            n2 = cArray.length;
            for (n = 0; n < n2; ++n) {
                c = Character.valueOf(cArray[n]);
                oddsum += Integer.parseInt(c.toString());
            }
            int mod = (oddsum + evensum) % 10;
            int checksum = mod == 0 ? 0 : 10 - mod;
            PreEncoded = PreEncoded + String.valueOf(checksum);
        }
        if (this.encodedType == Barcode.TYPE.MSI_Mod11 || this.encodedType == Barcode.TYPE.MSI_Mod11_Mod10) {
            int sum = 0;
            int weight = 2;
            for (i = PreEncoded.length() - 1; i >= 0; --i) {
                if (weight > 7) {
                    weight = 2;
                }
                sum += Integer.parseInt(String.valueOf(PreEncoded.toCharArray()[i])) * weight++;
            }
            int mod = sum % 11;
            int checksum = mod == 0 ? 0 : 11 - mod;
            PreEncoded = PreEncoded + String.valueOf(checksum);
        }
        if (this.encodedType == Barcode.TYPE.MSI_2Mod10 || this.encodedType == Barcode.TYPE.MSI_Mod11_Mod10) {
            String odds = "";
            evens = "";
            for (i = PreEncoded.length() - 1; i >= 0; i -= 2) {
                odds = String.valueOf(PreEncoded.toCharArray()[i]) + odds;
                if (i - 1 < 0) continue;
                evens = String.valueOf(PreEncoded.toCharArray()[i - 1]) + evens;
            }
            odds = String.valueOf(Integer.parseInt(odds) * 2);
            evensum = 0;
            oddsum = 0;
            char[] mod = evens.toCharArray();
            n2 = mod.length;
            for (n = 0; n < n2; ++n) {
                c = Character.valueOf(mod[n]);
                evensum += Integer.parseInt(c.toString());
            }
            mod = odds.toCharArray();
            n2 = mod.length;
            for (n = 0; n < n2; ++n) {
                c = Character.valueOf(mod[n]);
                oddsum += Integer.parseInt(c.toString());
            }
            int checksum = 10 - (oddsum + evensum) % 10;
            PreEncoded = PreEncoded + String.valueOf(checksum);
        }
        String result = "110";
        char[] cArray = PreEncoded.toCharArray();
        int n3 = cArray.length;
        for (int j = 0; j < n3; ++j) {
            Character c2 = Character.valueOf(cArray[j]);
            result = result + this.MSI_Code[Integer.parseInt(c2.toString())];
        }
        result = result + "1001";
        return result;
    }

    @Override
    public String getEncodedValue() {
        return this.encodeMSI();
    }
}

