/*
 * Decompiled with CFR 0.152.
 */
package bleshadow.dagger.internal;

import bleshadow.dagger.internal.GwtIncompatible;
import bleshadow.dagger.internal.Preconditions;
import bleshadow.dagger.internal.ReferenceReleasingProviderManager;
import bleshadow.javax.inject.Provider;
import java.lang.ref.WeakReference;

@GwtIncompatible
public final class ReferenceReleasingProvider<T>
implements Provider<T> {
    private static final Object NULL = new Object();
    private final Provider<T> provider;
    private volatile Object strongReference;
    private volatile WeakReference<T> weakReference;

    private ReferenceReleasingProvider(Provider<T> provider) {
        assert (provider != null);
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseStrongReference() {
        Object value = this.strongReference;
        if (value != null && value != NULL) {
            ReferenceReleasingProvider referenceReleasingProvider = this;
            synchronized (referenceReleasingProvider) {
                Object storedValue = value;
                this.weakReference = new WeakReference<Object>(storedValue);
                this.strongReference = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreStrongReference() {
        Object value = this.strongReference;
        if (this.weakReference != null && value == null) {
            ReferenceReleasingProvider referenceReleasingProvider = this;
            synchronized (referenceReleasingProvider) {
                value = this.strongReference;
                if (this.weakReference != null && value == null && (value = this.weakReference.get()) != null) {
                    this.strongReference = value;
                    this.weakReference = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        Object value = this.currentValue();
        if (value == null) {
            ReferenceReleasingProvider referenceReleasingProvider = this;
            synchronized (referenceReleasingProvider) {
                value = this.currentValue();
                if (value == null) {
                    value = this.provider.get();
                    if (value == null) {
                        value = NULL;
                    }
                    this.strongReference = value;
                }
            }
        }
        return (T)(value == NULL ? null : value);
    }

    private Object currentValue() {
        Object value = this.strongReference;
        if (value != null) {
            return value;
        }
        if (this.weakReference != null) {
            return this.weakReference.get();
        }
        return null;
    }

    public static <T> ReferenceReleasingProvider<T> create(Provider<T> delegate, ReferenceReleasingProviderManager references) {
        ReferenceReleasingProvider<T> provider = new ReferenceReleasingProvider<T>(Preconditions.checkNotNull(delegate));
        references.addProvider(provider);
        return provider;
    }
}

