/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.mockrxandroidble;

import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.util.Log;
import androidx.annotation.NonNull;
import com.polidea.rxandroidble2.ConnectionParameters;
import com.polidea.rxandroidble2.NotificationSetupMode;
import com.polidea.rxandroidble2.RxBleConnection;
import com.polidea.rxandroidble2.RxBleCustomOperation;
import com.polidea.rxandroidble2.RxBleDeviceServices;
import com.polidea.rxandroidble2.exceptions.BleConflictingNotificationAlreadySetException;
import com.polidea.rxandroidble2.internal.Priority;
import com.polidea.rxandroidble2.internal.connection.ImmediateSerializedBatchAckStrategy;
import com.polidea.rxandroidble2.internal.util.ObservableUtil;
import io.reactivex.Completable;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.ObservableTransformer;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import io.reactivex.internal.functions.Functions;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class RxBleConnectionMock
implements RxBleConnection {
    private static final byte[] ENABLE_NOTIFICATION_VALUE = new byte[]{1, 0};
    private static final byte[] ENABLE_INDICATION_VALUE = new byte[]{2, 0};
    private static final byte[] DISABLE_NOTIFICATION_VALUE = new byte[]{0, 0};
    private static final UUID CLIENT_CHARACTERISTIC_CONFIG_UUID = UUID.fromString("00002902-0000-1000-8000-00805f9b34fb");
    private HashMap<UUID, Observable<Observable<byte[]>>> notificationObservableMap = new HashMap();
    private HashMap<UUID, Observable<Observable<byte[]>>> indicationObservableMap = new HashMap();
    private RxBleDeviceServices rxBleDeviceServices;
    private int rssi;
    private int currentMtu = 23;
    private Map<UUID, Observable<byte[]>> characteristicNotificationSources;

    public RxBleConnectionMock(RxBleDeviceServices rxBleDeviceServices, int rssi, Map<UUID, Observable<byte[]>> characteristicNotificationSources) {
        this.rxBleDeviceServices = rxBleDeviceServices;
        this.rssi = rssi;
        this.characteristicNotificationSources = characteristicNotificationSources;
    }

    public Completable requestConnectionPriority(int connectionPriority, long delay, @NonNull TimeUnit timeUnit) {
        return Completable.timer((long)delay, (TimeUnit)timeUnit);
    }

    public Single<Integer> requestMtu(final int mtu) {
        return Single.fromCallable((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                RxBleConnectionMock.this.currentMtu = mtu;
                return mtu;
            }
        });
    }

    public int getMtu() {
        return this.currentMtu;
    }

    public Single<RxBleDeviceServices> discoverServices() {
        return Single.just((Object)this.rxBleDeviceServices);
    }

    public Single<RxBleDeviceServices> discoverServices(long timeout, @NonNull TimeUnit timeUnit) {
        return Single.just((Object)this.rxBleDeviceServices);
    }

    public Single<BluetoothGattCharacteristic> getCharacteristic(final @NonNull UUID characteristicUuid) {
        return this.discoverServices().flatMap((Function)new Function<RxBleDeviceServices, SingleSource<? extends BluetoothGattCharacteristic>>(){

            public SingleSource<? extends BluetoothGattCharacteristic> apply(RxBleDeviceServices rxBleDeviceServices) throws Exception {
                return rxBleDeviceServices.getCharacteristic(characteristicUuid);
            }
        });
    }

    public Single<byte[]> readCharacteristic(@NonNull UUID characteristicUuid) {
        return this.getCharacteristic(characteristicUuid).map((Function)new Function<BluetoothGattCharacteristic, byte[]>(){

            public byte[] apply(BluetoothGattCharacteristic bluetoothGattCharacteristic) throws Exception {
                return bluetoothGattCharacteristic.getValue();
            }
        });
    }

    public Single<byte[]> readCharacteristic(@NonNull BluetoothGattCharacteristic characteristic) {
        return Single.just((Object)characteristic.getValue());
    }

    public Single<byte[]> readDescriptor(final @NonNull UUID serviceUuid, final @NonNull UUID characteristicUuid, final @NonNull UUID descriptorUuid) {
        return this.discoverServices().flatMap((Function)new Function<RxBleDeviceServices, SingleSource<BluetoothGattDescriptor>>(){

            public SingleSource<BluetoothGattDescriptor> apply(RxBleDeviceServices rxBleDeviceServices) {
                return rxBleDeviceServices.getDescriptor(serviceUuid, characteristicUuid, descriptorUuid);
            }
        }).map((Function)new Function<BluetoothGattDescriptor, byte[]>(){

            public byte[] apply(BluetoothGattDescriptor bluetoothGattDescriptor) {
                return bluetoothGattDescriptor.getValue();
            }
        });
    }

    public Single<byte[]> readDescriptor(@NonNull BluetoothGattDescriptor descriptor) {
        return Single.just((Object)descriptor.getValue());
    }

    public Single<Integer> readRssi() {
        return Single.just((Object)this.rssi);
    }

    public Observable<Observable<byte[]>> setupNotification(@NonNull UUID characteristicUuid) {
        return this.setupNotification(characteristicUuid, NotificationSetupMode.DEFAULT);
    }

    public Observable<Observable<byte[]>> setupNotification(@NonNull BluetoothGattCharacteristic characteristic) {
        return this.setupNotification(characteristic, NotificationSetupMode.DEFAULT);
    }

    public Observable<Observable<byte[]>> setupNotification(final @NonNull UUID characteristicUuid, final @NonNull NotificationSetupMode setupMode) {
        if (this.indicationObservableMap.containsKey(characteristicUuid)) {
            return Observable.error((Throwable)new BleConflictingNotificationAlreadySetException(characteristicUuid, true));
        }
        Observable<Observable<byte[]>> availableObservable = this.notificationObservableMap.get(characteristicUuid);
        if (availableObservable != null) {
            return availableObservable;
        }
        Observable newObservable = this.createCharacteristicNotificationObservable(characteristicUuid, setupMode, false).doFinally(new Action(){

            public void run() {
                RxBleConnectionMock.this.dismissCharacteristicNotification(characteristicUuid, setupMode, false);
            }
        }).map((Function)new Function<Observable<byte[]>, Observable<byte[]>>(){

            public Observable<byte[]> apply(Observable<byte[]> notificationDescriptorData) {
                return RxBleConnectionMock.this.observeOnCharacteristicChangeCallbacks(characteristicUuid);
            }
        }).replay(1).refCount();
        this.notificationObservableMap.put(characteristicUuid, (Observable<Observable<byte[]>>)newObservable);
        return newObservable;
    }

    public Observable<Observable<byte[]>> setupNotification(@NonNull BluetoothGattCharacteristic characteristic, @NonNull NotificationSetupMode setupMode) {
        return this.setupNotification(characteristic.getUuid(), setupMode);
    }

    public Observable<Observable<byte[]>> setupIndication(@NonNull UUID characteristicUuid) {
        return this.setupIndication(characteristicUuid, NotificationSetupMode.DEFAULT);
    }

    public Observable<Observable<byte[]>> setupIndication(@NonNull BluetoothGattCharacteristic characteristic) {
        return this.setupIndication(characteristic.getUuid(), NotificationSetupMode.DEFAULT);
    }

    public Observable<Observable<byte[]>> setupIndication(final @NonNull UUID characteristicUuid, final @NonNull NotificationSetupMode setupMode) {
        if (this.notificationObservableMap.containsKey(characteristicUuid)) {
            return Observable.error((Throwable)new BleConflictingNotificationAlreadySetException(characteristicUuid, false));
        }
        Observable<Observable<byte[]>> availableObservable = this.indicationObservableMap.get(characteristicUuid);
        if (availableObservable != null) {
            return availableObservable;
        }
        Observable newObservable = this.createCharacteristicNotificationObservable(characteristicUuid, setupMode, true).doFinally(new Action(){

            public void run() {
                RxBleConnectionMock.this.dismissCharacteristicNotification(characteristicUuid, setupMode, true);
            }
        }).map((Function)new Function<Observable<byte[]>, Observable<byte[]>>(){

            public Observable<byte[]> apply(Observable<byte[]> notificationDescriptorData) {
                return RxBleConnectionMock.this.observeOnCharacteristicChangeCallbacks(characteristicUuid);
            }
        }).replay(1).refCount();
        this.indicationObservableMap.put(characteristicUuid, (Observable<Observable<byte[]>>)newObservable);
        return newObservable;
    }

    public Observable<Observable<byte[]>> setupIndication(@NonNull BluetoothGattCharacteristic characteristic, @NonNull NotificationSetupMode setupMode) {
        return this.setupIndication(characteristic.getUuid(), setupMode);
    }

    public Single<byte[]> writeCharacteristic(@NonNull BluetoothGattCharacteristic bluetoothGattCharacteristic, @NonNull byte[] data) {
        bluetoothGattCharacteristic.setValue(data);
        return Single.just((Object)data);
    }

    public RxBleConnection.LongWriteOperationBuilder createNewLongWriteBuilder() {
        return new RxBleConnection.LongWriteOperationBuilder(){
            private Single<BluetoothGattCharacteristic> bluetoothGattCharacteristicObservable;
            private int maxBatchSize = 20;
            private byte[] bytes;
            private RxBleConnection.WriteOperationAckStrategy writeOperationAckStrategy = new ImmediateSerializedBatchAckStrategy();

            public RxBleConnection.LongWriteOperationBuilder setBytes(@NonNull byte[] bytes) {
                this.bytes = bytes;
                return this;
            }

            public RxBleConnection.LongWriteOperationBuilder setCharacteristicUuid(final @NonNull UUID uuid) {
                this.bluetoothGattCharacteristicObservable = RxBleConnectionMock.this.discoverServices().flatMap((Function)new Function<RxBleDeviceServices, SingleSource<BluetoothGattCharacteristic>>(){

                    public SingleSource<BluetoothGattCharacteristic> apply(RxBleDeviceServices rxBleDeviceServices) {
                        return rxBleDeviceServices.getCharacteristic(uuid);
                    }
                });
                return this;
            }

            public RxBleConnection.LongWriteOperationBuilder setCharacteristic(@NonNull BluetoothGattCharacteristic bluetoothGattCharacteristic) {
                this.bluetoothGattCharacteristicObservable = Single.just((Object)bluetoothGattCharacteristic);
                return this;
            }

            public RxBleConnection.LongWriteOperationBuilder setMaxBatchSize(int maxBatchSize) {
                this.maxBatchSize = maxBatchSize;
                return this;
            }

            public RxBleConnection.LongWriteOperationBuilder setWriteOperationRetryStrategy(@NonNull RxBleConnection.WriteOperationRetryStrategy writeOperationRetryStrategy) {
                Log.e((String)"RxBleConnectionMock", (String)"Mock does not support retry strategies. It will always default to no retry.");
                return this;
            }

            public RxBleConnection.LongWriteOperationBuilder setWriteOperationAckStrategy(@NonNull RxBleConnection.WriteOperationAckStrategy writeOperationAckStrategy) {
                this.writeOperationAckStrategy = writeOperationAckStrategy;
                return this;
            }

            public Observable<byte[]> build() {
                if (this.bluetoothGattCharacteristicObservable == null) {
                    throw new IllegalArgumentException("setCharacteristicUuid() or setCharacteristic() needs to be called before build()");
                }
                if (this.bytes == null) {
                    throw new IllegalArgumentException("setBytes() needs to be called before build()");
                }
                boolean excess = this.bytes.length % this.maxBatchSize > 0;
                final AtomicInteger numberOfBatches = new AtomicInteger(this.bytes.length / this.maxBatchSize + (excess ? 1 : 0));
                return Observable.fromCallable((Callable)new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return numberOfBatches.get() > 0;
                    }
                }).compose((ObservableTransformer)this.writeOperationAckStrategy).repeatWhen(new Function<Observable<Object>, ObservableSource<?>>(){

                    public ObservableSource<?> apply(Observable<Object> onWriteFinished) throws Exception {
                        return onWriteFinished.takeWhile((Predicate)new Predicate<Object>(){

                            public boolean test(Object object) {
                                return numberOfBatches.decrementAndGet() > 0;
                            }
                        });
                    }
                }).ignoreElements().andThen((ObservableSource)Observable.just((Object)this.bytes));
            }
        };
    }

    public Single<byte[]> writeCharacteristic(@NonNull UUID characteristicUuid, final @NonNull byte[] data) {
        return this.getCharacteristic(characteristicUuid).map((Function)new Function<BluetoothGattCharacteristic, byte[]>(){

            public byte[] apply(BluetoothGattCharacteristic characteristic) {
                characteristic.setValue(data);
                return data;
            }
        });
    }

    public Completable writeDescriptor(final @NonNull UUID serviceUuid, final @NonNull UUID characteristicUuid, final @NonNull UUID descriptorUuid, final @NonNull byte[] data) {
        return this.discoverServices().flatMap((Function)new Function<RxBleDeviceServices, SingleSource<BluetoothGattDescriptor>>(){

            public SingleSource<BluetoothGattDescriptor> apply(RxBleDeviceServices rxBleDeviceServices) {
                return rxBleDeviceServices.getDescriptor(serviceUuid, characteristicUuid, descriptorUuid);
            }
        }).doOnSuccess((Consumer)new Consumer<BluetoothGattDescriptor>(){

            public void accept(BluetoothGattDescriptor bluetoothGattDescriptor) throws Exception {
                bluetoothGattDescriptor.setValue(data);
            }
        }).toCompletable();
    }

    public Completable writeDescriptor(final @NonNull BluetoothGattDescriptor descriptor, final @NonNull byte[] data) {
        return Completable.fromAction((Action)new Action(){

            public void run() throws Exception {
                descriptor.setValue(data);
            }
        });
    }

    private Observable<Observable<byte[]>> createCharacteristicNotificationObservable(final UUID characteristicUuid, NotificationSetupMode setupMode, boolean isIndication) {
        return this.setupCharacteristicNotification(characteristicUuid, setupMode, true, isIndication).andThen((ObservableSource)ObservableUtil.justOnNext((Object)true)).flatMap((Function)new Function<Boolean, ObservableSource<? extends Observable<byte[]>>>(){

            public ObservableSource<? extends Observable<byte[]>> apply(Boolean notUsed) {
                if (!RxBleConnectionMock.this.characteristicNotificationSources.containsKey(characteristicUuid)) {
                    return Observable.error((Throwable)new IllegalStateException("Lack of notification source for given characteristic"));
                }
                return Observable.just(RxBleConnectionMock.this.characteristicNotificationSources.get(characteristicUuid));
            }
        });
    }

    public Observable<ConnectionParameters> observeConnectionParametersUpdates() {
        return Observable.never();
    }

    private void dismissCharacteristicNotification(UUID characteristicUuid, NotificationSetupMode setupMode, boolean isIndication) {
        this.notificationObservableMap.remove(characteristicUuid);
        this.setupCharacteristicNotification(characteristicUuid, setupMode, false, isIndication).subscribe(Functions.EMPTY_ACTION, Functions.emptyConsumer());
    }

    @NonNull
    private Single<BluetoothGattDescriptor> getClientConfigurationDescriptor(UUID characteristicUuid) {
        return this.getCharacteristic(characteristicUuid).map((Function)new Function<BluetoothGattCharacteristic, BluetoothGattDescriptor>(){

            public BluetoothGattDescriptor apply(BluetoothGattCharacteristic bluetoothGattCharacteristic) {
                BluetoothGattDescriptor bluetoothGattDescriptor = bluetoothGattCharacteristic.getDescriptor(CLIENT_CHARACTERISTIC_CONFIG_UUID);
                if (bluetoothGattDescriptor == null) {
                    bluetoothGattDescriptor = new BluetoothGattDescriptor(CLIENT_CHARACTERISTIC_CONFIG_UUID, 0);
                    bluetoothGattCharacteristic.addDescriptor(bluetoothGattDescriptor);
                }
                return bluetoothGattDescriptor;
            }
        });
    }

    @NonNull
    private Observable<byte[]> observeOnCharacteristicChangeCallbacks(UUID characteristicUuid) {
        return this.characteristicNotificationSources.get(characteristicUuid);
    }

    @NonNull
    private Completable setupCharacteristicNotification(UUID bluetoothGattCharacteristicUUID, NotificationSetupMode setupMode, final boolean enabled, boolean isIndication) {
        if (setupMode == NotificationSetupMode.DEFAULT) {
            final byte[] enableValue = isIndication ? ENABLE_INDICATION_VALUE : ENABLE_NOTIFICATION_VALUE;
            return this.getClientConfigurationDescriptor(bluetoothGattCharacteristicUUID).flatMapCompletable((Function)new Function<BluetoothGattDescriptor, Completable>(){

                public Completable apply(BluetoothGattDescriptor bluetoothGattDescriptor) {
                    return RxBleConnectionMock.this.writeDescriptor(bluetoothGattDescriptor, enabled ? enableValue : DISABLE_NOTIFICATION_VALUE);
                }
            });
        }
        return Completable.complete();
    }

    public <T> Observable<T> queue(@NonNull RxBleCustomOperation<T> operation) {
        throw new UnsupportedOperationException("Mock does not support queuing custom operation.");
    }

    public <T> Observable<T> queue(@NonNull RxBleCustomOperation<T> operation, Priority priority) {
        throw new UnsupportedOperationException("Mock does not support queuing custom operation.");
    }
}

