/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.mockrxandroidble;

import android.bluetooth.BluetoothDevice;
import androidx.annotation.Nullable;
import com.polidea.rxandroidble2.RxBleConnection;
import com.polidea.rxandroidble2.RxBleDevice;
import com.polidea.rxandroidble2.RxBleDeviceServices;
import com.polidea.rxandroidble2.Timeout;
import com.polidea.rxandroidble2.exceptions.BleAlreadyConnectedException;
import com.polidea.rxandroidble2.mockrxandroidble.RxBleConnectionMock;
import io.reactivex.Observable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.subjects.BehaviorSubject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;

public class RxBleDeviceMock
implements RxBleDevice {
    private RxBleConnection rxBleConnection;
    private BehaviorSubject<RxBleConnection.RxBleConnectionState> connectionStateBehaviorSubject = BehaviorSubject.createDefault((Object)RxBleConnection.RxBleConnectionState.DISCONNECTED);
    private String name;
    private String macAddress;
    private Integer rssi;
    private byte[] scanRecord;
    private List<UUID> advertisedUUIDs;
    private BluetoothDevice bluetoothDevice;
    private AtomicBoolean isConnected = new AtomicBoolean(false);

    public RxBleDeviceMock(String name, String macAddress, byte[] scanRecord, Integer rssi, RxBleDeviceServices rxBleDeviceServices, Map<UUID, Observable<byte[]>> characteristicNotificationSources, @Nullable BluetoothDevice bluetoothDevice) {
        this.name = name;
        this.macAddress = macAddress;
        this.rxBleConnection = new RxBleConnectionMock(rxBleDeviceServices, rssi, characteristicNotificationSources);
        this.rssi = rssi;
        this.scanRecord = scanRecord;
        this.advertisedUUIDs = new ArrayList<UUID>();
        this.bluetoothDevice = bluetoothDevice;
    }

    public void addAdvertisedUUID(UUID advertisedUUID) {
        this.advertisedUUIDs.add(advertisedUUID);
    }

    public Observable<RxBleConnection> establishConnection(boolean autoConnect) {
        return Observable.defer((Callable)new Callable<Observable<RxBleConnection>>(){

            @Override
            public Observable<RxBleConnection> call() {
                if (RxBleDeviceMock.this.isConnected.compareAndSet(false, true)) {
                    return RxBleDeviceMock.this.emitConnectionWithoutCompleting().doOnSubscribe((Consumer)new Consumer<Disposable>(){

                        public void accept(Disposable disposable) throws Exception {
                            RxBleDeviceMock.this.connectionStateBehaviorSubject.onNext((Object)RxBleConnection.RxBleConnectionState.CONNECTING);
                        }
                    }).doOnNext((Consumer)new Consumer<RxBleConnection>(){

                        public void accept(RxBleConnection rxBleConnection) throws Exception {
                            RxBleDeviceMock.this.connectionStateBehaviorSubject.onNext((Object)RxBleConnection.RxBleConnectionState.CONNECTED);
                        }
                    }).doFinally(new Action(){

                        public void run() {
                            RxBleDeviceMock.this.connectionStateBehaviorSubject.onNext((Object)RxBleConnection.RxBleConnectionState.DISCONNECTED);
                            RxBleDeviceMock.this.isConnected.set(false);
                        }
                    });
                }
                return Observable.error((Throwable)new BleAlreadyConnectedException(RxBleDeviceMock.this.macAddress));
            }
        });
    }

    public Observable<RxBleConnection> establishConnection(boolean autoConnect, Timeout operationTimeout) {
        return this.establishConnection(autoConnect);
    }

    private Observable<RxBleConnection> emitConnectionWithoutCompleting() {
        return Observable.never().startWith((Object)this.rxBleConnection);
    }

    public List<UUID> getAdvertisedUUIDs() {
        return this.advertisedUUIDs;
    }

    public RxBleConnection.RxBleConnectionState getConnectionState() {
        return (RxBleConnection.RxBleConnectionState)this.observeConnectionStateChanges().blockingFirst();
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public BluetoothDevice getBluetoothDevice() {
        if (this.bluetoothDevice != null) {
            return this.bluetoothDevice;
        }
        throw new IllegalStateException("Mock is not configured to return a BluetoothDevice");
    }

    public String getName() {
        return this.name;
    }

    public Integer getRssi() {
        return this.rssi;
    }

    public byte[] getScanRecord() {
        return this.scanRecord;
    }

    public Observable<RxBleConnection.RxBleConnectionState> observeConnectionStateChanges() {
        return this.connectionStateBehaviorSubject.distinctUntilChanged();
    }

    public String toString() {
        return "RxBleDeviceImpl{bluetoothDevice=" + this.name + '(' + this.macAddress + ')' + '}';
    }
}

