/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothManager;
import android.content.ContentResolver;
import android.content.Context;
import android.location.LocationManager;
import android.os.Build;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import bleshadow.dagger.Binds;
import bleshadow.dagger.BindsInstance;
import bleshadow.dagger.Component;
import bleshadow.dagger.Module;
import bleshadow.dagger.Provides;
import bleshadow.javax.inject.Named;
import bleshadow.javax.inject.Provider;
import com.polidea.rxandroidble2.ClientScope;
import com.polidea.rxandroidble2.RxBleAdapterStateObservable;
import com.polidea.rxandroidble2.RxBleClient;
import com.polidea.rxandroidble2.RxBleClientImpl;
import com.polidea.rxandroidble2.helpers.LocationServicesOkObservable;
import com.polidea.rxandroidble2.internal.DeviceComponent;
import com.polidea.rxandroidble2.internal.scan.BackgroundScannerImpl;
import com.polidea.rxandroidble2.internal.scan.InternalToExternalScanResultConverter;
import com.polidea.rxandroidble2.internal.scan.RxBleInternalScanResult;
import com.polidea.rxandroidble2.internal.scan.ScanPreconditionsVerifier;
import com.polidea.rxandroidble2.internal.scan.ScanPreconditionsVerifierApi18;
import com.polidea.rxandroidble2.internal.scan.ScanPreconditionsVerifierApi24;
import com.polidea.rxandroidble2.internal.scan.ScanSetupBuilder;
import com.polidea.rxandroidble2.internal.scan.ScanSetupBuilderImplApi18;
import com.polidea.rxandroidble2.internal.scan.ScanSetupBuilderImplApi21;
import com.polidea.rxandroidble2.internal.scan.ScanSetupBuilderImplApi23;
import com.polidea.rxandroidble2.internal.serialization.ClientOperationQueue;
import com.polidea.rxandroidble2.internal.serialization.ClientOperationQueueImpl;
import com.polidea.rxandroidble2.internal.util.LocationServicesOkObservableApi23Factory;
import com.polidea.rxandroidble2.internal.util.LocationServicesStatus;
import com.polidea.rxandroidble2.internal.util.LocationServicesStatusApi18;
import com.polidea.rxandroidble2.internal.util.LocationServicesStatusApi23;
import com.polidea.rxandroidble2.internal.util.ObservableUtil;
import com.polidea.rxandroidble2.scan.BackgroundScanner;
import com.polidea.rxandroidble2.scan.ScanResult;
import io.reactivex.Observable;
import io.reactivex.Scheduler;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@ClientScope
@Component(modules={ClientModule.class})
public interface ClientComponent {
    public LocationServicesOkObservable locationServicesOkObservable();

    public RxBleClient rxBleClient();

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static interface ClientComponentFinalizer {
        public void onFinalize();
    }

    @Module(subcomponents={DeviceComponent.class})
    public static abstract class ClientModule {
        @Provides
        static BluetoothManager provideBluetoothManager(Context context) {
            return (BluetoothManager)context.getSystemService("bluetooth");
        }

        @Provides
        @Nullable
        static BluetoothAdapter provideBluetoothAdapter() {
            return BluetoothAdapter.getDefaultAdapter();
        }

        @Provides
        @Named(value="computation")
        static Scheduler provideComputationScheduler() {
            return Schedulers.computation();
        }

        @Provides
        @Named(value="device-sdk")
        static int provideDeviceSdk() {
            return Build.VERSION.SDK_INT;
        }

        @Provides
        static ContentResolver provideContentResolver(Context context) {
            return context.getContentResolver();
        }

        @Provides
        static LocationServicesStatus provideLocationServicesStatus(@Named(value="device-sdk") int deviceSdk, Provider<LocationServicesStatusApi18> locationServicesStatusApi18Provider, Provider<LocationServicesStatusApi23> locationServicesStatusApi23Provider) {
            return deviceSdk < 23 ? (LocationServicesStatus)locationServicesStatusApi18Provider.get() : (LocationServicesStatus)locationServicesStatusApi23Provider.get();
        }

        @Provides
        @Named(value="location-ok-boolean-observable")
        static Observable<Boolean> provideLocationServicesOkObservable(@Named(value="device-sdk") int deviceSdk, LocationServicesOkObservableApi23Factory locationServicesOkObservableApi23Factory) {
            return deviceSdk < 23 ? ObservableUtil.justOnNext(true) : locationServicesOkObservableApi23Factory.get();
        }

        @Provides
        @Named(value="executor_connection_queue")
        @ClientScope
        static ExecutorService provideConnectionQueueExecutorService() {
            return Executors.newCachedThreadPool();
        }

        @Provides
        @Named(value="executor_bluetooth_interaction")
        @ClientScope
        static ExecutorService provideBluetoothInteractionExecutorService() {
            return Executors.newSingleThreadExecutor();
        }

        @Provides
        @Named(value="executor_bluetooth_callbacks")
        @ClientScope
        static ExecutorService provideBluetoothCallbacksExecutorService() {
            return Executors.newSingleThreadExecutor();
        }

        @Provides
        @Named(value="bluetooth_interaction")
        @ClientScope
        static Scheduler provideBluetoothInteractionScheduler(@Named(value="executor_bluetooth_interaction") ExecutorService service) {
            return Schedulers.from((Executor)service);
        }

        @Provides
        @Named(value="bluetooth_callbacks")
        @ClientScope
        static Scheduler provideBluetoothCallbacksScheduler(@Named(value="executor_bluetooth_callbacks") ExecutorService service) {
            return Schedulers.from((Executor)service);
        }

        @Provides
        static ClientComponentFinalizer provideFinalizationCloseable(final @Named(value="executor_bluetooth_interaction") ExecutorService interactionExecutorService, final @Named(value="executor_bluetooth_callbacks") ExecutorService callbacksExecutorService, final @Named(value="executor_connection_queue") ExecutorService connectionQueueExecutorService) {
            return new ClientComponentFinalizer(){

                @Override
                public void onFinalize() {
                    interactionExecutorService.shutdown();
                    callbacksExecutorService.shutdown();
                    connectionQueueExecutorService.shutdown();
                }
            };
        }

        @Provides
        static LocationManager provideLocationManager(Context context) {
            return (LocationManager)context.getSystemService("location");
        }

        @Provides
        @Named(value="target-sdk")
        static int provideTargetSdk(Context context) {
            try {
                return context.getPackageManager().getApplicationInfo((String)context.getPackageName(), (int)0).targetSdkVersion;
            }
            catch (Throwable catchThemAll) {
                return Integer.MAX_VALUE;
            }
        }

        @Provides
        @Named(value="android-wear")
        @SuppressLint(value={"InlinedApi"})
        static boolean provideIsAndroidWear(Context context, @Named(value="device-sdk") int deviceSdk) {
            return deviceSdk >= 20 && context.getPackageManager().hasSystemFeature("android.hardware.type.watch");
        }

        @Provides
        @ClientScope
        static ScanSetupBuilder provideScanSetupProvider(@Named(value="device-sdk") int deviceSdk, Provider<ScanSetupBuilderImplApi18> scanSetupBuilderProviderForApi18, Provider<ScanSetupBuilderImplApi21> scanSetupBuilderProviderForApi21, Provider<ScanSetupBuilderImplApi23> scanSetupBuilderProviderForApi23) {
            if (deviceSdk < 21) {
                return (ScanSetupBuilder)scanSetupBuilderProviderForApi18.get();
            }
            if (deviceSdk < 23) {
                return (ScanSetupBuilder)scanSetupBuilderProviderForApi21.get();
            }
            return (ScanSetupBuilder)scanSetupBuilderProviderForApi23.get();
        }

        @Provides
        @Named(value="enable-notification-value")
        static byte[] provideEnableNotificationValue() {
            return BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE;
        }

        @Provides
        @Named(value="enable-indication-value")
        static byte[] provideEnableIndicationValue() {
            return BluetoothGattDescriptor.ENABLE_INDICATION_VALUE;
        }

        @Provides
        @Named(value="disable-notification-value")
        static byte[] provideDisableNotificationValue() {
            return BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE;
        }

        @Provides
        static ScanPreconditionsVerifier provideScanPreconditionVerifier(@Named(value="device-sdk") int deviceSdk, Provider<ScanPreconditionsVerifierApi18> scanPreconditionVerifierForApi18, Provider<ScanPreconditionsVerifierApi24> scanPreconditionVerifierForApi24) {
            if (deviceSdk < 24) {
                return (ScanPreconditionsVerifier)scanPreconditionVerifierForApi18.get();
            }
            return (ScanPreconditionsVerifier)scanPreconditionVerifierForApi24.get();
        }

        @Binds
        abstract Observable<RxBleAdapterStateObservable.BleAdapterState> bindStateObs(RxBleAdapterStateObservable var1);

        @Binds
        abstract BackgroundScanner bindBackgroundScanner(BackgroundScannerImpl var1);

        @Binds
        @ClientScope
        abstract RxBleClient bindRxBleClient(RxBleClientImpl var1);

        @Binds
        @ClientScope
        abstract ClientOperationQueue bindClientOperationQueue(ClientOperationQueueImpl var1);

        @Binds
        @Named(value="timeout")
        abstract Scheduler bindTimeoutScheduler(@Named(value="computation") Scheduler var1);

        @Binds
        abstract Function<RxBleInternalScanResult, ScanResult> provideScanResultMapper(InternalToExternalScanResultConverter var1);
    }

    @Component.Builder
    public static interface Builder {
        public ClientComponent build();

        @BindsInstance
        public Builder applicationContext(Context var1);
    }

    public static class BluetoothConstants {
        public static final String ENABLE_NOTIFICATION_VALUE = "enable-notification-value";
        public static final String ENABLE_INDICATION_VALUE = "enable-indication-value";
        public static final String DISABLE_NOTIFICATION_VALUE = "disable-notification-value";

        private BluetoothConstants() {
        }
    }

    public static class NamedBooleanObservables {
        public static final String LOCATION_SERVICES_OK = "location-ok-boolean-observable";

        private NamedBooleanObservables() {
        }
    }

    public static class PlatformConstants {
        public static final String INT_TARGET_SDK = "target-sdk";
        public static final String INT_DEVICE_SDK = "device-sdk";
        public static final String BOOL_IS_ANDROID_WEAR = "android-wear";

        private PlatformConstants() {
        }
    }

    public static class NamedSchedulers {
        public static final String COMPUTATION = "computation";
        public static final String TIMEOUT = "timeout";
        public static final String BLUETOOTH_INTERACTION = "bluetooth_interaction";
        public static final String BLUETOOTH_CALLBACKS = "bluetooth_callbacks";

        private NamedSchedulers() {
        }
    }

    public static class NamedExecutors {
        public static final String BLUETOOTH_INTERACTION = "executor_bluetooth_interaction";
        public static final String BLUETOOTH_CALLBACKS = "executor_bluetooth_callbacks";
        public static final String CONNECTION_QUEUE = "executor_connection_queue";

        private NamedExecutors() {
        }
    }
}

