/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2;

import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.polidea.rxandroidble2.ConnectionParameters;
import com.polidea.rxandroidble2.NotificationSetupMode;
import com.polidea.rxandroidble2.RxBleCustomOperation;
import com.polidea.rxandroidble2.RxBleDeviceServices;
import com.polidea.rxandroidble2.exceptions.BleGattException;
import com.polidea.rxandroidble2.internal.Priority;
import io.reactivex.Completable;
import io.reactivex.Observable;
import io.reactivex.ObservableTransformer;
import io.reactivex.Single;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public interface RxBleConnection {
    public static final int GATT_WRITE_MTU_OVERHEAD = 3;
    public static final int GATT_READ_MTU_OVERHEAD = 1;
    public static final int GATT_MTU_MINIMUM = 23;
    public static final int GATT_MTU_MAXIMUM = 517;

    public Single<RxBleDeviceServices> discoverServices();

    public Single<RxBleDeviceServices> discoverServices(@IntRange(from=1L) long var1, @NonNull TimeUnit var3);

    public Observable<Observable<byte[]>> setupNotification(@NonNull UUID var1);

    public Observable<Observable<byte[]>> setupNotification(@NonNull BluetoothGattCharacteristic var1);

    public Observable<Observable<byte[]>> setupNotification(@NonNull UUID var1, @NonNull NotificationSetupMode var2);

    public Observable<Observable<byte[]>> setupNotification(@NonNull BluetoothGattCharacteristic var1, @NonNull NotificationSetupMode var2);

    public Observable<Observable<byte[]>> setupIndication(@NonNull UUID var1);

    public Observable<Observable<byte[]>> setupIndication(@NonNull BluetoothGattCharacteristic var1);

    public Observable<Observable<byte[]>> setupIndication(@NonNull UUID var1, @NonNull NotificationSetupMode var2);

    public Observable<Observable<byte[]>> setupIndication(@NonNull BluetoothGattCharacteristic var1, @NonNull NotificationSetupMode var2);

    @Deprecated
    public Single<BluetoothGattCharacteristic> getCharacteristic(@NonNull UUID var1);

    public Single<byte[]> readCharacteristic(@NonNull UUID var1);

    public Single<byte[]> readCharacteristic(@NonNull BluetoothGattCharacteristic var1);

    public Single<byte[]> writeCharacteristic(@NonNull UUID var1, @NonNull byte[] var2);

    public Single<byte[]> writeCharacteristic(@NonNull BluetoothGattCharacteristic var1, @NonNull byte[] var2);

    public LongWriteOperationBuilder createNewLongWriteBuilder();

    public Single<byte[]> readDescriptor(@NonNull UUID var1, @NonNull UUID var2, @NonNull UUID var3);

    public Single<byte[]> readDescriptor(@NonNull BluetoothGattDescriptor var1);

    public Completable writeDescriptor(@NonNull UUID var1, @NonNull UUID var2, @NonNull UUID var3, @NonNull byte[] var4);

    public Completable writeDescriptor(@NonNull BluetoothGattDescriptor var1, @NonNull byte[] var2);

    @RequiresApi(value=21)
    public Completable requestConnectionPriority(int var1, @IntRange(from=1L) long var2, @NonNull TimeUnit var4);

    @RequiresApi(value=26)
    public Observable<ConnectionParameters> observeConnectionParametersUpdates();

    public Single<Integer> readRssi();

    @RequiresApi(value=21)
    public Single<Integer> requestMtu(@IntRange(from=23L, to=517L) int var1);

    public int getMtu();

    public <T> Observable<T> queue(@NonNull RxBleCustomOperation<T> var1);

    public <T> Observable<T> queue(@NonNull RxBleCustomOperation<T> var1, Priority var2);

    public static interface WriteOperationAckStrategy
    extends ObservableTransformer<Boolean, Boolean> {
    }

    public static interface WriteOperationRetryStrategy
    extends ObservableTransformer<LongWriteFailure, LongWriteFailure> {

        public static class LongWriteFailure {
            final int batchIndex;
            final BleGattException cause;

            public LongWriteFailure(int batchIndex, BleGattException cause) {
                this.batchIndex = batchIndex;
                this.cause = cause;
            }

            public int getBatchIndex() {
                return this.batchIndex;
            }

            public BleGattException getCause() {
                return this.cause;
            }
        }
    }

    public static interface LongWriteOperationBuilder {
        public LongWriteOperationBuilder setBytes(@NonNull byte[] var1);

        public LongWriteOperationBuilder setCharacteristicUuid(@NonNull UUID var1);

        public LongWriteOperationBuilder setCharacteristic(@NonNull BluetoothGattCharacteristic var1);

        public LongWriteOperationBuilder setMaxBatchSize(@IntRange(from=1L, to=514L) int var1);

        public LongWriteOperationBuilder setWriteOperationRetryStrategy(@NonNull WriteOperationRetryStrategy var1);

        public LongWriteOperationBuilder setWriteOperationAckStrategy(@NonNull WriteOperationAckStrategy var1);

        public Observable<byte[]> build();
    }

    public static enum RxBleConnectionState {
        CONNECTING("CONNECTING"),
        CONNECTED("CONNECTED"),
        DISCONNECTED("DISCONNECTED"),
        DISCONNECTING("DISCONNECTING");

        private final String description;

        private RxBleConnectionState(String description) {
            this.description = description;
        }

        public String toString() {
            return "RxBleConnectionState{" + this.description + '}';
        }
    }

    @Deprecated
    public static interface Connector {
        public Single<RxBleConnection> prepareConnection(boolean var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RequiresApi(value=21)
    public static @interface ConnectionPriority {
    }
}

