/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2;

import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import androidx.annotation.NonNull;
import com.polidea.rxandroidble2.exceptions.BleCharacteristicNotFoundException;
import com.polidea.rxandroidble2.exceptions.BleDescriptorNotFoundException;
import com.polidea.rxandroidble2.exceptions.BleServiceNotFoundException;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;

public class RxBleDeviceServices {
    private final List<BluetoothGattService> bluetoothGattServices;

    public RxBleDeviceServices(List<BluetoothGattService> bluetoothGattServices) {
        this.bluetoothGattServices = bluetoothGattServices;
    }

    public List<BluetoothGattService> getBluetoothGattServices() {
        return this.bluetoothGattServices;
    }

    public Single<BluetoothGattService> getService(final @NonNull UUID serviceUuid) {
        return Observable.fromIterable(this.bluetoothGattServices).filter((Predicate)new Predicate<BluetoothGattService>(){

            public boolean test(BluetoothGattService bluetoothGattService) throws Exception {
                return bluetoothGattService.getUuid().equals(serviceUuid);
            }
        }).firstElement().switchIfEmpty((SingleSource)Single.error((Throwable)new BleServiceNotFoundException(serviceUuid)));
    }

    public Single<BluetoothGattCharacteristic> getCharacteristic(final @NonNull UUID characteristicUuid) {
        return Single.fromCallable((Callable)new Callable<BluetoothGattCharacteristic>(){

            @Override
            public BluetoothGattCharacteristic call() throws Exception {
                for (BluetoothGattService service : RxBleDeviceServices.this.bluetoothGattServices) {
                    BluetoothGattCharacteristic characteristic = service.getCharacteristic(characteristicUuid);
                    if (characteristic == null) continue;
                    return characteristic;
                }
                throw new BleCharacteristicNotFoundException(characteristicUuid);
            }
        });
    }

    public Single<BluetoothGattCharacteristic> getCharacteristic(@NonNull UUID serviceUuid, final @NonNull UUID characteristicUuid) {
        return this.getService(serviceUuid).map((Function)new Function<BluetoothGattService, BluetoothGattCharacteristic>(){

            public BluetoothGattCharacteristic apply(BluetoothGattService bluetoothGattService) {
                BluetoothGattCharacteristic characteristic = bluetoothGattService.getCharacteristic(characteristicUuid);
                if (characteristic == null) {
                    throw new BleCharacteristicNotFoundException(characteristicUuid);
                }
                return characteristic;
            }
        });
    }

    public Single<BluetoothGattDescriptor> getDescriptor(UUID characteristicUuid, final UUID descriptorUuid) {
        return this.getCharacteristic(characteristicUuid).map((Function)new Function<BluetoothGattCharacteristic, BluetoothGattDescriptor>(){

            public BluetoothGattDescriptor apply(BluetoothGattCharacteristic bluetoothGattCharacteristic) {
                BluetoothGattDescriptor descriptor = bluetoothGattCharacteristic.getDescriptor(descriptorUuid);
                if (descriptor == null) {
                    throw new BleDescriptorNotFoundException(descriptorUuid);
                }
                return descriptor;
            }
        });
    }

    public Single<BluetoothGattDescriptor> getDescriptor(UUID serviceUuid, final UUID characteristicUuid, final UUID descriptorUuid) {
        return this.getService(serviceUuid).map((Function)new Function<BluetoothGattService, BluetoothGattCharacteristic>(){

            public BluetoothGattCharacteristic apply(BluetoothGattService bluetoothGattService) {
                return bluetoothGattService.getCharacteristic(characteristicUuid);
            }
        }).map((Function)new Function<BluetoothGattCharacteristic, BluetoothGattDescriptor>(){

            public BluetoothGattDescriptor apply(BluetoothGattCharacteristic bluetoothGattCharacteristic) {
                BluetoothGattDescriptor descriptor = bluetoothGattCharacteristic.getDescriptor(descriptorUuid);
                if (descriptor == null) {
                    throw new BleDescriptorNotFoundException(descriptorUuid);
                }
                return descriptor;
            }
        });
    }
}

