/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.exceptions;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothGatt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.polidea.rxandroidble2.exceptions.BleException;
import com.polidea.rxandroidble2.exceptions.BleGattOperationType;
import com.polidea.rxandroidble2.internal.logger.LoggerUtil;
import com.polidea.rxandroidble2.utils.GattStatusParser;

public class BleGattException
extends BleException {
    public static final int UNKNOWN_STATUS = -1;
    @Nullable
    private final BluetoothGatt gatt;
    private final int status;
    private final BleGattOperationType bleGattOperationType;

    @Deprecated
    public BleGattException(int status, BleGattOperationType bleGattOperationType) {
        super(BleGattException.createMessage(null, status, bleGattOperationType));
        this.gatt = null;
        this.status = status;
        this.bleGattOperationType = bleGattOperationType;
    }

    public BleGattException(@NonNull BluetoothGatt gatt, int status, BleGattOperationType bleGattOperationType) {
        super(BleGattException.createMessage(gatt, status, bleGattOperationType));
        this.gatt = gatt;
        this.status = status;
        this.bleGattOperationType = bleGattOperationType;
    }

    public BleGattException(BluetoothGatt gatt, BleGattOperationType bleGattOperationType) {
        this(gatt, -1, bleGattOperationType);
    }

    public String getMacAddress() {
        return BleGattException.getMacAddress(this.gatt);
    }

    public BleGattOperationType getBleGattOperationType() {
        return this.bleGattOperationType;
    }

    public int getStatus() {
        return this.status;
    }

    private static String getMacAddress(@Nullable BluetoothGatt gatt) {
        return gatt != null && gatt.getDevice() != null ? gatt.getDevice().getAddress() : null;
    }

    @SuppressLint(value={"DefaultLocale"})
    private static String createMessage(@Nullable BluetoothGatt gatt, int status, BleGattOperationType bleGattOperationType) {
        if (status == -1) {
            return String.format("GATT exception from MAC address %s, with type %s", BleGattException.getMacAddress(gatt), bleGattOperationType);
        }
        String statusDescription = GattStatusParser.getGattCallbackStatusDescription(status);
        String link = "https://android.googlesource.com/platform/external/bluetooth/bluedroid/+/android-5.1.0_r1/stack/include/gatt_api.h";
        return String.format("GATT exception from %s, status %d (%s), type %s. (Look up status 0x%02x here %s)", LoggerUtil.commonMacMessage(gatt), status, statusDescription, bleGattOperationType, status, "https://android.googlesource.com/platform/external/bluetooth/bluedroid/+/android-5.1.0_r1/stack/include/gatt_api.h");
    }
}

