/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.exceptions;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.polidea.rxandroidble2.exceptions.BleException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Date;

public class BleScanException
extends BleException {
    public static final int BLUETOOTH_CANNOT_START = 0;
    public static final int BLUETOOTH_DISABLED = 1;
    public static final int BLUETOOTH_NOT_AVAILABLE = 2;
    public static final int LOCATION_PERMISSION_MISSING = 3;
    public static final int LOCATION_SERVICES_DISABLED = 4;
    public static final int SCAN_FAILED_ALREADY_STARTED = 5;
    public static final int SCAN_FAILED_APPLICATION_REGISTRATION_FAILED = 6;
    public static final int SCAN_FAILED_INTERNAL_ERROR = 7;
    public static final int SCAN_FAILED_FEATURE_UNSUPPORTED = 8;
    public static final int SCAN_FAILED_OUT_OF_HARDWARE_RESOURCES = 9;
    public static final int UNDOCUMENTED_SCAN_THROTTLE = 0x7FFFFFFE;
    public static final int UNKNOWN_ERROR_CODE = Integer.MAX_VALUE;
    private final int reason;
    private final Date retryDateSuggestion;

    public BleScanException(int reason) {
        super(BleScanException.createMessage(reason, null));
        this.reason = reason;
        this.retryDateSuggestion = null;
    }

    public BleScanException(int reason, @NonNull Date retryDateSuggestion) {
        super(BleScanException.createMessage(reason, retryDateSuggestion));
        this.reason = reason;
        this.retryDateSuggestion = retryDateSuggestion;
    }

    public BleScanException(int reason, Throwable causeException) {
        super(BleScanException.createMessage(reason, null), causeException);
        this.reason = reason;
        this.retryDateSuggestion = null;
    }

    public int getReason() {
        return this.reason;
    }

    @Nullable
    public Date getRetryDateSuggestion() {
        return this.retryDateSuggestion;
    }

    private static String createMessage(int reason, Date retryDateSuggestion) {
        return BleScanException.reasonDescription(reason) + " (code " + reason + ")" + BleScanException.retryDateSuggestionIfExists(retryDateSuggestion);
    }

    private static String reasonDescription(int reason) {
        switch (reason) {
            case 0: {
                return "Bluetooth cannot start";
            }
            case 1: {
                return "Bluetooth disabled";
            }
            case 2: {
                return "Bluetooth not available";
            }
            case 3: {
                return "Location Permission missing";
            }
            case 4: {
                return "Location Services disabled";
            }
            case 5: {
                return "Scan failed because it has already started";
            }
            case 6: {
                return "Scan failed because application registration failed";
            }
            case 7: {
                return "Scan failed because of an internal error";
            }
            case 8: {
                return "Scan failed because feature unsupported";
            }
            case 9: {
                return "Scan failed because out of hardware resources";
            }
            case 0x7FFFFFFE: {
                return "Undocumented scan throttle";
            }
        }
        return "Unknown error";
    }

    private static String retryDateSuggestionIfExists(Date retryDateSuggestion) {
        if (retryDateSuggestion == null) {
            return "";
        }
        return ", suggested retry date is " + retryDateSuggestion;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Reason {
    }
}

