/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.helpers;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public class AdvertisedServiceUUIDExtractor {
    private static final String UUID_BASE = "%08x-0000-1000-8000-00805f9b34fb";

    public List<UUID> extractUUIDs(byte[] scanResult) {
        byte length;
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        ByteBuffer buffer = ByteBuffer.wrap(scanResult).order(ByteOrder.LITTLE_ENDIAN);
        block5: while (buffer.remaining() > 2 && (length = buffer.get()) != 0) {
            byte type = buffer.get();
            switch (type) {
                case 2: 
                case 3: {
                    UUID serviceUuid;
                    String serviceUuidString;
                    while (length >= 2) {
                        serviceUuidString = String.format(UUID_BASE, buffer.getShort());
                        serviceUuid = UUID.fromString(serviceUuidString);
                        uuids.add(serviceUuid);
                        length = (byte)(length - 2);
                    }
                    continue block5;
                }
                case 4: 
                case 5: {
                    UUID serviceUuid;
                    String serviceUuidString;
                    while (length >= 4) {
                        serviceUuidString = String.format(UUID_BASE, buffer.getInt());
                        serviceUuid = UUID.fromString(serviceUuidString);
                        uuids.add(serviceUuid);
                        length = (byte)(length - 4);
                    }
                }
                case 6: 
                case 7: {
                    while (length >= 16) {
                        long lsb = buffer.getLong();
                        long msb = buffer.getLong();
                        uuids.add(new UUID(msb, lsb));
                        length = (byte)(length - 16);
                    }
                    continue block5;
                }
            }
            buffer.position(buffer.position() + length - 1);
        }
        return uuids;
    }

    @NonNull
    public Set<UUID> toDistinctSet(@Nullable UUID[] uuids) {
        if (uuids == null) {
            uuids = new UUID[]{};
        }
        return new HashSet<UUID>(Arrays.asList(uuids));
    }
}

