/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal.connection;

import android.bluetooth.BluetoothGatt;
import bleshadow.dagger.Binds;
import bleshadow.dagger.Module;
import bleshadow.dagger.Provides;
import bleshadow.dagger.multibindings.IntoSet;
import bleshadow.javax.inject.Named;
import bleshadow.javax.inject.Provider;
import com.polidea.rxandroidble2.RxBleConnection;
import com.polidea.rxandroidble2.Timeout;
import com.polidea.rxandroidble2.internal.connection.BluetoothGattProvider;
import com.polidea.rxandroidble2.internal.connection.ConnectionSubscriptionWatcher;
import com.polidea.rxandroidble2.internal.connection.DisconnectAction;
import com.polidea.rxandroidble2.internal.connection.DisconnectionRouter;
import com.polidea.rxandroidble2.internal.connection.DisconnectionRouterInput;
import com.polidea.rxandroidble2.internal.connection.DisconnectionRouterOutput;
import com.polidea.rxandroidble2.internal.connection.IllegalOperationHandler;
import com.polidea.rxandroidble2.internal.connection.LoggingIllegalOperationHandler;
import com.polidea.rxandroidble2.internal.connection.LongWriteOperationBuilderImpl;
import com.polidea.rxandroidble2.internal.connection.MtuProvider;
import com.polidea.rxandroidble2.internal.connection.MtuWatcher;
import com.polidea.rxandroidble2.internal.connection.RxBleConnectionImpl;
import com.polidea.rxandroidble2.internal.connection.ThrowingIllegalOperationHandler;
import com.polidea.rxandroidble2.internal.operations.OperationsProvider;
import com.polidea.rxandroidble2.internal.operations.OperationsProviderImpl;
import com.polidea.rxandroidble2.internal.operations.TimeoutConfiguration;
import com.polidea.rxandroidble2.internal.serialization.ConnectionOperationQueue;
import com.polidea.rxandroidble2.internal.serialization.ConnectionOperationQueueImpl;
import com.polidea.rxandroidble2.internal.util.CharacteristicPropertiesParser;
import io.reactivex.Scheduler;

@Module
public abstract class ConnectionModule {
    public static final String OPERATION_TIMEOUT = "operation-timeout";

    @Provides
    @Named(value="operation-timeout")
    static TimeoutConfiguration providesOperationTimeoutConf(@Named(value="timeout") Scheduler timeoutScheduler, Timeout operationTimeout) {
        return new TimeoutConfiguration(operationTimeout.timeout, operationTimeout.timeUnit, timeoutScheduler);
    }

    @Provides
    static IllegalOperationHandler provideIllegalOperationHandler(@Named(value="suppressOperationChecks") boolean suppressOperationCheck, Provider<LoggingIllegalOperationHandler> loggingIllegalOperationHandlerProvider, Provider<ThrowingIllegalOperationHandler> throwingIllegalOperationHandlerProvider) {
        if (suppressOperationCheck) {
            return (IllegalOperationHandler)loggingIllegalOperationHandlerProvider.get();
        }
        return (IllegalOperationHandler)throwingIllegalOperationHandlerProvider.get();
    }

    @Provides
    static CharacteristicPropertiesParser provideCharacteristicPropertiesParser() {
        return new CharacteristicPropertiesParser(1, 2, 4, 8, 16, 32, 64);
    }

    @Provides
    @Named(value="GATT_WRITE_MTU_OVERHEAD")
    static int gattWriteMtuOverhead() {
        return 3;
    }

    @Provides
    @Named(value="GATT_MTU_MINIMUM")
    static int minimumMtu() {
        return 23;
    }

    @Provides
    static BluetoothGatt provideBluetoothGatt(BluetoothGattProvider bluetoothGattProvider) {
        return bluetoothGattProvider.getBluetoothGatt();
    }

    @Binds
    abstract RxBleConnection.LongWriteOperationBuilder bindLongWriteOperationBuilder(LongWriteOperationBuilderImpl var1);

    @Binds
    abstract OperationsProvider bindOperationsProvider(OperationsProviderImpl var1);

    @Binds
    abstract MtuProvider bindCurrentMtuProvider(MtuWatcher var1);

    @Binds
    @IntoSet
    abstract ConnectionSubscriptionWatcher bindMtuWatcherSubscriptionWatcher(MtuWatcher var1);

    @Binds
    @IntoSet
    abstract ConnectionSubscriptionWatcher bindDisconnectActionSubscriptionWatcher(DisconnectAction var1);

    @Binds
    @IntoSet
    abstract ConnectionSubscriptionWatcher bindConnectionQueueSubscriptionWatcher(ConnectionOperationQueueImpl var1);

    @Binds
    abstract RxBleConnection bindRxBleConnection(RxBleConnectionImpl var1);

    @Binds
    abstract ConnectionOperationQueue bindConnectionOperationQueue(ConnectionOperationQueueImpl var1);

    @Binds
    abstract DisconnectionRouterInput bindDisconnectionRouterInput(DisconnectionRouter var1);

    @Binds
    abstract DisconnectionRouterOutput bindDisconnectionRouterOutput(DisconnectionRouter var1);
}

