/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal.connection;

import bleshadow.javax.inject.Inject;
import bleshadow.javax.inject.Named;
import com.polidea.rxandroidble2.exceptions.BleGattException;
import com.polidea.rxandroidble2.exceptions.BleGattOperationType;
import com.polidea.rxandroidble2.internal.connection.ConnectionScope;
import com.polidea.rxandroidble2.internal.connection.ConnectionSubscriptionWatcher;
import com.polidea.rxandroidble2.internal.connection.MtuProvider;
import com.polidea.rxandroidble2.internal.connection.RxBleGattCallback;
import io.reactivex.Observable;
import io.reactivex.disposables.SerialDisposable;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Predicate;
import io.reactivex.internal.functions.Functions;

@ConnectionScope
class MtuWatcher
implements ConnectionSubscriptionWatcher,
MtuProvider,
Consumer<Integer> {
    private Integer currentMtu;
    private final Observable<Integer> mtuObservable;
    private final SerialDisposable serialSubscription = new SerialDisposable();

    @Inject
    MtuWatcher(RxBleGattCallback rxBleGattCallback, @Named(value="GATT_MTU_MINIMUM") int initialValue) {
        this.mtuObservable = rxBleGattCallback.getOnMtuChanged().retry((Predicate)new Predicate<Throwable>(){

            public boolean test(Throwable throwable) {
                return throwable instanceof BleGattException && ((BleGattException)throwable).getBleGattOperationType() == BleGattOperationType.ON_MTU_CHANGED;
            }
        });
        this.currentMtu = initialValue;
    }

    @Override
    public int getMtu() {
        return this.currentMtu;
    }

    @Override
    public void onConnectionSubscribed() {
        this.serialSubscription.set(this.mtuObservable.subscribe((Consumer)this, Functions.emptyConsumer()));
    }

    @Override
    public void onConnectionUnsubscribed() {
        this.serialSubscription.dispose();
    }

    public void accept(Integer newMtu) {
        this.currentMtu = newMtu;
    }
}

