/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal.operations;

import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.os.DeadObjectException;
import androidx.annotation.NonNull;
import bleshadow.javax.inject.Named;
import com.polidea.rxandroidble2.RxBleConnection;
import com.polidea.rxandroidble2.exceptions.BleDisconnectedException;
import com.polidea.rxandroidble2.exceptions.BleException;
import com.polidea.rxandroidble2.exceptions.BleGattCallbackTimeoutException;
import com.polidea.rxandroidble2.exceptions.BleGattCannotStartException;
import com.polidea.rxandroidble2.exceptions.BleGattCharacteristicException;
import com.polidea.rxandroidble2.exceptions.BleGattException;
import com.polidea.rxandroidble2.exceptions.BleGattOperationType;
import com.polidea.rxandroidble2.internal.QueueOperation;
import com.polidea.rxandroidble2.internal.RxBleLog;
import com.polidea.rxandroidble2.internal.connection.PayloadSizeLimitProvider;
import com.polidea.rxandroidble2.internal.connection.RxBleGattCallback;
import com.polidea.rxandroidble2.internal.logger.LoggerUtil;
import com.polidea.rxandroidble2.internal.operations.TimeoutConfiguration;
import com.polidea.rxandroidble2.internal.serialization.QueueReleaseInterface;
import com.polidea.rxandroidble2.internal.util.ByteAssociation;
import com.polidea.rxandroidble2.internal.util.DisposableUtil;
import com.polidea.rxandroidble2.internal.util.QueueReleasingEmitterWrapper;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.ObservableSource;
import io.reactivex.ObservableTransformer;
import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import io.reactivex.observers.DisposableObserver;
import java.nio.ByteBuffer;
import java.util.UUID;

public class CharacteristicLongWriteOperation
extends QueueOperation<byte[]> {
    private final BluetoothGatt bluetoothGatt;
    private final RxBleGattCallback rxBleGattCallback;
    private final Scheduler bluetoothInteractionScheduler;
    private final TimeoutConfiguration timeoutConfiguration;
    private final BluetoothGattCharacteristic bluetoothGattCharacteristic;
    private final PayloadSizeLimitProvider batchSizeProvider;
    private final RxBleConnection.WriteOperationAckStrategy writeOperationAckStrategy;
    private final RxBleConnection.WriteOperationRetryStrategy writeOperationRetryStrategy;
    private final byte[] bytesToWrite;
    private byte[] tempBatchArray;

    CharacteristicLongWriteOperation(BluetoothGatt bluetoothGatt, RxBleGattCallback rxBleGattCallback, @Named(value="bluetooth_interaction") Scheduler bluetoothInteractionScheduler, @Named(value="operation-timeout") TimeoutConfiguration timeoutConfiguration, BluetoothGattCharacteristic bluetoothGattCharacteristic, PayloadSizeLimitProvider batchSizeProvider, RxBleConnection.WriteOperationAckStrategy writeOperationAckStrategy, RxBleConnection.WriteOperationRetryStrategy writeOperationRetryStrategy, byte[] bytesToWrite) {
        this.bluetoothGatt = bluetoothGatt;
        this.rxBleGattCallback = rxBleGattCallback;
        this.bluetoothInteractionScheduler = bluetoothInteractionScheduler;
        this.timeoutConfiguration = timeoutConfiguration;
        this.bluetoothGattCharacteristic = bluetoothGattCharacteristic;
        this.batchSizeProvider = batchSizeProvider;
        this.writeOperationAckStrategy = writeOperationAckStrategy;
        this.writeOperationRetryStrategy = writeOperationRetryStrategy;
        this.bytesToWrite = bytesToWrite;
    }

    @Override
    protected void protectedRun(ObservableEmitter<byte[]> emitter, QueueReleaseInterface queueReleaseInterface) {
        final int batchSize = this.batchSizeProvider.getPayloadSizeLimit();
        if (batchSize <= 0) {
            throw new IllegalArgumentException("batchSizeProvider value must be greater than zero (now: " + batchSize + ")");
        }
        Observable timeoutObservable = Observable.error((Throwable)new BleGattCallbackTimeoutException(this.bluetoothGatt, BleGattOperationType.CHARACTERISTIC_LONG_WRITE));
        final ByteBuffer byteBuffer = ByteBuffer.wrap(this.bytesToWrite);
        final QueueReleasingEmitterWrapper<byte[]> emitterWrapper = new QueueReleasingEmitterWrapper<byte[]>(emitter, queueReleaseInterface);
        IntSupplier previousBatchIndexSupplier = new IntSupplier(){

            @Override
            public int get() {
                return (int)Math.ceil((float)byteBuffer.position() / (float)batchSize) - 1;
            }
        };
        this.writeBatchAndObserve(batchSize, byteBuffer, previousBatchIndexSupplier).subscribeOn(this.bluetoothInteractionScheduler).filter(CharacteristicLongWriteOperation.writeResponseForMatchingCharacteristic(this.bluetoothGattCharacteristic)).take(1L).timeout(this.timeoutConfiguration.timeout, this.timeoutConfiguration.timeoutTimeUnit, this.timeoutConfiguration.timeoutScheduler, (ObservableSource)timeoutObservable).repeatWhen(CharacteristicLongWriteOperation.bufferIsNotEmptyAndOperationHasBeenAcknowledgedAndNotUnsubscribed(this.writeOperationAckStrategy, byteBuffer, emitterWrapper)).retryWhen(CharacteristicLongWriteOperation.errorIsRetryableAndAccordingTo(this.writeOperationRetryStrategy, byteBuffer, batchSize, previousBatchIndexSupplier)).subscribe((Observer)new Observer<ByteAssociation<UUID>>(){

            public void onSubscribe(Disposable d) {
            }

            public void onNext(ByteAssociation<UUID> uuidByteAssociation) {
            }

            public void onError(Throwable e) {
                emitterWrapper.onError(e);
            }

            public void onComplete() {
                emitterWrapper.onNext(CharacteristicLongWriteOperation.this.bytesToWrite);
                emitterWrapper.onComplete();
            }
        });
    }

    @Override
    protected BleException provideException(DeadObjectException deadObjectException) {
        return new BleDisconnectedException(deadObjectException, this.bluetoothGatt.getDevice().getAddress(), -1);
    }

    @NonNull
    private Observable<ByteAssociation<UUID>> writeBatchAndObserve(final int batchSize, final ByteBuffer byteBuffer, final IntSupplier previousBatchIndexSupplier) {
        final Observable<ByteAssociation<UUID>> onCharacteristicWrite = this.rxBleGattCallback.getOnCharacteristicWrite();
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<ByteAssociation<UUID>>(){

            public void subscribe(ObservableEmitter<ByteAssociation<UUID>> emitter) {
                DisposableObserver writeCallbackObserver = (DisposableObserver)onCharacteristicWrite.subscribeWith(DisposableUtil.disposableObserverFromEmitter(emitter));
                emitter.setDisposable((Disposable)writeCallbackObserver);
                try {
                    byte[] bytesBatch = CharacteristicLongWriteOperation.this.getNextBatch(byteBuffer, batchSize);
                    CharacteristicLongWriteOperation.this.writeData(bytesBatch, previousBatchIndexSupplier);
                }
                catch (Throwable throwable) {
                    emitter.onError(throwable);
                }
            }
        });
    }

    private byte[] getNextBatch(ByteBuffer byteBuffer, int batchSize) {
        int remainingBytes = byteBuffer.remaining();
        int nextBatchSize = Math.min(remainingBytes, batchSize);
        if (this.tempBatchArray == null || this.tempBatchArray.length != nextBatchSize) {
            this.tempBatchArray = new byte[nextBatchSize];
        }
        byteBuffer.get(this.tempBatchArray);
        return this.tempBatchArray;
    }

    private void writeData(byte[] bytesBatch, IntSupplier batchIndexGetter) {
        if (RxBleLog.isAtLeast(3)) {
            RxBleLog.d("Writing batch #%04d: %s", batchIndexGetter.get(), LoggerUtil.bytesToHex(bytesBatch));
        }
        this.bluetoothGattCharacteristic.setValue(bytesBatch);
        boolean success = this.bluetoothGatt.writeCharacteristic(this.bluetoothGattCharacteristic);
        if (!success) {
            throw new BleGattCannotStartException(this.bluetoothGatt, BleGattOperationType.CHARACTERISTIC_LONG_WRITE);
        }
    }

    private static Predicate<ByteAssociation<UUID>> writeResponseForMatchingCharacteristic(final BluetoothGattCharacteristic bluetoothGattCharacteristic) {
        return new Predicate<ByteAssociation<UUID>>(){

            public boolean test(ByteAssociation<UUID> uuidByteAssociation) {
                return ((UUID)uuidByteAssociation.first).equals(bluetoothGattCharacteristic.getUuid());
            }
        };
    }

    static Function<Observable<?>, ObservableSource<?>> bufferIsNotEmptyAndOperationHasBeenAcknowledgedAndNotUnsubscribed(final RxBleConnection.WriteOperationAckStrategy writeOperationAckStrategy, final ByteBuffer byteBuffer, final QueueReleasingEmitterWrapper<byte[]> emitterWrapper) {
        return new Function<Observable<?>, ObservableSource<?>>(){

            public ObservableSource<?> apply(Observable<?> emittingOnBatchWriteFinished) {
                return emittingOnBatchWriteFinished.takeWhile(this.notUnsubscribed(emitterWrapper)).map(this.bufferIsNotEmpty(byteBuffer)).compose((ObservableTransformer)writeOperationAckStrategy).takeWhile((Predicate)new Predicate<Boolean>(){

                    public boolean test(Boolean hasRemaining) {
                        return hasRemaining;
                    }
                });
            }

            @NonNull
            private Function<Object, Boolean> bufferIsNotEmpty(final ByteBuffer byteBuffer2) {
                return new Function<Object, Boolean>(){

                    public Boolean apply(Object emittedFromActStrategy) {
                        return byteBuffer2.hasRemaining();
                    }
                };
            }

            @NonNull
            private Predicate<Object> notUnsubscribed(final QueueReleasingEmitterWrapper<byte[]> emitterWrapper2) {
                return new Predicate<Object>(){

                    public boolean test(Object emission) {
                        return !emitterWrapper2.isWrappedEmitterUnsubscribed();
                    }
                };
            }
        };
    }

    private static Function<Observable<Throwable>, ObservableSource<?>> errorIsRetryableAndAccordingTo(final RxBleConnection.WriteOperationRetryStrategy writeOperationRetryStrategy, final ByteBuffer byteBuffer, final int batchSize, final IntSupplier previousBatchIndexSupplier) {
        return new Function<Observable<Throwable>, ObservableSource<?>>(){

            public ObservableSource<?> apply(Observable<Throwable> emittedOnWriteFailure) {
                return emittedOnWriteFailure.flatMap(this.toLongWriteFailureOrError()).doOnNext(this.repositionByteBufferForRetry()).compose((ObservableTransformer)writeOperationRetryStrategy);
            }

            @NonNull
            private Function<Throwable, Observable<RxBleConnection.WriteOperationRetryStrategy.LongWriteFailure>> toLongWriteFailureOrError() {
                return new Function<Throwable, Observable<RxBleConnection.WriteOperationRetryStrategy.LongWriteFailure>>(){

                    public Observable<RxBleConnection.WriteOperationRetryStrategy.LongWriteFailure> apply(Throwable throwable) {
                        if (!(throwable instanceof BleGattCharacteristicException) && !(throwable instanceof BleGattCannotStartException)) {
                            return Observable.error((Throwable)throwable);
                        }
                        int failedBatchIndex = previousBatchIndexSupplier.get();
                        RxBleConnection.WriteOperationRetryStrategy.LongWriteFailure longWriteFailure = new RxBleConnection.WriteOperationRetryStrategy.LongWriteFailure(failedBatchIndex, (BleGattException)throwable);
                        return Observable.just((Object)longWriteFailure);
                    }
                };
            }

            @NonNull
            private Consumer<RxBleConnection.WriteOperationRetryStrategy.LongWriteFailure> repositionByteBufferForRetry() {
                return new Consumer<RxBleConnection.WriteOperationRetryStrategy.LongWriteFailure>(){

                    public void accept(RxBleConnection.WriteOperationRetryStrategy.LongWriteFailure longWriteFailure) {
                        int newBufferPosition = longWriteFailure.getBatchIndex() * batchSize;
                        byteBuffer.position(newBufferPosition);
                    }
                };
            }
        };
    }

    public String toString() {
        return "CharacteristicLongWriteOperation{" + LoggerUtil.commonMacMessage(this.bluetoothGatt) + ", characteristic=" + LoggerUtil.wrap(this.bluetoothGattCharacteristic, false) + ", maxBatchSize=" + this.batchSizeProvider.getPayloadSizeLimit() + '}';
    }

    static interface IntSupplier {
        public int get();
    }
}

