/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal.operations;

import android.bluetooth.BluetoothGatt;
import androidx.annotation.RequiresApi;
import bleshadow.javax.inject.Inject;
import com.polidea.rxandroidble2.exceptions.BleGattCannotStartException;
import com.polidea.rxandroidble2.exceptions.BleGattOperationType;
import com.polidea.rxandroidble2.internal.SingleResponseOperation;
import com.polidea.rxandroidble2.internal.connection.RxBleGattCallback;
import com.polidea.rxandroidble2.internal.operations.TimeoutConfiguration;
import io.reactivex.Scheduler;
import io.reactivex.Single;
import java.util.concurrent.TimeUnit;

public class ConnectionPriorityChangeOperation
extends SingleResponseOperation<Long> {
    private final int connectionPriority;
    private final TimeoutConfiguration successTimeoutConfiguration;

    @Inject
    ConnectionPriorityChangeOperation(RxBleGattCallback rxBleGattCallback, BluetoothGatt bluetoothGatt, TimeoutConfiguration timeoutConfiguration, int connectionPriority, TimeoutConfiguration successTimeoutConfiguration) {
        super(bluetoothGatt, rxBleGattCallback, BleGattOperationType.CONNECTION_PRIORITY_CHANGE, timeoutConfiguration);
        this.connectionPriority = connectionPriority;
        this.successTimeoutConfiguration = successTimeoutConfiguration;
    }

    @Override
    protected Single<Long> getCallback(RxBleGattCallback rxBleGattCallback) {
        return Single.timer((long)this.successTimeoutConfiguration.timeout, (TimeUnit)this.successTimeoutConfiguration.timeoutTimeUnit, (Scheduler)this.successTimeoutConfiguration.timeoutScheduler);
    }

    @Override
    @RequiresApi(value=21)
    protected boolean startOperation(BluetoothGatt bluetoothGatt) throws IllegalArgumentException, BleGattCannotStartException {
        return bluetoothGatt.requestConnectionPriority(this.connectionPriority);
    }

    @Override
    public String toString() {
        return "ConnectionPriorityChangeOperation{" + super.toString() + ", connectionPriority=" + this.connectionPriorityToString(this.connectionPriority) + ", successTimeout=" + this.successTimeoutConfiguration + '}';
    }

    private String connectionPriorityToString(int connectionPriority) {
        switch (connectionPriority) {
            case 2: {
                return "CONNECTION_PRIORITY_LOW_POWER";
            }
            case 0: {
                return "CONNECTION_PRIORITY_BALANCED";
            }
        }
        return "CONNECTION_PRIORITY_BALANCED";
    }
}

