/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal.operations;

import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import androidx.annotation.RequiresApi;
import bleshadow.javax.inject.Inject;
import bleshadow.javax.inject.Named;
import bleshadow.javax.inject.Provider;
import com.polidea.rxandroidble2.RxBleConnection;
import com.polidea.rxandroidble2.internal.connection.PayloadSizeLimitProvider;
import com.polidea.rxandroidble2.internal.connection.RxBleGattCallback;
import com.polidea.rxandroidble2.internal.logger.LoggerUtilBluetoothServices;
import com.polidea.rxandroidble2.internal.operations.CharacteristicLongWriteOperation;
import com.polidea.rxandroidble2.internal.operations.CharacteristicReadOperation;
import com.polidea.rxandroidble2.internal.operations.CharacteristicWriteOperation;
import com.polidea.rxandroidble2.internal.operations.ConnectionPriorityChangeOperation;
import com.polidea.rxandroidble2.internal.operations.DescriptorReadOperation;
import com.polidea.rxandroidble2.internal.operations.DescriptorWriteOperation;
import com.polidea.rxandroidble2.internal.operations.MtuRequestOperation;
import com.polidea.rxandroidble2.internal.operations.OperationsProvider;
import com.polidea.rxandroidble2.internal.operations.ReadRssiOperation;
import com.polidea.rxandroidble2.internal.operations.ServiceDiscoveryOperation;
import com.polidea.rxandroidble2.internal.operations.TimeoutConfiguration;
import io.reactivex.Scheduler;
import java.util.concurrent.TimeUnit;

public class OperationsProviderImpl
implements OperationsProvider {
    private final RxBleGattCallback rxBleGattCallback;
    private final BluetoothGatt bluetoothGatt;
    private final LoggerUtilBluetoothServices bleServicesLogger;
    private final TimeoutConfiguration timeoutConfiguration;
    private final Scheduler bluetoothInteractionScheduler;
    private final Scheduler timeoutScheduler;
    private final Provider<ReadRssiOperation> rssiReadOperationProvider;

    @Inject
    OperationsProviderImpl(RxBleGattCallback rxBleGattCallback, BluetoothGatt bluetoothGatt, LoggerUtilBluetoothServices bleServicesLogger, @Named(value="operation-timeout") TimeoutConfiguration timeoutConfiguration, @Named(value="bluetooth_interaction") Scheduler bluetoothInteractionScheduler, @Named(value="timeout") Scheduler timeoutScheduler, Provider<ReadRssiOperation> rssiReadOperationProvider) {
        this.rxBleGattCallback = rxBleGattCallback;
        this.bluetoothGatt = bluetoothGatt;
        this.bleServicesLogger = bleServicesLogger;
        this.timeoutConfiguration = timeoutConfiguration;
        this.bluetoothInteractionScheduler = bluetoothInteractionScheduler;
        this.timeoutScheduler = timeoutScheduler;
        this.rssiReadOperationProvider = rssiReadOperationProvider;
    }

    @Override
    public CharacteristicLongWriteOperation provideLongWriteOperation(BluetoothGattCharacteristic bluetoothGattCharacteristic, RxBleConnection.WriteOperationAckStrategy writeOperationAckStrategy, RxBleConnection.WriteOperationRetryStrategy writeOperationRetryStrategy, PayloadSizeLimitProvider maxBatchSizeProvider, byte[] bytes) {
        return new CharacteristicLongWriteOperation(this.bluetoothGatt, this.rxBleGattCallback, this.bluetoothInteractionScheduler, this.timeoutConfiguration, bluetoothGattCharacteristic, maxBatchSizeProvider, writeOperationAckStrategy, writeOperationRetryStrategy, bytes);
    }

    @Override
    @RequiresApi(value=21)
    public MtuRequestOperation provideMtuChangeOperation(int requestedMtu) {
        return new MtuRequestOperation(this.rxBleGattCallback, this.bluetoothGatt, this.timeoutConfiguration, requestedMtu);
    }

    @Override
    public CharacteristicReadOperation provideReadCharacteristic(BluetoothGattCharacteristic characteristic) {
        return new CharacteristicReadOperation(this.rxBleGattCallback, this.bluetoothGatt, this.timeoutConfiguration, characteristic);
    }

    @Override
    public DescriptorReadOperation provideReadDescriptor(BluetoothGattDescriptor descriptor) {
        return new DescriptorReadOperation(this.rxBleGattCallback, this.bluetoothGatt, this.timeoutConfiguration, descriptor);
    }

    @Override
    public ReadRssiOperation provideRssiReadOperation() {
        return (ReadRssiOperation)this.rssiReadOperationProvider.get();
    }

    @Override
    public ServiceDiscoveryOperation provideServiceDiscoveryOperation(long timeout, TimeUnit timeUnit) {
        return new ServiceDiscoveryOperation(this.rxBleGattCallback, this.bluetoothGatt, this.bleServicesLogger, new TimeoutConfiguration(timeout, timeUnit, this.timeoutScheduler));
    }

    @Override
    public CharacteristicWriteOperation provideWriteCharacteristic(BluetoothGattCharacteristic characteristic, byte[] data) {
        return new CharacteristicWriteOperation(this.rxBleGattCallback, this.bluetoothGatt, this.timeoutConfiguration, characteristic, data);
    }

    @Override
    public DescriptorWriteOperation provideWriteDescriptor(BluetoothGattDescriptor bluetoothGattDescriptor, byte[] data) {
        return new DescriptorWriteOperation(this.rxBleGattCallback, this.bluetoothGatt, this.timeoutConfiguration, 2, bluetoothGattDescriptor, data);
    }

    @Override
    @RequiresApi(value=21)
    public ConnectionPriorityChangeOperation provideConnectionPriorityChangeOperation(int connectionPriority, long delay, TimeUnit timeUnit) {
        return new ConnectionPriorityChangeOperation(this.rxBleGattCallback, this.bluetoothGatt, this.timeoutConfiguration, connectionPriority, new TimeoutConfiguration(delay, timeUnit, this.timeoutScheduler));
    }
}

