/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal.operations;

import android.bluetooth.BluetoothGatt;
import androidx.annotation.NonNull;
import com.polidea.rxandroidble2.RxBleDeviceServices;
import com.polidea.rxandroidble2.exceptions.BleGattCallbackTimeoutException;
import com.polidea.rxandroidble2.exceptions.BleGattOperationType;
import com.polidea.rxandroidble2.internal.SingleResponseOperation;
import com.polidea.rxandroidble2.internal.connection.RxBleGattCallback;
import com.polidea.rxandroidble2.internal.logger.LoggerUtilBluetoothServices;
import com.polidea.rxandroidble2.internal.operations.TimeoutConfiguration;
import io.reactivex.Scheduler;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public class ServiceDiscoveryOperation
extends SingleResponseOperation<RxBleDeviceServices> {
    private final BluetoothGatt bluetoothGatt;
    private final LoggerUtilBluetoothServices bleServicesLogger;

    ServiceDiscoveryOperation(RxBleGattCallback rxBleGattCallback, BluetoothGatt bluetoothGatt, LoggerUtilBluetoothServices bleServicesLogger, TimeoutConfiguration timeoutConfiguration) {
        super(bluetoothGatt, rxBleGattCallback, BleGattOperationType.SERVICE_DISCOVERY, timeoutConfiguration);
        this.bluetoothGatt = bluetoothGatt;
        this.bleServicesLogger = bleServicesLogger;
    }

    @Override
    protected Single<RxBleDeviceServices> getCallback(RxBleGattCallback rxBleGattCallback) {
        return rxBleGattCallback.getOnServicesDiscovered().firstOrError().doOnSuccess((Consumer)new Consumer<RxBleDeviceServices>(){

            public void accept(RxBleDeviceServices rxBleDeviceServices) throws Exception {
                ServiceDiscoveryOperation.this.bleServicesLogger.log(rxBleDeviceServices, ServiceDiscoveryOperation.this.bluetoothGatt.getDevice());
            }
        });
    }

    @Override
    protected boolean startOperation(BluetoothGatt bluetoothGatt) {
        return bluetoothGatt.discoverServices();
    }

    @Override
    @NonNull
    protected Single<RxBleDeviceServices> timeoutFallbackProcedure(final BluetoothGatt bluetoothGatt, RxBleGattCallback rxBleGattCallback, final Scheduler timeoutScheduler) {
        return Single.defer((Callable)new Callable<SingleSource<? extends RxBleDeviceServices>>(){

            @Override
            public SingleSource<? extends RxBleDeviceServices> call() throws Exception {
                List services = bluetoothGatt.getServices();
                if (services.size() == 0) {
                    return Single.error((Throwable)new BleGattCallbackTimeoutException(bluetoothGatt, BleGattOperationType.SERVICE_DISCOVERY));
                }
                return Single.timer((long)5L, (TimeUnit)TimeUnit.SECONDS, (Scheduler)timeoutScheduler).flatMap((Function)new Function<Long, Single<RxBleDeviceServices>>(){

                    public Single<RxBleDeviceServices> apply(Long delayedSeconds) {
                        return Single.fromCallable((Callable)new Callable<RxBleDeviceServices>(){

                            @Override
                            public RxBleDeviceServices call() throws Exception {
                                return new RxBleDeviceServices(bluetoothGatt.getServices());
                            }
                        });
                    }
                });
            }
        });
    }

    @Override
    public String toString() {
        return "ServiceDiscoveryOperation{" + super.toString() + '}';
    }
}

