/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal.serialization;

import androidx.annotation.RestrictTo;
import bleshadow.javax.inject.Inject;
import bleshadow.javax.inject.Named;
import com.polidea.rxandroidble2.internal.RxBleLog;
import com.polidea.rxandroidble2.internal.logger.LoggerUtil;
import com.polidea.rxandroidble2.internal.operations.Operation;
import com.polidea.rxandroidble2.internal.serialization.ClientOperationQueue;
import com.polidea.rxandroidble2.internal.serialization.FIFORunnableEntry;
import com.polidea.rxandroidble2.internal.serialization.OperationPriorityFifoBlockingQueue;
import com.polidea.rxandroidble2.internal.serialization.QueueSemaphore;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposables;
import io.reactivex.functions.Action;

public class ClientOperationQueueImpl
implements ClientOperationQueue {
    private OperationPriorityFifoBlockingQueue queue = new OperationPriorityFifoBlockingQueue();

    @Inject
    public ClientOperationQueueImpl(final @Named(value="bluetooth_interaction") Scheduler callbackScheduler) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            FIFORunnableEntry<?> entry = ClientOperationQueueImpl.this.queue.take();
                            Operation operation = entry.operation;
                            long startedAtTime = System.currentTimeMillis();
                            LoggerUtil.logOperationStarted(operation);
                            LoggerUtil.logOperationRunning(operation);
                            QueueSemaphore clientOperationSemaphore = new QueueSemaphore();
                            entry.run(clientOperationSemaphore, callbackScheduler);
                            clientOperationSemaphore.awaitRelease();
                            LoggerUtil.logOperationFinished(operation, startedAtTime, System.currentTimeMillis());
                        }
                    }
                    catch (InterruptedException e) {
                        RxBleLog.e(e, "Error while processing client operation queue", new Object[0]);
                        continue;
                    }
                    break;
                }
            }
        }).start();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public <T> Observable<T> queue(final Operation<T> operation) {
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<T>(){

            public void subscribe(ObservableEmitter<T> tEmitter) throws Exception {
                final FIFORunnableEntry entry = new FIFORunnableEntry(operation, tEmitter);
                tEmitter.setDisposable(Disposables.fromAction((Action)new Action(){

                    public void run() throws Exception {
                        if (ClientOperationQueueImpl.this.queue.remove(entry)) {
                            LoggerUtil.logOperationRemoved(operation);
                        }
                    }
                }));
                LoggerUtil.logOperationQueued(operation);
                ClientOperationQueueImpl.this.queue.add(entry);
            }
        });
    }
}

