/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal.serialization;

import androidx.annotation.RestrictTo;
import bleshadow.javax.inject.Inject;
import bleshadow.javax.inject.Named;
import com.polidea.rxandroidble2.exceptions.BleDisconnectedException;
import com.polidea.rxandroidble2.exceptions.BleException;
import com.polidea.rxandroidble2.internal.RxBleLog;
import com.polidea.rxandroidble2.internal.connection.ConnectionScope;
import com.polidea.rxandroidble2.internal.connection.ConnectionSubscriptionWatcher;
import com.polidea.rxandroidble2.internal.connection.DisconnectionRouterOutput;
import com.polidea.rxandroidble2.internal.logger.LoggerUtil;
import com.polidea.rxandroidble2.internal.operations.Operation;
import com.polidea.rxandroidble2.internal.serialization.ConnectionOperationQueue;
import com.polidea.rxandroidble2.internal.serialization.FIFORunnableEntry;
import com.polidea.rxandroidble2.internal.serialization.OperationPriorityFifoBlockingQueue;
import com.polidea.rxandroidble2.internal.serialization.QueueSemaphore;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.functions.Cancellable;
import io.reactivex.observers.DisposableObserver;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ConnectionScope
public class ConnectionOperationQueueImpl
implements ConnectionOperationQueue,
ConnectionSubscriptionWatcher {
    private final String deviceMacAddress;
    private final DisconnectionRouterOutput disconnectionRouterOutput;
    private DisposableObserver<BleException> disconnectionThrowableSubscription;
    private final OperationPriorityFifoBlockingQueue queue = new OperationPriorityFifoBlockingQueue();
    private final Future<?> runnableFuture;
    private volatile boolean shouldRun = true;
    private BleException disconnectionException = null;

    @Inject
    ConnectionOperationQueueImpl(final @Named(value="mac-address") String deviceMacAddress, DisconnectionRouterOutput disconnectionRouterOutput, @Named(value="executor_connection_queue") ExecutorService executorService, final @Named(value="bluetooth_interaction") Scheduler callbackScheduler) {
        this.deviceMacAddress = deviceMacAddress;
        this.disconnectionRouterOutput = disconnectionRouterOutput;
        this.runnableFuture = executorService.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (ConnectionOperationQueueImpl.this.shouldRun) {
                    try {
                        FIFORunnableEntry<?> entry = ConnectionOperationQueueImpl.this.queue.take();
                        Operation operation = entry.operation;
                        long startedAtTime = System.currentTimeMillis();
                        LoggerUtil.logOperationStarted(operation);
                        LoggerUtil.logOperationRunning(operation);
                        QueueSemaphore currentSemaphore = new QueueSemaphore();
                        entry.run(currentSemaphore, callbackScheduler);
                        currentSemaphore.awaitRelease();
                        LoggerUtil.logOperationFinished(operation, startedAtTime, System.currentTimeMillis());
                    }
                    catch (InterruptedException e) {
                        ConnectionOperationQueueImpl connectionOperationQueueImpl = ConnectionOperationQueueImpl.this;
                        synchronized (connectionOperationQueueImpl) {
                            if (!ConnectionOperationQueueImpl.this.shouldRun) {
                                break;
                            }
                        }
                        RxBleLog.e(e, "Error while processing connection operation queue", new Object[0]);
                    }
                }
                ConnectionOperationQueueImpl.this.flushQueue();
                RxBleLog.v("Terminated (%s)", LoggerUtil.commonMacMessage(deviceMacAddress));
            }
        });
    }

    private synchronized void flushQueue() {
        while (!this.queue.isEmpty()) {
            FIFORunnableEntry<?> entryToFinish = this.queue.takeNow();
            entryToFinish.operationResultObserver.tryOnError((Throwable)this.disconnectionException);
        }
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public synchronized <T> Observable<T> queue(final Operation<T> operation) {
        if (!this.shouldRun) {
            return Observable.error((Throwable)this.disconnectionException);
        }
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<T>(){

            public void subscribe(ObservableEmitter<T> emitter) throws Exception {
                final FIFORunnableEntry entry = new FIFORunnableEntry(operation, emitter);
                emitter.setCancellable(new Cancellable(){

                    public void cancel() throws Exception {
                        if (ConnectionOperationQueueImpl.this.queue.remove(entry)) {
                            LoggerUtil.logOperationRemoved(operation);
                        }
                    }
                });
                LoggerUtil.logOperationQueued(operation);
                ConnectionOperationQueueImpl.this.queue.add(entry);
            }
        });
    }

    @Override
    public synchronized void terminate(BleException disconnectException) {
        if (this.disconnectionException != null) {
            return;
        }
        RxBleLog.d(disconnectException, "Connection operations queue to be terminated (%s)", LoggerUtil.commonMacMessage(this.deviceMacAddress));
        this.shouldRun = false;
        this.disconnectionException = disconnectException;
        this.runnableFuture.cancel(true);
    }

    @Override
    public void onConnectionSubscribed() {
        this.disconnectionThrowableSubscription = (DisposableObserver)this.disconnectionRouterOutput.asValueOnlyObservable().subscribeWith((Observer)new DisposableObserver<BleException>(){

            public void onComplete() {
            }

            public void onNext(BleException bleException) {
                ConnectionOperationQueueImpl.this.terminate(bleException);
            }

            public void onError(Throwable throwable) {
            }
        });
    }

    @Override
    public void onConnectionUnsubscribed() {
        this.disconnectionThrowableSubscription.dispose();
        this.disconnectionThrowableSubscription = null;
        this.terminate(new BleDisconnectedException(this.deviceMacAddress, -1));
    }
}

