/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal.util;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.content.Context;
import android.os.Build;
import bleshadow.javax.inject.Inject;
import com.polidea.rxandroidble2.internal.RxBleLog;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class BleConnectionCompat {
    private final Context context;

    @Inject
    public BleConnectionCompat(Context context) {
        this.context = context;
    }

    public BluetoothGatt connectGatt(BluetoothDevice remoteDevice, boolean autoConnect, BluetoothGattCallback bluetoothGattCallback) {
        if (remoteDevice == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 24 || !autoConnect) {
            return this.connectGattCompat(bluetoothGattCallback, remoteDevice, autoConnect);
        }
        try {
            RxBleLog.v("Trying to connectGatt using reflection.", new Object[0]);
            Object iBluetoothGatt = this.getIBluetoothGatt(this.getIBluetoothManager());
            if (iBluetoothGatt == null) {
                RxBleLog.w("Couldn't get iBluetoothGatt object", new Object[0]);
                return this.connectGattCompat(bluetoothGattCallback, remoteDevice, true);
            }
            BluetoothGatt bluetoothGatt = this.createBluetoothGatt(iBluetoothGatt, remoteDevice);
            if (bluetoothGatt == null) {
                RxBleLog.w("Couldn't create BluetoothGatt object", new Object[0]);
                return this.connectGattCompat(bluetoothGattCallback, remoteDevice, true);
            }
            boolean connectedSuccessfully = this.connectUsingReflection(bluetoothGatt, bluetoothGattCallback, true);
            if (!connectedSuccessfully) {
                RxBleLog.w("Connection using reflection failed, closing gatt", new Object[0]);
                bluetoothGatt.close();
            }
            return bluetoothGatt;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException exception) {
            RxBleLog.w(exception, "Error while trying to connect via reflection", new Object[0]);
            return this.connectGattCompat(bluetoothGattCallback, remoteDevice, true);
        }
    }

    private BluetoothGatt connectGattCompat(BluetoothGattCallback bluetoothGattCallback, BluetoothDevice device, boolean autoConnect) {
        RxBleLog.v("Connecting without reflection", new Object[0]);
        if (Build.VERSION.SDK_INT >= 23) {
            return device.connectGatt(this.context, autoConnect, bluetoothGattCallback, 2);
        }
        return device.connectGatt(this.context, autoConnect, bluetoothGattCallback);
    }

    private boolean connectUsingReflection(BluetoothGatt bluetoothGatt, BluetoothGattCallback bluetoothGattCallback, boolean autoConnect) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, NoSuchFieldException {
        RxBleLog.v("Connecting using reflection", new Object[0]);
        this.setAutoConnectValue(bluetoothGatt, autoConnect);
        Method connectMethod = bluetoothGatt.getClass().getDeclaredMethod("connect", Boolean.class, BluetoothGattCallback.class);
        connectMethod.setAccessible(true);
        return (Boolean)connectMethod.invoke((Object)bluetoothGatt, true, bluetoothGattCallback);
    }

    @TargetApi(value=23)
    private BluetoothGatt createBluetoothGatt(Object iBluetoothGatt, BluetoothDevice remoteDevice) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        Constructor<?> bluetoothGattConstructor = BluetoothGatt.class.getDeclaredConstructors()[0];
        bluetoothGattConstructor.setAccessible(true);
        RxBleLog.v("Found constructor with args count = " + bluetoothGattConstructor.getParameterTypes().length, new Object[0]);
        if (bluetoothGattConstructor.getParameterTypes().length == 4) {
            return (BluetoothGatt)bluetoothGattConstructor.newInstance(this.context, iBluetoothGatt, remoteDevice, 2);
        }
        return (BluetoothGatt)bluetoothGattConstructor.newInstance(this.context, iBluetoothGatt, remoteDevice);
    }

    private Object getIBluetoothGatt(Object iBluetoothManager) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (iBluetoothManager == null) {
            return null;
        }
        Method getBluetoothGattMethod = this.getMethodFromClass(iBluetoothManager.getClass(), "getBluetoothGatt");
        return getBluetoothGattMethod.invoke(iBluetoothManager, new Object[0]);
    }

    private Object getIBluetoothManager() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (bluetoothAdapter == null) {
            return null;
        }
        Method getBluetoothManagerMethod = this.getMethodFromClass(bluetoothAdapter.getClass(), "getBluetoothManager");
        return getBluetoothManagerMethod.invoke((Object)bluetoothAdapter, new Object[0]);
    }

    private Method getMethodFromClass(Class<?> cls, String methodName) throws NoSuchMethodException {
        Method method = cls.getDeclaredMethod(methodName, new Class[0]);
        method.setAccessible(true);
        return method;
    }

    private void setAutoConnectValue(BluetoothGatt bluetoothGatt, boolean autoConnect) throws NoSuchFieldException, IllegalAccessException {
        Field autoConnectField = bluetoothGatt.getClass().getDeclaredField("mAutoConnect");
        autoConnectField.setAccessible(true);
        autoConnectField.setBoolean(bluetoothGatt, autoConnect);
    }
}

