/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import androidx.annotation.NonNull;
import bleshadow.javax.inject.Inject;
import com.polidea.rxandroidble2.internal.RxBleLog;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.Observer;
import io.reactivex.functions.Cancellable;
import io.reactivex.schedulers.Schedulers;

public class RxBleAdapterStateObservable
extends Observable<BleAdapterState> {
    @NonNull
    private final Observable<BleAdapterState> bleAdapterStateObservable;

    @Inject
    public RxBleAdapterStateObservable(final @NonNull Context context) {
        this.bleAdapterStateObservable = Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<BleAdapterState>(){

            public void subscribe(final ObservableEmitter<BleAdapterState> emitter) {
                final BroadcastReceiver receiver = new BroadcastReceiver(){

                    public void onReceive(Context context, Intent intent) {
                        int state = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", -1);
                        BleAdapterState internalState = RxBleAdapterStateObservable.mapToBleAdapterState(state);
                        RxBleLog.i("Adapter state changed: %s", internalState);
                        emitter.onNext((Object)internalState);
                    }
                };
                context.registerReceiver(receiver, new IntentFilter("android.bluetooth.adapter.action.STATE_CHANGED"));
                emitter.setCancellable(new Cancellable(){

                    public void cancel() {
                        context.unregisterReceiver(receiver);
                    }
                });
            }
        }).subscribeOn(Schedulers.trampoline()).unsubscribeOn(Schedulers.trampoline()).share();
    }

    protected void subscribeActual(Observer<? super BleAdapterState> observer) {
        this.bleAdapterStateObservable.subscribe(observer);
    }

    private static BleAdapterState mapToBleAdapterState(int state) {
        switch (state) {
            case 12: {
                return BleAdapterState.STATE_ON;
            }
            case 11: {
                return BleAdapterState.STATE_TURNING_ON;
            }
            case 13: {
                return BleAdapterState.STATE_TURNING_OFF;
            }
        }
        return BleAdapterState.STATE_OFF;
    }

    public static class BleAdapterState {
        public static final BleAdapterState STATE_ON = new BleAdapterState(true, "STATE_ON");
        public static final BleAdapterState STATE_OFF = new BleAdapterState(false, "STATE_OFF");
        public static final BleAdapterState STATE_TURNING_ON = new BleAdapterState(false, "STATE_TURNING_ON");
        public static final BleAdapterState STATE_TURNING_OFF = new BleAdapterState(false, "STATE_TURNING_OFF");
        private final boolean isUsable;
        private final String stateName;

        private BleAdapterState(boolean isUsable, String stateName) {
            this.isUsable = isUsable;
            this.stateName = stateName;
        }

        public boolean isUsable() {
            return this.isUsable;
        }

        @NonNull
        public String toString() {
            return this.stateName;
        }
    }
}

