/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2;

import android.bluetooth.BluetoothDevice;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import bleshadow.dagger.Lazy;
import bleshadow.javax.inject.Inject;
import bleshadow.javax.inject.Named;
import com.polidea.rxandroidble2.ClientComponent;
import com.polidea.rxandroidble2.RxBleAdapterStateObservable;
import com.polidea.rxandroidble2.RxBleClient;
import com.polidea.rxandroidble2.RxBleDevice;
import com.polidea.rxandroidble2.RxBleScanResult;
import com.polidea.rxandroidble2.exceptions.BleScanException;
import com.polidea.rxandroidble2.internal.RxBleDeviceProvider;
import com.polidea.rxandroidble2.internal.RxBleLog;
import com.polidea.rxandroidble2.internal.operations.LegacyScanOperation;
import com.polidea.rxandroidble2.internal.operations.Operation;
import com.polidea.rxandroidble2.internal.scan.RxBleInternalScanResult;
import com.polidea.rxandroidble2.internal.scan.RxBleInternalScanResultLegacy;
import com.polidea.rxandroidble2.internal.scan.ScanPreconditionsVerifier;
import com.polidea.rxandroidble2.internal.scan.ScanSetup;
import com.polidea.rxandroidble2.internal.scan.ScanSetupBuilder;
import com.polidea.rxandroidble2.internal.serialization.ClientOperationQueue;
import com.polidea.rxandroidble2.internal.util.ClientStateObservable;
import com.polidea.rxandroidble2.internal.util.LocationServicesStatus;
import com.polidea.rxandroidble2.internal.util.RxBleAdapterWrapper;
import com.polidea.rxandroidble2.internal.util.UUIDUtil;
import com.polidea.rxandroidble2.scan.BackgroundScanner;
import com.polidea.rxandroidble2.scan.ScanFilter;
import com.polidea.rxandroidble2.scan.ScanResult;
import com.polidea.rxandroidble2.scan.ScanSettings;
import io.reactivex.Maybe;
import io.reactivex.MaybeSource;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Scheduler;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;

class RxBleClientImpl
extends RxBleClient {
    @Deprecated
    public static final String TAG = "RxBleClient";
    private final ClientOperationQueue operationQueue;
    private final UUIDUtil uuidUtil;
    private final RxBleDeviceProvider rxBleDeviceProvider;
    private final ScanSetupBuilder scanSetupBuilder;
    private final ScanPreconditionsVerifier scanPreconditionVerifier;
    private final Function<RxBleInternalScanResult, ScanResult> internalToExternalScanResultMapFunction;
    private final ClientComponent.ClientComponentFinalizer clientComponentFinalizer;
    private final Scheduler bluetoothInteractionScheduler;
    private final Map<Set<UUID>, Observable<RxBleScanResult>> queuedScanOperations = new HashMap<Set<UUID>, Observable<RxBleScanResult>>();
    private final RxBleAdapterWrapper rxBleAdapterWrapper;
    private final Observable<RxBleAdapterStateObservable.BleAdapterState> rxBleAdapterStateObservable;
    private final LocationServicesStatus locationServicesStatus;
    private final Lazy<ClientStateObservable> lazyClientStateObservable;
    private final BackgroundScanner backgroundScanner;

    @Inject
    RxBleClientImpl(RxBleAdapterWrapper rxBleAdapterWrapper, ClientOperationQueue operationQueue, Observable<RxBleAdapterStateObservable.BleAdapterState> adapterStateObservable, UUIDUtil uuidUtil, LocationServicesStatus locationServicesStatus, Lazy<ClientStateObservable> lazyClientStateObservable, RxBleDeviceProvider rxBleDeviceProvider, ScanSetupBuilder scanSetupBuilder, ScanPreconditionsVerifier scanPreconditionVerifier, Function<RxBleInternalScanResult, ScanResult> internalToExternalScanResultMapFunction, @Named(value="bluetooth_interaction") Scheduler bluetoothInteractionScheduler, ClientComponent.ClientComponentFinalizer clientComponentFinalizer, BackgroundScanner backgroundScanner) {
        this.uuidUtil = uuidUtil;
        this.operationQueue = operationQueue;
        this.rxBleAdapterWrapper = rxBleAdapterWrapper;
        this.rxBleAdapterStateObservable = adapterStateObservable;
        this.locationServicesStatus = locationServicesStatus;
        this.lazyClientStateObservable = lazyClientStateObservable;
        this.rxBleDeviceProvider = rxBleDeviceProvider;
        this.scanSetupBuilder = scanSetupBuilder;
        this.scanPreconditionVerifier = scanPreconditionVerifier;
        this.internalToExternalScanResultMapFunction = internalToExternalScanResultMapFunction;
        this.bluetoothInteractionScheduler = bluetoothInteractionScheduler;
        this.clientComponentFinalizer = clientComponentFinalizer;
        this.backgroundScanner = backgroundScanner;
    }

    protected void finalize() throws Throwable {
        this.clientComponentFinalizer.onFinalize();
        super.finalize();
    }

    @Override
    public RxBleDevice getBleDevice(@NonNull String macAddress) {
        this.guardBluetoothAdapterAvailable();
        return this.rxBleDeviceProvider.getBleDevice(macAddress);
    }

    @Override
    public Set<RxBleDevice> getBondedDevices() {
        this.guardBluetoothAdapterAvailable();
        HashSet<RxBleDevice> rxBleDevices = new HashSet<RxBleDevice>();
        Set<BluetoothDevice> bluetoothDevices = this.rxBleAdapterWrapper.getBondedDevices();
        for (BluetoothDevice bluetoothDevice : bluetoothDevices) {
            rxBleDevices.add(this.getBleDevice(bluetoothDevice.getAddress()));
        }
        return rxBleDevices;
    }

    @Override
    public Observable<ScanResult> scanBleDevices(final ScanSettings scanSettings, final ScanFilter ... scanFilters) {
        return Observable.defer((Callable)new Callable<ObservableSource<? extends ScanResult>>(){

            @Override
            public Observable<ScanResult> call() {
                RxBleClientImpl.this.scanPreconditionVerifier.verify(scanSettings.shouldCheckLocationProviderState());
                ScanSetup scanSetup = RxBleClientImpl.this.scanSetupBuilder.build(scanSettings, scanFilters);
                Operation<RxBleInternalScanResult> scanOperation = scanSetup.scanOperation;
                return RxBleClientImpl.this.operationQueue.queue(scanOperation).unsubscribeOn(RxBleClientImpl.this.bluetoothInteractionScheduler).compose(scanSetup.scanOperationBehaviourEmulatorTransformer).map(RxBleClientImpl.this.internalToExternalScanResultMapFunction).doOnNext((Consumer)new Consumer<ScanResult>(){

                    public void accept(ScanResult scanResult) {
                        if (RxBleLog.getShouldLogScannedPeripherals()) {
                            RxBleLog.i("%s", scanResult);
                        }
                    }
                }).mergeWith((ObservableSource)RxBleClientImpl.this.bluetoothAdapterOffExceptionObservable());
            }
        });
    }

    @Override
    public BackgroundScanner getBackgroundScanner() {
        return this.backgroundScanner;
    }

    @Override
    public Observable<RxBleScanResult> scanBleDevices(final UUID ... filterServiceUUIDs) {
        return Observable.defer((Callable)new Callable<ObservableSource<? extends RxBleScanResult>>(){

            @Override
            public ObservableSource<? extends RxBleScanResult> call() throws Exception {
                RxBleClientImpl.this.scanPreconditionVerifier.verify(true);
                return RxBleClientImpl.this.initializeScan(filterServiceUUIDs);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Observable<RxBleScanResult> initializeScan(@Nullable UUID[] filterServiceUUIDs) {
        Set<UUID> filteredUUIDs = this.uuidUtil.toDistinctSet(filterServiceUUIDs);
        Map<Set<UUID>, Observable<RxBleScanResult>> map = this.queuedScanOperations;
        synchronized (map) {
            Observable<RxBleScanResult> matchingQueuedScan = this.queuedScanOperations.get(filteredUUIDs);
            if (matchingQueuedScan == null) {
                matchingQueuedScan = this.createScanOperationApi18(filterServiceUUIDs);
                this.queuedScanOperations.put(filteredUUIDs, matchingQueuedScan);
            }
            return matchingQueuedScan;
        }
    }

    private <T> Observable<T> bluetoothAdapterOffExceptionObservable() {
        return this.rxBleAdapterStateObservable.filter((Predicate)new Predicate<RxBleAdapterStateObservable.BleAdapterState>(){

            public boolean test(RxBleAdapterStateObservable.BleAdapterState state) throws Exception {
                return state != RxBleAdapterStateObservable.BleAdapterState.STATE_ON;
            }
        }).firstElement().flatMap(new Function<RxBleAdapterStateObservable.BleAdapterState, MaybeSource<T>>(){

            public MaybeSource<T> apply(RxBleAdapterStateObservable.BleAdapterState bleAdapterState) throws Exception {
                return Maybe.error((Throwable)new BleScanException(1));
            }
        }).toObservable();
    }

    private RxBleScanResult convertToPublicScanResult(RxBleInternalScanResultLegacy scanResult) {
        BluetoothDevice bluetoothDevice = scanResult.getBluetoothDevice();
        RxBleDevice bleDevice = this.getBleDevice(bluetoothDevice.getAddress());
        return new RxBleScanResult(bleDevice, scanResult.getRssi(), scanResult.getScanRecord());
    }

    private Observable<RxBleScanResult> createScanOperationApi18(@Nullable UUID[] filterServiceUUIDs) {
        final Set<UUID> filteredUUIDs = this.uuidUtil.toDistinctSet(filterServiceUUIDs);
        LegacyScanOperation scanOperation = new LegacyScanOperation(filterServiceUUIDs, this.rxBleAdapterWrapper, this.uuidUtil);
        return this.operationQueue.queue(scanOperation).doFinally(new Action(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws Exception {
                Map map = RxBleClientImpl.this.queuedScanOperations;
                synchronized (map) {
                    RxBleClientImpl.this.queuedScanOperations.remove(filteredUUIDs);
                }
            }
        }).mergeWith(this.bluetoothAdapterOffExceptionObservable()).map((Function)new Function<RxBleInternalScanResultLegacy, RxBleScanResult>(){

            public RxBleScanResult apply(RxBleInternalScanResultLegacy scanResult) {
                return RxBleClientImpl.this.convertToPublicScanResult(scanResult);
            }
        }).doOnNext((Consumer)new Consumer<RxBleScanResult>(){

            public void accept(RxBleScanResult rxBleScanResult) {
                RxBleLog.i("%s", rxBleScanResult);
            }
        }).share();
    }

    private void guardBluetoothAdapterAvailable() {
        if (!this.rxBleAdapterWrapper.hasBluetoothAdapter()) {
            throw new UnsupportedOperationException("RxAndroidBle library needs a BluetoothAdapter to be available in the system to work. If this is a test on an emulator then you can use 'https://github.com/Polidea/RxAndroidBle/tree/master/mockrxandroidble'");
        }
    }

    @Override
    public Observable<RxBleClient.State> observeStateChanges() {
        return (Observable)this.lazyClientStateObservable.get();
    }

    @Override
    public RxBleClient.State getState() {
        if (!this.rxBleAdapterWrapper.hasBluetoothAdapter()) {
            return RxBleClient.State.BLUETOOTH_NOT_AVAILABLE;
        }
        if (!this.locationServicesStatus.isLocationPermissionOk()) {
            return RxBleClient.State.LOCATION_PERMISSION_NOT_GRANTED;
        }
        if (!this.rxBleAdapterWrapper.isBluetoothEnabled()) {
            return RxBleClient.State.BLUETOOTH_NOT_ENABLED;
        }
        if (!this.locationServicesStatus.isLocationProviderOk()) {
            return RxBleClient.State.LOCATION_SERVICES_NOT_ENABLED;
        }
        return RxBleClient.State.READY;
    }
}

