/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.exceptions;

import android.bluetooth.BluetoothGattCharacteristic;
import androidx.annotation.RestrictTo;
import com.polidea.rxandroidble2.exceptions.BleException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class BleCannotSetCharacteristicNotificationException
extends BleException {
    @Deprecated
    public static final int UNKNOWN = -1;
    public static final int CANNOT_SET_LOCAL_NOTIFICATION = 1;
    public static final int CANNOT_FIND_CLIENT_CHARACTERISTIC_CONFIG_DESCRIPTOR = 2;
    public static final int CANNOT_WRITE_CLIENT_CHARACTERISTIC_CONFIG_DESCRIPTOR = 3;
    private final BluetoothGattCharacteristic bluetoothGattCharacteristic;
    private final int reason;

    @Deprecated
    public BleCannotSetCharacteristicNotificationException(BluetoothGattCharacteristic bluetoothGattCharacteristic) {
        super(BleCannotSetCharacteristicNotificationException.createMessage(bluetoothGattCharacteristic, -1));
        this.bluetoothGattCharacteristic = bluetoothGattCharacteristic;
        this.reason = -1;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public BleCannotSetCharacteristicNotificationException(BluetoothGattCharacteristic bluetoothGattCharacteristic, int reason, Throwable cause) {
        super(BleCannotSetCharacteristicNotificationException.createMessage(bluetoothGattCharacteristic, reason), cause);
        this.bluetoothGattCharacteristic = bluetoothGattCharacteristic;
        this.reason = reason;
    }

    public BluetoothGattCharacteristic getBluetoothGattCharacteristic() {
        return this.bluetoothGattCharacteristic;
    }

    public int getReason() {
        return this.reason;
    }

    private static String createMessage(BluetoothGattCharacteristic bluetoothGattCharacteristic, int reason) {
        return BleCannotSetCharacteristicNotificationException.reasonDescription(reason) + " (code " + reason + ") with characteristic UUID " + bluetoothGattCharacteristic.getUuid();
    }

    private static String reasonDescription(int reason) {
        switch (reason) {
            case 2: {
                return "Cannot find client characteristic config descriptor";
            }
            case 3: {
                return "Cannot write client characteristic config descriptor";
            }
            case 1: {
                return "Cannot set local notification";
            }
        }
        return "Unknown error";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Reason {
    }
}

